/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.util.MimeType;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;

public class AddCatalogWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String CFG_KEY_CATALOG_NAME = "catalog-name";
    private static final String CFG_KEY_CATALOG_FLAVOR = "catalog-flavor";
    private static final String CFG_KEY_CATALOG_PATH = "catalog-path";
    private static final String CFG_KEY_CATALOG_TAGS = "catalog-tags";
    private static final String CFG_KEY_CATALOG_TYPE_COLLISION_BEHAVIOR = "catalog-type-collision-behavior";
    private static final MimeType CATALOG_MIME_TYPE = MimeType.mimeType((String)"text", (String)"xml");
    private Workspace workspace;

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance wInst, JobContext context) throws WorkflowOperationException {
        String catalogName = this.getConfig(wInst, CFG_KEY_CATALOG_NAME);
        String catalogPath = this.getConfig(wInst, CFG_KEY_CATALOG_PATH);
        String catalogTags = this.getConfig(wInst, CFG_KEY_CATALOG_TAGS, "");
        CatalogTypeCollisionBehavior collBehavior = this.parseCollisionBehavior(this.getConfig(wInst, CFG_KEY_CATALOG_TYPE_COLLISION_BEHAVIOR));
        MediaPackageElementFlavor catalogFlavor = null;
        try {
            catalogFlavor = MediaPackageElementFlavor.parseFlavor((String)this.getConfig(wInst, CFG_KEY_CATALOG_FLAVOR));
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException("Unknown flavor");
        }
        MediaPackage mp = wInst.getMediaPackage();
        if (this.doesCatalogFlavorExist(catalogFlavor, mp.getCatalogs())) {
            if (collBehavior == CatalogTypeCollisionBehavior.FAIL) {
                throw new WorkflowOperationException("Catalog Type already exists and 'fail' was specified");
            }
            if (collBehavior == CatalogTypeCollisionBehavior.SKIP) {
                return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
            }
        }
        File catalogFile = new File(catalogPath);
        String catalogId = UUID.randomUUID().toString();
        URI catalogURI = null;
        try (FileInputStream catalogInputStream = FileUtils.openInputStream((File)catalogFile);){
            catalogURI = this.workspace.put(mp.getIdentifier().toString(), catalogId, catalogName, (InputStream)catalogInputStream);
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        MediaPackageElement mpe = mp.add(catalogURI, MediaPackageElement.Type.Catalog, catalogFlavor);
        mpe.setIdentifier(catalogId);
        mpe.setMimeType(CATALOG_MIME_TYPE);
        for (String tag : this.asList(catalogTags)) {
            mpe.addTag(tag);
        }
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    private boolean doesCatalogFlavorExist(MediaPackageElementFlavor catalogFlavor, Catalog[] catalogs) {
        return Arrays.asList(catalogs).stream().anyMatch(cat -> catalogFlavor.matches(cat.getFlavor()));
    }

    private CatalogTypeCollisionBehavior parseCollisionBehavior(String rawBehavior) throws WorkflowOperationException {
        try {
            return CatalogTypeCollisionBehavior.valueOf(rawBehavior.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException("Workflowoperation configured incorrectly, the configuration 'catalog-type-collision-behavior' only accepts 'skip', 'keep', 'fail'");
        }
    }

    private static enum CatalogTypeCollisionBehavior {
        SKIP,
        KEEP,
        FAIL;

    }
}

