/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.workflow;

import com.entwinemedia.fn.Stream;
import com.entwinemedia.fn.data.Opt;
import com.entwinemedia.fn.fns.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportWorkflowPropertiesWOH
extends AbstractWorkflowOperationHandler {
    public static final String SOURCE_FLAVOR_PROPERTY = "source-flavor";
    public static final String KEYS_PROPERTY = "keys";
    private static final Logger logger = LoggerFactory.getLogger(ImportWorkflowPropertiesWOH.class);
    private Workspace workspace;

    void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance wi, JobContext context) throws WorkflowOperationException {
        logger.info("Start importing workflow properties for workflow {}", (Object)wi);
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(wi, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        Opt<Attachment> propertiesElem = ImportWorkflowPropertiesWOH.loadPropertiesElementFromMediaPackage(sourceFlavor, wi);
        if (propertiesElem.isSome()) {
            Properties properties = ImportWorkflowPropertiesWOH.loadPropertiesFromXml(this.workspace, ((Attachment)propertiesElem.get()).getURI());
            Set keys = Stream.$((Iterable)this.getOptConfig(wi, KEYS_PROPERTY)).bind(Strings.splitCsv).toSet();
            return this.createResult(wi.getMediaPackage(), this.convertToWorkflowProperties(properties, keys), WorkflowOperationResult.Action.CONTINUE, 0L);
        }
        logger.info("No attachment with workflow properties found, skipping...");
        return this.createResult(wi.getMediaPackage(), WorkflowOperationResult.Action.SKIP);
    }

    static Opt<Attachment> loadPropertiesElementFromMediaPackage(MediaPackageElementFlavor sourceFlavor, WorkflowInstance wi) throws WorkflowOperationException {
        MediaPackage mp = wi.getMediaPackage();
        Attachment[] elements = mp.getAttachments(sourceFlavor);
        if (elements.length < 1) {
            logger.info("Cannot import workflow properties - no element with flavor '{}' found in media package '{}'", (Object)sourceFlavor, (Object)mp.getIdentifier());
            return Opt.none();
        }
        if (elements.length > 1) {
            throw new WorkflowOperationException(String.format("Found more than one element with flavor '%s' in media package '%s'", sourceFlavor, mp.getIdentifier()));
        }
        return Opt.some((Object)elements[0]);
    }

    static Properties loadPropertiesFromXml(Workspace workspace, URI uri) throws WorkflowOperationException {
        Properties properties = new Properties();
        try {
            File propertiesFile = workspace.get(uri);
            try (FileInputStream is = new FileInputStream(propertiesFile);){
                properties.loadFromXML(is);
                logger.debug("Properties loaded from {}", (Object)propertiesFile);
            }
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        return properties;
    }

    private Map<String, String> convertToWorkflowProperties(Properties properties, Set<String> keys) {
        HashMap<String, String> workflowProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!keys.isEmpty() && !keys.contains(entry.getKey())) continue;
            workflowProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        return workflowProperties;
    }
}

