/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.parser.JSONParser;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workflow.api.XmlWorkflowParser;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workflow Remote Service Proxy"}, immediate=true, service={WorkflowService.class})
public class WorkflowServiceRemoteImpl
extends RemoteBase
implements WorkflowService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowServiceRemoteImpl.class);

    public WorkflowServiceRemoteImpl() {
        super("org.opencastproject.workflow");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient client) {
        super.setTrustedHttpClient(client);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry remoteServiceManager) {
        this.remoteServiceManager = remoteServiceManager;
    }

    public WorkflowDefinition getWorkflowDefinitionById(String id) throws WorkflowDatabaseException, NotFoundException {
        HttpGet get = new HttpGet("/definition/" + id + ".xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{404, 200});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Workflow definition " + id + " does not exist.");
                }
                WorkflowDefinition workflowDefinition = XmlWorkflowParser.parseWorkflowDefinition((InputStream)response.getEntity().getContent());
                return workflowDefinition;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to connect to a remote workflow service");
    }

    public WorkflowInstance getWorkflowById(long id) throws WorkflowDatabaseException, NotFoundException {
        HttpGet get = new HttpGet("/instance/" + id + ".xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{404, 200});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Workflow instance " + id + " does not exist.");
                }
                WorkflowInstance workflowInstance = XmlWorkflowParser.parseWorkflowInstance((InputStream)response.getEntity().getContent());
                return workflowInstance;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to connect to a remote workflow service");
    }

    public List<WorkflowInstance> getWorkflowInstancesByMediaPackage(String mediaPackageId) throws WorkflowDatabaseException {
        HttpGet get = new HttpGet("/mediaPackage/" + mediaPackageId + "/instances.xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                List list = XmlWorkflowParser.parseWorkflowSet((InputStream)response.getEntity().getContent()).getItems();
                return list;
            }
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Workflow instances can not be loaded from a remote workflow service");
    }

    public Optional<WorkflowInstance> getRunningWorkflowInstanceByMediaPackage(String mediaPackageId, String action) throws WorkflowException {
        HttpGet get = new HttpGet("/mediaPackage/" + mediaPackageId + "/instances.xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{404, 200});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    Optional<WorkflowInstance> optional = Optional.empty();
                    return optional;
                }
                Optional<WorkflowInstance> optional = Optional.ofNullable(XmlWorkflowParser.parseWorkflowInstance((InputStream)response.getEntity().getContent()));
                return optional;
            }
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Workflow instances can not be loaded from a remote workflow service");
    }

    public boolean mediaPackageHasActiveWorkflows(String mediaPackageId) throws WorkflowDatabaseException {
        HttpGet get = new HttpGet("/mediaPackage/" + mediaPackageId + "/hasActiveWorkflows");
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                boolean bl = Boolean.parseBoolean(response.getEntity().getContent().toString());
                return bl;
            }
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Workflow instances can not be loaded from a remote workflow service");
    }

    public boolean userHasActiveWorkflows(String userId) throws WorkflowDatabaseException {
        HttpGet get = new HttpGet("/user/" + userId + "/hasActiveWorkflows");
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                boolean bl = Boolean.parseBoolean(response.getEntity().getContent().toString());
                return bl;
            }
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Workflow instances can not be loaded from a remote workflow service");
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage, Map<String, String> properties) throws WorkflowDatabaseException {
        try {
            return this.start(workflowDefinition, mediaPackage, null, properties);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("A null parent workflow id should never result in a not found exception ", e);
        }
    }

    private String mapToString(Map<String, String> props) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage, Long parentWorkflowId, Map<String, String> properties) throws WorkflowDatabaseException, NotFoundException {
        HttpPost post = new HttpPost("/start");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (workflowDefinition != null) {
                params.add(new BasicNameValuePair("definition", XmlWorkflowParser.toXml((WorkflowDefinition)workflowDefinition)));
            }
            params.add(new BasicNameValuePair("mediapackage", MediaPackageParser.getAsXml((MediaPackage)mediaPackage)));
            if (parentWorkflowId != null) {
                params.add(new BasicNameValuePair("parent", parentWorkflowId.toString()));
            }
            if (properties != null) {
                params.add(new BasicNameValuePair("properties", this.mapToString(properties)));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to assemble a remote workflow request", e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{404, 200});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Workflow instance " + parentWorkflowId + " does not exist.");
                }
                WorkflowInstance workflowInstance = XmlWorkflowParser.parseWorkflowInstance((InputStream)response.getEntity().getContent());
                return workflowInstance;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException("Unable to build a workflow from xml", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to start a remote workflow. The http response code was unexpected.");
    }

    public WorkflowInstance start(WorkflowDefinition workflowDefinition, MediaPackage mediaPackage) throws WorkflowDatabaseException {
        try {
            return this.start(workflowDefinition, mediaPackage, null, null);
        }
        catch (NotFoundException e) {
            throw new IllegalStateException("A null parent workflow id should never result in a not found exception ", e);
        }
    }

    public long countWorkflowInstances() throws WorkflowDatabaseException {
        return this.countWorkflowInstances(null);
    }

    public long countWorkflowInstances(WorkflowInstance.WorkflowState state) throws WorkflowDatabaseException {
        block10: {
            ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
            if (state != null) {
                queryStringParams.add(new BasicNameValuePair("state", state.toString()));
            }
            StringBuilder url = new StringBuilder("/count");
            if (queryStringParams.size() > 0) {
                url.append("?");
                url.append(URLEncodedUtils.format(queryStringParams, (String)"UTF-8"));
            }
            HttpGet get = new HttpGet(url.toString());
            HttpResponse response = this.getResponse((HttpRequestBase)get);
            try {
                if (response == null) break block10;
                String body = null;
                try {
                    body = EntityUtils.toString((HttpEntity)response.getEntity());
                    long l = Long.parseLong(body);
                    return l;
                }
                catch (NumberFormatException e) {
                    try {
                        throw new WorkflowDatabaseException("Unable to parse the response body as a long: " + body);
                    }
                    catch (IOException | ParseException e2) {
                        throw new WorkflowDatabaseException("Unable to parse the response body");
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.closeConnection(response);
            }
        }
        throw new WorkflowDatabaseException("Unable to count workflow instances");
    }

    public WorkflowInstance stop(long workflowInstanceId) throws WorkflowDatabaseException, NotFoundException {
        HttpPost post = new HttpPost("/stop");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("id", Long.toString(workflowInstanceId)));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to assemble a remote workflow service request", e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 404});
        try {
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 404) {
                    throw new NotFoundException("Workflow instance with id='" + workflowInstanceId + "' not found");
                }
                logger.info("Workflow '{}' stopped", (Object)workflowInstanceId);
                WorkflowInstance workflowInstance = XmlWorkflowParser.parseWorkflowInstance((InputStream)response.getEntity().getContent());
                return workflowInstance;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to stop workflow instance " + workflowInstanceId);
    }

    public WorkflowInstance suspend(long workflowInstanceId) throws WorkflowDatabaseException, NotFoundException {
        HttpPost post = new HttpPost("/suspend");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("id", Long.toString(workflowInstanceId)));
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to assemble a remote workflow service request", e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 404});
        try {
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 404) {
                    throw new NotFoundException("Workflow instance with id='" + workflowInstanceId + "' not found");
                }
                logger.info("Workflow '{}' suspended", (Object)workflowInstanceId);
                WorkflowInstance workflowInstance = XmlWorkflowParser.parseWorkflowInstance((InputStream)response.getEntity().getContent());
                return workflowInstance;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to suspend workflow instance " + workflowInstanceId);
    }

    public WorkflowInstance resume(long workflowInstanceId) throws NotFoundException, UnauthorizedException, WorkflowException, IllegalStateException {
        return this.resume(workflowInstanceId, null);
    }

    public WorkflowInstance resume(long workflowInstanceId, Map<String, String> properties) throws NotFoundException, UnauthorizedException, WorkflowException, IllegalStateException {
        HttpPost post = new HttpPost("/resume");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("id", Long.toString(workflowInstanceId)));
        if (properties != null) {
            params.add(new BasicNameValuePair("properties", this.mapToString(properties)));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 404, 401, 409});
        try {
            if (response != null) {
                if (response.getStatusLine().getStatusCode() == 404) {
                    throw new NotFoundException("Workflow instance with id='" + workflowInstanceId + "' not found");
                }
                if (response.getStatusLine().getStatusCode() == 401) {
                    throw new UnauthorizedException("You do not have permission to resume");
                }
                if (response.getStatusLine().getStatusCode() == 409) {
                    throw new IllegalStateException("Can not resume a workflow where the current state is not in paused");
                }
                logger.info("Workflow '{}' resumed", (Object)workflowInstanceId);
                WorkflowInstance workflowInstance = XmlWorkflowParser.parseWorkflowInstance((InputStream)response.getEntity().getContent());
                return workflowInstance;
            }
        }
        catch (IllegalStateException | UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WorkflowException((Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowException("Unable to resume workflow instance " + workflowInstanceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(WorkflowInstance workflowInstance) throws WorkflowDatabaseException {
        HttpPost post = new HttpPost("/update");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("workflow", XmlWorkflowParser.toXml((WorkflowInstance)workflowInstance)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to assemble a remote workflow service request", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to serialize workflow instance to xml");
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{204});
        try {
            if (response != null) {
                logger.info("Workflow '{}' updated", (Object)workflowInstance);
                return;
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to update workflow instance " + workflowInstance.getId());
    }

    public void remove(long workflowInstanceId) throws WorkflowDatabaseException, NotFoundException {
        this.remove(workflowInstanceId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long workflowInstanceId, boolean force) throws WorkflowDatabaseException, NotFoundException {
        String deleteString = "/remove/" + Long.toString(workflowInstanceId);
        if (force) {
            ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
            queryStringParams.add(new BasicNameValuePair("force", "true"));
            deleteString = deleteString + "?" + URLEncodedUtils.format(queryStringParams, (String)"UTF_8");
        }
        HttpDelete delete = new HttpDelete(deleteString);
        HttpResponse response = this.getResponse((HttpRequestBase)delete, new Integer[]{204, 404});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Workflow id not found: " + workflowInstanceId);
                }
                logger.info("Workflow '{}' removed", (Object)workflowInstanceId);
                return;
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to remove workflow instance " + workflowInstanceId);
    }

    public List<WorkflowDefinition> listAvailableWorkflowDefinitions() throws WorkflowDatabaseException {
        HttpGet get = new HttpGet("/definitions.xml");
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                List list = XmlWorkflowParser.parseWorkflowDefinitions((InputStream)response.getEntity().getContent());
                Collections.sort(list);
                List list2 = list;
                return list2;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse workflow definitions");
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to read the registered workflow definitions from the remote workflow service");
    }

    public void addWorkflowListener(WorkflowListener listener) {
        throw new UnsupportedOperationException("Adding workflow listeners to a remote workflow service is not supported");
    }

    public void removeWorkflowListener(WorkflowListener listener) {
        throw new UnsupportedOperationException("Removing workflow listeners from a remote workflow service is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupWorkflowInstances(int lifetime, WorkflowInstance.WorkflowState state) throws WorkflowDatabaseException, UnauthorizedException {
        HttpPost post = new HttpPost("/cleanup");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("lifetime", String.valueOf(lifetime)));
        if (state != null) {
            params.add(new BasicNameValuePair("state", state.toString()));
        }
        try {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to assemble a remote workflow service request", e);
        }
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 401});
        try {
            if (response != null) {
                if (401 == response.getStatusLine().getStatusCode()) {
                    throw new UnauthorizedException("You do not have permission to cleanup");
                }
                logger.info("Successful request to workflow cleanup endpoint");
                return;
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new WorkflowDatabaseException("Unable to successfully request the workflow cleanup endpoint");
    }

    public Map<String, Map<String, String>> getWorkflowStateMappings() {
        HttpGet get = new HttpGet("/statemappings.json");
        HttpResponse response = this.getResponse((HttpRequestBase)get);
        try {
            if (response != null) {
                Map map = (Map)new JSONParser().parse(IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf-8"));
                return map;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to parse workflow state mappings");
        }
        finally {
            this.closeConnection(response);
        }
        return new HashMap<String, Map<String, String>>();
    }
}

