/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opencastproject.util.IoSupport;
import org.opencastproject.workflow.api.JaxbWorkflowConfiguration;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowDefinitionImpl;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowSet;
import org.opencastproject.workflow.api.WorkflowSetImpl;
import org.opencastproject.workflow.api.YamlWorkflowConfigurationDeserializer;
import org.opencastproject.workflow.api.YamlWorkflowConfigurationSerializer;

public final class YamlWorkflowParser {
    private static final ObjectMapper mapper;

    private YamlWorkflowParser() {
    }

    public static List<WorkflowDefinition> parseWorkflowDefinitions(InputStream in) throws WorkflowParsingException {
        try {
            WorkflowDefinitionImpl[] impls = (WorkflowDefinitionImpl[])mapper.readValue(in, WorkflowDefinitionImpl[].class);
            ArrayList<WorkflowDefinition> arrayList = new ArrayList<WorkflowDefinition>(Arrays.asList(impls));
            return arrayList;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static WorkflowDefinition parseWorkflowDefinition(InputStream in) throws WorkflowParsingException {
        try {
            WorkflowDefinition workflowDefinition = (WorkflowDefinition)mapper.readValue(in, WorkflowDefinitionImpl.class);
            return workflowDefinition;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static WorkflowDefinition parseWorkflowDefinition(String in) throws WorkflowParsingException {
        return YamlWorkflowParser.parseWorkflowDefinition(IOUtils.toInputStream((String)in, (String)"UTF8"));
    }

    public static JaxbWorkflowConfiguration parseWorkflowInstance(InputStream in) throws WorkflowParsingException {
        try {
            JaxbWorkflowConfiguration workflow;
            JaxbWorkflowConfiguration jaxbWorkflowConfiguration = workflow = (JaxbWorkflowConfiguration)mapper.readValue(in, JaxbWorkflowConfiguration.class);
            return jaxbWorkflowConfiguration;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static JaxbWorkflowConfiguration parseWorkflowInstance(String in) throws WorkflowParsingException {
        return YamlWorkflowParser.parseWorkflowInstance(IOUtils.toInputStream((String)in, (String)"UTF8"));
    }

    public static WorkflowSet parseWorkflowSet(InputStream in) throws WorkflowParsingException {
        try {
            WorkflowSet workflowSet = (WorkflowSet)mapper.readValue(in, WorkflowSetImpl.class);
            return workflowSet;
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
        finally {
            IoSupport.closeQuietly((Closeable)in);
        }
    }

    public static String toYaml(WorkflowInstance workflowInstance) throws WorkflowParsingException {
        try {
            return mapper.writeValueAsString((Object)workflowInstance);
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
    }

    public static String toYaml(WorkflowDefinition workflowDefinition) throws WorkflowParsingException {
        try {
            return mapper.writeValueAsString((Object)workflowDefinition);
        }
        catch (Exception e) {
            throw new WorkflowParsingException(e);
        }
    }

    static {
        ObjectMapper om = ((YAMLMapper.Builder)YAMLMapper.builder().configure(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME, true)).build();
        om.registerModule((Module)new JaxbAnnotationModule());
        SimpleModule sm = new SimpleModule();
        sm.addDeserializer(JaxbWorkflowConfiguration.class, (JsonDeserializer)new YamlWorkflowConfigurationDeserializer());
        sm.addSerializer(JaxbWorkflowConfiguration.class, (JsonSerializer)new YamlWorkflowConfigurationSerializer());
        om.registerModule((Module)sm);
        mapper = om;
    }
}

