/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowStateListener
implements WorkflowListener {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowStateListener.class);
    protected final Set<Long> workflowInstanceIds;
    protected final Map<WorkflowInstance.WorkflowState, AtomicInteger> notifyStates;
    protected AtomicInteger total = new AtomicInteger(0);

    public WorkflowStateListener() {
        this.workflowInstanceIds = Collections.unmodifiableSet(new HashSet());
        this.notifyStates = Collections.unmodifiableMap(new HashMap());
    }

    public WorkflowStateListener(Long workflowInstanceId) {
        HashSet<Long> ids = new HashSet<Long>();
        if (workflowInstanceId != null) {
            ids.add(workflowInstanceId);
        }
        this.workflowInstanceIds = Collections.unmodifiableSet(ids);
        this.notifyStates = Collections.unmodifiableMap(new HashMap());
    }

    public WorkflowStateListener(Long workflowInstanceId, WorkflowInstance.WorkflowState ... states) {
        this(new HashSet<Long>(Arrays.asList(workflowInstanceId)), states);
    }

    public WorkflowStateListener(WorkflowInstance.WorkflowState ... states) {
        this(new HashSet<Long>(), states);
    }

    public WorkflowStateListener(WorkflowInstance.WorkflowState state) {
        this(new HashSet<Long>(), state);
    }

    public WorkflowStateListener(Set<Long> workflowInstanceIds, WorkflowInstance.WorkflowState ... states) {
        this.workflowInstanceIds = Collections.unmodifiableSet(workflowInstanceIds);
        if (states == null) {
            this.notifyStates = Collections.unmodifiableMap(new HashMap());
        } else {
            HashMap<WorkflowInstance.WorkflowState, AtomicInteger> map = new HashMap<WorkflowInstance.WorkflowState, AtomicInteger>();
            for (WorkflowInstance.WorkflowState state : states) {
                map.put(state, new AtomicInteger(0));
            }
            this.notifyStates = Collections.unmodifiableMap(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationChanged(WorkflowInstance workflow) {
        WorkflowStateListener workflowStateListener = this;
        synchronized (workflowStateListener) {
            logger.debug("No-op");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(WorkflowInstance workflow) {
        WorkflowStateListener workflowStateListener = this;
        synchronized (workflowStateListener) {
            if (!this.workflowInstanceIds.isEmpty() && !this.workflowInstanceIds.contains(workflow.getId())) {
                return;
            }
            WorkflowInstance.WorkflowState currentState = workflow.getState();
            if (!this.notifyStates.isEmpty() && !this.notifyStates.containsKey((Object)currentState)) {
                return;
            }
            if (this.notifyStates.containsKey((Object)currentState)) {
                this.notifyStates.get((Object)currentState).incrementAndGet();
            }
            this.total.incrementAndGet();
            logger.debug("Workflow {} state updated to {}", (Object)workflow.getId(), (Object)workflow.getState());
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countStateChanges() {
        WorkflowStateListener workflowStateListener = this;
        synchronized (workflowStateListener) {
            return this.total.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countStateChanges(WorkflowInstance.WorkflowState state) {
        WorkflowStateListener workflowStateListener = this;
        synchronized (workflowStateListener) {
            if (!this.notifyStates.containsKey((Object)state)) {
                throw new IllegalArgumentException("State '" + state + "' is not being monitored");
            }
            return this.notifyStates.get((Object)state).get();
        }
    }
}

