/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.opencastproject.workflow.api.JaxbWorkflowInstance;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowSet;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="workflows", namespace="http://workflow.opencastproject.org")
public class WorkflowSetImpl
implements WorkflowSet {
    @XmlElement(name="workflow")
    private List<JaxbWorkflowInstance> resultSet = null;

    public WorkflowSetImpl() {
    }

    public WorkflowSetImpl(List<WorkflowInstance> workflows) {
        this.resultSet = workflows.stream().map(JaxbWorkflowInstance::new).collect(Collectors.toList());
    }

    @Override
    public List<WorkflowInstance> getItems() {
        if (this.resultSet == null) {
            return Collections.emptyList();
        }
        return this.resultSet.stream().map(JaxbWorkflowInstance::toWorkflowInstance).collect(Collectors.toList());
    }

    public void addItem(WorkflowInstance item) {
        if (item == null) {
            throw new IllegalArgumentException("Parameter item cannot be null");
        }
        if (this.resultSet == null) {
            this.resultSet = new ArrayList<JaxbWorkflowInstance>();
        }
        this.resultSet.add(new JaxbWorkflowInstance(item));
    }

    @Override
    public long size() {
        return this.resultSet != null ? (long)this.resultSet.size() : 0L;
    }

    public static class Adapter
    extends XmlAdapter<WorkflowSetImpl, WorkflowSet> {
        public WorkflowSetImpl marshal(WorkflowSet set) throws Exception {
            return (WorkflowSetImpl)set;
        }

        public WorkflowSet unmarshal(WorkflowSetImpl set) throws Exception {
            return set;
        }
    }
}

