/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowIndexData;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowServiceDatabase;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Workflow Service Database"}, immediate=true, service={WorkflowServiceDatabase.class})
public class WorkflowServiceDatabaseImpl
implements WorkflowServiceDatabase {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowServiceDatabaseImpl.class);
    public static final String PERSISTENCE_UNIT = "org.opencastproject.workflow.api";
    protected EntityManagerFactory emf;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected SecurityService securityService;

    @Reference(name="entityManagerFactory", target="(osgi.unit.name=org.opencastproject.workflow.api)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference(name="security-service")
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for workflow");
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Override
    public WorkflowInstance getWorkflow(long workflowId) throws NotFoundException, WorkflowDatabaseException {
        return this.getWorkflow(workflowId, this.securityService.getOrganization().getId());
    }

    @Override
    public WorkflowInstance getWorkflow(long workflowId, String orgId) throws NotFoundException, WorkflowDatabaseException {
        try {
            if (null != orgId) {
                return (WorkflowInstance)this.db.exec(Queries.namedQuery.find("Workflow.workflowById", WorkflowInstance.class, new Object[]{Pair.of((Object)"workflowId", (Object)workflowId), Pair.of((Object)"organizationId", (Object)orgId)}));
            }
            return (WorkflowInstance)this.db.exec(Queries.namedQuery.find("Workflow.workflowByIdOrganizationIndependent", WorkflowInstance.class, new Object[]{Pair.of((Object)"workflowId", (Object)workflowId)}));
        }
        catch (NoResultException e) {
            throw new NotFoundException("No workflow with id=" + workflowId + " exists");
        }
        catch (Exception e) {
            logger.error("Could not retrieve workflow with ID '{}'", (Object)workflowId, (Object)e);
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public List<WorkflowInstance> getWorkflowInstances(int limit, int offset) throws WorkflowDatabaseException {
        try {
            return (List)this.db.exec(em -> {
                TypedQuery query = em.createNamedQuery("Workflow.findAll", WorkflowInstance.class).setParameter("organizationId", (Object)this.securityService.getOrganization().getId()).setMaxResults(limit).setFirstResult(offset);
                logger.debug("Requesting workflows using query: {}", (Object)query);
                return query.getResultList();
            });
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException("Error fetching workflows from database", e);
        }
    }

    @Override
    public List<WorkflowInstance> getWorkflowInstancesForCleanup(WorkflowInstance.WorkflowState state, Date dateCreated) throws WorkflowDatabaseException {
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("Workflow.toCleanup", WorkflowInstance.class, new Object[]{Pair.of((Object)"organizationId", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"state", (Object)((Object)state)), Pair.of((Object)"dateCreated", (Object)dateCreated)}));
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public long countWorkflows(WorkflowInstance.WorkflowState state) throws WorkflowDatabaseException {
        try {
            return (Long)this.db.exec(Queries.namedQuery.find("Workflow.getCount", Long.class, new Object[]{Pair.of((Object)"organizationId", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"state", (Object)((Object)state))}));
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException("Could not find number of workflows.", e);
        }
    }

    @Override
    public List<WorkflowIndexData> getWorkflowIndexData(int limit, int offset) throws WorkflowDatabaseException {
        try {
            return (List)this.db.exec(em -> em.createNamedQuery("WorkflowIndexData.getAll", WorkflowIndexData.class).setMaxResults(limit).setFirstResult(offset).getResultList());
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public int countMediaPackages() throws WorkflowDatabaseException {
        try {
            return ((Number)this.db.exec(Queries.namedQuery.find("Workflow.countLatest", Number.class, new Object[0]))).intValue();
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public List<WorkflowInstance> getWorkflowInstancesByMediaPackage(String mediaPackageId) throws WorkflowDatabaseException {
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("Workflow.byMediaPackage", WorkflowInstance.class, new Object[]{Pair.of((Object)"organizationId", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"mediaPackageId", (Object)mediaPackageId)}));
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException("Failed to get workflows from database", e);
        }
    }

    @Override
    public List<WorkflowInstance> getRunningWorkflowInstancesByMediaPackage(String mediaPackageId) throws WorkflowDatabaseException {
        try {
            return (List)this.db.exec(Queries.namedQuery.findAll("Workflow.byMediaPackageAndActive", WorkflowInstance.class, new Object[]{Pair.of((Object)"organizationId", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"mediaPackageId", (Object)mediaPackageId), Pair.of((Object)"stateInstantiated", (Object)((Object)WorkflowInstance.WorkflowState.INSTANTIATED)), Pair.of((Object)"stateRunning", (Object)((Object)WorkflowInstance.WorkflowState.RUNNING)), Pair.of((Object)"statePaused", (Object)((Object)WorkflowInstance.WorkflowState.PAUSED)), Pair.of((Object)"stateFailing", (Object)((Object)WorkflowInstance.WorkflowState.FAILING))}));
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public boolean mediaPackageHasActiveWorkflows(String mediaPackageId) throws WorkflowDatabaseException {
        try {
            long count = (Long)this.db.exec(Queries.namedQuery.find("Workflow.countActiveByMediaPackage", Long.class, new Object[]{Pair.of((Object)"organizationId", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"mediaPackageId", (Object)mediaPackageId), Pair.of((Object)"stateInstantiated", (Object)((Object)WorkflowInstance.WorkflowState.INSTANTIATED)), Pair.of((Object)"stateRunning", (Object)((Object)WorkflowInstance.WorkflowState.RUNNING)), Pair.of((Object)"statePaused", (Object)((Object)WorkflowInstance.WorkflowState.PAUSED)), Pair.of((Object)"stateFailing", (Object)((Object)WorkflowInstance.WorkflowState.FAILING))}));
            return count > 0L;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public boolean userHasActiveWorkflows(String userId) throws WorkflowDatabaseException {
        try {
            long count = (Long)this.db.exec(Queries.namedQuery.find("Workflow.countActiveByUser", Long.class, new Object[]{Pair.of((Object)"organizationId", (Object)this.securityService.getOrganization().getId()), Pair.of((Object)"userId", (Object)userId), Pair.of((Object)"stateInstantiated", (Object)((Object)WorkflowInstance.WorkflowState.INSTANTIATED)), Pair.of((Object)"stateRunning", (Object)((Object)WorkflowInstance.WorkflowState.RUNNING)), Pair.of((Object)"statePaused", (Object)((Object)WorkflowInstance.WorkflowState.PAUSED)), Pair.of((Object)"stateFailing", (Object)((Object)WorkflowInstance.WorkflowState.FAILING))}));
            return count > 0L;
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException(e);
        }
    }

    @Override
    public void updateInDatabase(WorkflowInstance instance) throws WorkflowDatabaseException {
        try {
            this.db.execTx(em -> {
                WorkflowInstance fromDb = (WorkflowInstance)em.find(WorkflowInstance.class, (Object)instance.getId());
                if (fromDb == null) {
                    em.persist((Object)instance);
                } else {
                    em.merge((Object)instance);
                }
            });
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException("Could not update workflow with ID '" + instance.getId() + "'", e);
        }
    }

    @Override
    public void removeFromDatabase(WorkflowInstance instance) throws WorkflowDatabaseException {
        try {
            this.db.execTx(em -> {
                WorkflowInstance fromDb = (WorkflowInstance)em.find(WorkflowInstance.class, (Object)instance.getId());
                if (fromDb != null) {
                    fromDb = (WorkflowInstance)em.merge((Object)instance);
                    em.remove((Object)fromDb);
                }
            });
            logger.debug("Workflow with id {} was deleted.", (Object)instance.getId());
        }
        catch (Exception e) {
            throw new WorkflowDatabaseException("Could not delete workflow with ID '" + instance.getId() + "'", e);
        }
    }
}

