/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Objects;

public final class WorkflowIdentifier {
    private final String id;
    private final String organization;

    public WorkflowIdentifier(String id, String organization) {
        this.id = id;
        this.organization = organization;
    }

    public String getId() {
        return this.id;
    }

    public String getOrganization() {
        return this.organization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowIdentifier that = (WorkflowIdentifier)o;
        return this.id.equals(that.id) && Objects.equals(this.organization, that.organization);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.organization);
    }

    public String toString() {
        if (this.organization == null) {
            return this.id;
        }
        return String.format("%s/%s", this.organization, this.id);
    }

    public WorkflowIdentifier withoutOrganization() {
        return new WorkflowIdentifier(this.id, null);
    }
}

