/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.api;

import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.opencastproject.workflow.api.JaxbWorkflowConfiguration;
import org.opencastproject.workflow.api.RetryStrategy;
import org.opencastproject.workflow.api.WorkflowOperationInstance;

@XmlType(name="operation-instance", namespace="http://workflow.opencastproject.org")
@XmlRootElement(name="operation-instance", namespace="http://workflow.opencastproject.org")
@XmlAccessorType(value=XmlAccessType.NONE)
public class JaxbWorkflowOperationInstance {
    @XmlAttribute(name="id")
    private Long id;
    @XmlAttribute(name="template")
    protected String template;
    @XmlAttribute(name="job")
    protected Long jobId;
    @XmlAttribute(name="state")
    protected WorkflowOperationInstance.OperationState state;
    @XmlAttribute(name="description")
    protected String description;
    @XmlElement(name="configuration")
    @XmlElementWrapper(name="configurations")
    protected Set<JaxbWorkflowConfiguration> configurations = null;
    @XmlAttribute(name="fail-on-error")
    protected boolean failOnError;
    @XmlAttribute(name="if")
    protected String executeCondition;
    @XmlAttribute(name="exception-handler-workflow")
    protected String exceptionHandlingWorkflow;
    @XmlAttribute(name="abortable")
    protected Boolean abortable;
    @XmlAttribute(name="continuable")
    protected Boolean continuable;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(name="started")
    protected Date dateStarted;
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    @XmlElement(name="completed")
    protected Date dateCompleted;
    @XmlElement(name="time-in-queue")
    protected Long timeInQueue;
    @XmlAttribute(name="max-attempts")
    protected int maxAttempts = 1;
    @XmlAttribute(name="failed-attempts")
    protected int failedAttempts;
    @XmlAttribute(name="execution-host")
    protected String executionHost;
    @XmlJavaTypeAdapter(value=RetryStrategy.Adapter.class)
    @XmlAttribute(name="retry-strategy")
    protected RetryStrategy retryStrategy = RetryStrategy.NONE;

    public JaxbWorkflowOperationInstance() {
    }

    public JaxbWorkflowOperationInstance(WorkflowOperationInstance operation) {
        this();
        this.id = operation.getId();
        this.template = operation.getTemplate();
        this.jobId = operation.getId();
        this.state = operation.getState();
        this.description = operation.getDescription();
        if (operation.getConfigurations() != null) {
            this.configurations = operation.getConfigurations().entrySet().stream().map(config -> new JaxbWorkflowConfiguration((String)config.getKey(), (String)config.getValue())).collect(Collectors.toSet());
        }
        this.failOnError = operation.isFailOnError();
        this.executeCondition = operation.getExecutionCondition();
        this.exceptionHandlingWorkflow = operation.getExceptionHandlingWorkflow();
        this.abortable = operation.isAbortable();
        this.continuable = operation.isContinuable();
        this.dateStarted = operation.getDateStarted();
        this.dateCompleted = operation.getDateCompleted();
        this.timeInQueue = operation.getTimeInQueue();
        this.maxAttempts = operation.getMaxAttempts();
        this.failedAttempts = operation.getFailedAttempts();
        this.executionHost = operation.getExecutionHost();
        this.retryStrategy = operation.getRetryStrategy();
    }

    public WorkflowOperationInstance toWorkflowOperationInstance() {
        return new WorkflowOperationInstance(this.template, this.jobId, this.state, this.description, Optional.ofNullable(this.configurations).orElseGet(Collections::emptySet).stream().collect(Collectors.toMap(JaxbWorkflowConfiguration::getKey, JaxbWorkflowConfiguration::getValue)), this.failOnError, this.executeCondition, this.exceptionHandlingWorkflow, this.abortable, this.continuable, this.dateStarted, this.dateCompleted, this.timeInQueue, this.maxAttempts, this.failedAttempts, this.executionHost, this.retryStrategy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaxbWorkflowOperationInstance jaxbWorkflowOperationInstance = (JaxbWorkflowOperationInstance)o;
        return new EqualsBuilder().append((Object)this.template, (Object)jaxbWorkflowOperationInstance.template).append((Object)this.jobId, (Object)jaxbWorkflowOperationInstance.jobId).append((Object)this.state, (Object)jaxbWorkflowOperationInstance.state).append((Object)this.description, (Object)jaxbWorkflowOperationInstance.description).append(this.configurations, jaxbWorkflowOperationInstance.configurations).append(this.failOnError, jaxbWorkflowOperationInstance.failOnError).append((Object)this.executeCondition, (Object)jaxbWorkflowOperationInstance.executeCondition).append((Object)this.exceptionHandlingWorkflow, (Object)jaxbWorkflowOperationInstance.exceptionHandlingWorkflow).append((Object)this.abortable, (Object)jaxbWorkflowOperationInstance.abortable).append((Object)this.continuable, (Object)jaxbWorkflowOperationInstance.continuable).append((Object)this.dateStarted, (Object)jaxbWorkflowOperationInstance.dateStarted).append((Object)this.dateCompleted, (Object)jaxbWorkflowOperationInstance.dateCompleted).append((Object)this.timeInQueue, (Object)jaxbWorkflowOperationInstance.timeInQueue).append(this.maxAttempts, jaxbWorkflowOperationInstance.maxAttempts).append(this.failedAttempts, jaxbWorkflowOperationInstance.failedAttempts).append((Object)this.executionHost, (Object)jaxbWorkflowOperationInstance.executionHost).append((Object)this.retryStrategy, (Object)jaxbWorkflowOperationInstance.retryStrategy).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.template).append((Object)this.jobId).append((Object)this.state).append((Object)this.description).append(this.configurations).append(this.failOnError).append((Object)this.executeCondition).append((Object)this.exceptionHandlingWorkflow).append((Object)this.abortable).append((Object)this.continuable).append((Object)this.dateStarted).append((Object)this.dateCompleted).append((Object)this.timeInQueue).append(this.maxAttempts).append(this.failedAttempts).append((Object)this.executionHost).append((Object)this.retryStrategy).toHashCode();
    }

    static class DateAdapter
    extends XmlAdapter<Long, Date> {
        DateAdapter() {
        }

        public Long marshal(Date v) throws Exception {
            return v == null ? null : Long.valueOf(v.getTime());
        }

        public Date unmarshal(Long v) throws Exception {
            return v == null ? null : new Date(v);
        }
    }
}

