/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.conditionparser;

import java.util.Objects;
import org.opencastproject.workflow.conditionparser.NumericalOperator;

public final class Atom
implements Comparable<Atom> {
    private final Double number;
    private final String string;

    private Atom(Double number, String string) {
        this.number = number;
        this.string = string;
    }

    public String toString() {
        if (this.number != null) {
            String s = String.valueOf(this.number);
            if (s.endsWith(".0")) {
                return s.substring(0, s.length() - 2);
            }
            return s;
        }
        return this.string;
    }

    private static Atom fromNumber(double number) {
        return new Atom(number, null);
    }

    static Atom fromString(String string) {
        return new Atom(null, string);
    }

    static Atom parseNumber(String text) {
        return new Atom(Double.parseDouble(text), null);
    }

    static Atom parseString(String text) {
        return new Atom(null, text);
    }

    Atom reduce(Atom atom, NumericalOperator op) {
        switch (op) {
            case ADD: {
                if (this.number != null && atom.number != null) {
                    return Atom.fromNumber(this.number + atom.number);
                }
                return Atom.fromString(this.toString() + atom.toString());
            }
            case SUBTRACT: {
                if (this.number != null) {
                    return Atom.fromNumber(this.number - atom.number);
                }
                throw new IllegalArgumentException("Tried to subtract from string '" + this.string + "'");
            }
            case MULTIPLY: {
                if (this.number != null) {
                    return Atom.fromNumber(this.number * atom.number);
                }
                throw new IllegalArgumentException("Tried to multiply with string '" + this.string + "'");
            }
        }
        if (this.number != null) {
            return Atom.fromNumber(this.number / atom.number);
        }
        throw new IllegalArgumentException("Tried to divide from string '" + this.string + "'");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Atom atom = (Atom)o;
        return Objects.equals(this.number, atom.number) && Objects.equals(this.string, atom.string);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.string);
    }

    @Override
    public int compareTo(Atom o) {
        if (this.number != null) {
            if (o.number == null) {
                return this.toString().compareTo(o.string);
            }
            return this.number.compareTo(o.number);
        }
        if (o.string == null) {
            return this.string.compareTo(o.toString());
        }
        return this.string.compareTo(o.string);
    }
}

