/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.videogrid;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.opencastproject.composer.api.ComposerService;
import org.opencastproject.composer.api.EncoderException;
import org.opencastproject.composer.api.EncodingProfile;
import org.opencastproject.composer.layout.Dimension;
import org.opencastproject.inspection.api.MediaInspectionException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Stream;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.TrackSupport;
import org.opencastproject.mediapackage.VideoStream;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.api.util.SmilUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.videogrid.api.VideoGridService;
import org.opencastproject.videogrid.api.VideoGridServiceException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.smil.SMILDocument;
import org.w3c.dom.smil.SMILElement;
import org.w3c.dom.smil.SMILMediaElement;
import org.w3c.dom.smil.SMILParElement;
import org.xml.sax.SAXException;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Video Grid Workflow Operation Handler", "workflow.operation=videogrid"})
public class VideoGridWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String SOURCE_FLAVORS = "source-flavors";
    private static final String SOURCE_SMIL_FLAVOR = "source-smil-flavor";
    private static final String CONCAT_ENCODING_PROFILE = "concat-encoding-profile";
    private static final String OPT_RESOLUTION = "resolution";
    private static final String OPT_BACKGROUND_COLOR = "background-color";
    private static final Logger logger = LoggerFactory.getLogger(VideoGridWorkflowOperationHandler.class);
    private static final String NODE_TYPE_VIDEO = "video";
    private static final String[] FFMPEG = new String[]{"ffmpeg", "-y", "-v", "warning", "-nostats", "-max_error_rate", "1.0"};
    private static final String FFMPEG_WF_CODEC = "h264";
    private static final int FFMPEG_WF_FRAMERATE = 24;
    private static final String[] FFMPEG_WF_ARGS = new String[]{"-an", "-codec", "h264", "-q:v", "2", "-g", Integer.toString(240), "-pix_fmt", "yuv420p", "-r", Integer.toString(24)};
    private Workspace workspace = null;
    private VideoGridService videoGridService = null;
    private MediaInspectionService inspectionService = null;
    private ComposerService composerService = null;

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setVideoGridService(VideoGridService videoGridService) {
        this.videoGridService = videoGridService;
    }

    @Reference
    protected void setMediaInspectionService(MediaInspectionService inspectionService) {
        this.inspectionService = inspectionService;
    }

    @Reference
    public void setComposerService(ComposerService composerService) {
        this.composerService = composerService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Track concatTrack;
        SMILDocument smilDocument;
        ImmutablePair<Integer, Integer> resolution;
        logger.debug("Running videogrid workflow operation on workflow {}", (Object)workflowInstance.getId());
        MediaPackage mediaPackage = (MediaPackage)workflowInstance.getMediaPackage().clone();
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        MediaPackageElementFlavor smilFlavor = MediaPackageElementFlavor.parseFlavor((String)this.getConfig(operation, SOURCE_SMIL_FLAVOR));
        MediaPackageElementFlavor targetPresenterFlavor = tagsAndFlavors.getSingleTargetFlavor();
        String concatEncodingProfile = StringUtils.trimToNull((String)operation.getConfiguration(CONCAT_ENCODING_PROFILE));
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        ArrayList<Track> sourceTracks = new ArrayList<Track>();
        for (MediaPackageElementFlavor sourceFlavor : sourceFlavors) {
            TrackSelector trackSelector = new TrackSelector();
            trackSelector.addFlavor(sourceFlavor);
            sourceTracks.addAll(trackSelector.select(mediaPackage, false));
        }
        if (sourceTracks.isEmpty()) {
            logger.warn("No tracks in source flavors, skipping ...");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (concatEncodingProfile == null) {
            throw new WorkflowOperationException("Encoding profile must be set!");
        }
        EncodingProfile profile = this.composerService.getProfile(concatEncodingProfile);
        if (profile == null) {
            throw new WorkflowOperationException("Encoding profile '" + concatEncodingProfile + "' was not found");
        }
        try {
            resolution = this.getResolution(this.getConfig(workflowInstance, OPT_RESOLUTION, "1280x720"));
        }
        catch (IllegalArgumentException e) {
            logger.warn("Given resolution was not well formatted!");
            throw new WorkflowOperationException((Throwable)e);
        }
        logger.info("The resolution of the final video: {}/{}", resolution.getLeft(), resolution.getRight());
        String bgColor = this.getConfig(workflowInstance, OPT_BACKGROUND_COLOR, "0xFFFFFF");
        Pattern pattern = Pattern.compile("0x[A-Fa-f0-9]{6}");
        if (!pattern.matcher(bgColor).matches()) {
            logger.warn("Given color {} was not well formatted!", (Object)bgColor);
            throw new WorkflowOperationException("Given color was not well formatted!");
        }
        logger.info("The background color of the final video: {}", (Object)bgColor);
        List targetTags = tagsAndFlavors.getTargetTags();
        LayoutArea layoutArea = new LayoutArea(this, "webcam", 0, 0, (Integer)resolution.getLeft(), (Integer)resolution.getRight(), bgColor);
        try {
            smilDocument = SmilUtil.getSmilDocumentFromMediaPackage((MediaPackage)mediaPackage, (MediaPackageElementFlavor)smilFlavor, (Workspace)this.workspace);
        }
        catch (SAXException e) {
            throw new WorkflowOperationException("SMIL is not well formatted", (Throwable)e);
        }
        catch (IOException | NotFoundException e) {
            throw new WorkflowOperationException("SMIL could not be found", e);
        }
        SMILParElement parallel = (SMILParElement)smilDocument.getBody().getChildNodes().item(0);
        NodeList sequences = parallel.getTimeChildren();
        float trackDurationInSeconds = parallel.getDur();
        long trackDurationInMs = Math.round(trackDurationInSeconds * 1000.0f);
        long finalStartTime = 0L;
        long finalEndTime = trackDurationInMs;
        ArrayList<StartStopEvent> events = new ArrayList<StartStopEvent>();
        ArrayList<Track> videoSourceTracks = new ArrayList<Track>();
        for (int i = 0; i < sequences.getLength(); ++i) {
            SMILElement item = (SMILElement)sequences.item(i);
            NodeList children = item.getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Track track;
                Node node = children.item(j);
                SMILMediaElement e = (SMILMediaElement)node;
                if (!NODE_TYPE_VIDEO.equals(e.getNodeName())) continue;
                try {
                    track = this.getTrackByID(e.getId(), sourceTracks);
                }
                catch (IllegalStateException ex) {
                    logger.info("No track corresponding to SMIL ID found, skipping SMIL ID {}", (Object)e.getId());
                    continue;
                }
                videoSourceTracks.add(track);
                double beginInSeconds = e.getBegin().item(0).getResolvedOffset();
                long beginInMs = Math.round(beginInSeconds * 1000.0);
                double durationInSeconds = e.getDur();
                long durationInMs = Math.round(durationInSeconds * 1000.0);
                VideoInfo videoInfo = new VideoInfo(this);
                ArrayList<Track> tmpList = new ArrayList<Track>();
                tmpList.add(track);
                LayoutArea trackDimension = this.determineDimension(tmpList, true);
                if (trackDimension == null) {
                    throw new WorkflowOperationException("One of the source video tracks did not contain a valid video stream or dimension");
                }
                videoInfo.aspectRatioHeight = trackDimension.getHeight();
                videoInfo.aspectRatioWidth = trackDimension.getWidth();
                videoInfo.startTime = 0L;
                logger.info("Video information: Width: {}, Height {}, StartTime: {}", new Object[]{videoInfo.aspectRatioWidth, videoInfo.aspectRatioHeight, videoInfo.startTime});
                events.add(new StartStopEvent(this, true, track, beginInMs, videoInfo));
                events.add(new StartStopEvent(this, false, track, beginInMs + durationInMs, videoInfo));
            }
        }
        if (events.isEmpty()) {
            logger.warn("Could not generate sections from given SMIL catalogue for tracks in given flavor, skipping ...");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        Collections.sort(events);
        ArrayList<EditDecisionListSection> videoEdl = new ArrayList<EditDecisionListSection>();
        HashMap<Track, StartStopEvent> activeVideos = new HashMap<Track, StartStopEvent>();
        EditDecisionListSection start = new EditDecisionListSection(this);
        start.timeStamp = finalStartTime;
        videoEdl.add(start);
        for (StartStopEvent event : events) {
            if (event.start) {
                logger.info("Add start event at {}", (Object)event.timeStamp);
                activeVideos.put(event.video, event);
            } else {
                logger.info("Add stop event at {}", (Object)event);
                activeVideos.remove(event.video);
            }
            videoEdl.add(this.createEditDecisionList(event, activeVideos));
        }
        EditDecisionListSection endVideo = new EditDecisionListSection(this);
        endVideo.timeStamp = finalEndTime;
        endVideo.nextTimeStamp = finalEndTime;
        videoEdl.add(endVideo);
        for (int i = 0; i < videoEdl.size() - 1; ++i) {
            ((EditDecisionListSection)videoEdl.get((int)i)).nextTimeStamp = ((EditDecisionListSection)videoEdl.get((int)(i + 1))).timeStamp;
        }
        ArrayList<List<String>> commands = new ArrayList<List<String>>();
        ArrayList tracksForCommands = new ArrayList();
        for (EditDecisionListSection edl : videoEdl) {
            if (edl.nextTimeStamp - edl.timeStamp < 50L) {
                logger.info("Skipping {}-length edl entry", (Object)(edl.nextTimeStamp - edl.timeStamp));
                continue;
            }
            commands.add(this.compositeSection(layoutArea, edl));
            tracksForCommands.add(edl.getAreas().stream().map(m -> m.getVideo()).collect(Collectors.toList()));
        }
        ArrayList<URI> uris = new ArrayList<URI>();
        for (int i = 0; i < commands.size(); ++i) {
            Job job;
            logger.info("Sending command {} of {} to service. Command: {}", new Object[]{i + 1, commands.size(), commands.get(i)});
            try {
                job = this.videoGridService.createPartialTrack((List)commands.get(i), ((List)tracksForCommands.get(i)).toArray(new Track[((List)tracksForCommands.get(i)).size()]));
            }
            catch (org.apache.commons.codec.EncoderException | MediaPackageException | VideoGridServiceException e) {
                throw new WorkflowOperationException(e);
            }
            if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
                throw new WorkflowOperationException(String.format("VideoGrid job for media package '%s' failed", mediaPackage));
            }
            Gson gson = new Gson();
            uris.add((URI)gson.fromJson(job.getPayload(), new TypeToken<URI>(this){}.getType()));
        }
        ArrayList<TrackImpl> tracks = new ArrayList<TrackImpl>();
        for (URI uri : uris) {
            TrackImpl track = new TrackImpl();
            track.setFlavor(targetPresenterFlavor);
            track.setURI(uri);
            Job inspection = null;
            try {
                inspection = this.inspectionService.enrich((MediaPackageElement)track, true);
            }
            catch (MediaInspectionException | MediaPackageException e) {
                throw new WorkflowOperationException("Inspection service could not enrich track", e);
            }
            if (!this.waitForStatus(new Job[]{inspection}).isSuccess()) {
                throw new WorkflowOperationException(String.format("Failed to add metadata to track.", new Object[0]));
            }
            try {
                tracks.add((TrackImpl)MediaPackageElementParser.getFromXml((String)inspection.getPayload()));
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException("Could not parse track returned by inspection service", (Throwable)e);
            }
        }
        Job concatJob = null;
        try {
            concatJob = this.composerService.concat(this.composerService.getProfile(concatEncodingProfile).getIdentifier(), new Dimension(layoutArea.width, layoutArea.height), true, tracks.toArray(new Track[tracks.size()]));
        }
        catch (EncoderException | MediaPackageException e) {
            throw new WorkflowOperationException("The concat job failed", e);
        }
        if (!this.waitForStatus(new Job[]{concatJob}).isSuccess()) {
            throw new WorkflowOperationException("The concat job did not complete successfully.");
        }
        if (concatJob.getPayload().length() > 0) {
            try {
                concatTrack = (Track)MediaPackageElementParser.getFromXml((String)concatJob.getPayload());
            }
            catch (MediaPackageException e) {
                throw new WorkflowOperationException("Could not parse track returned by concat service", (Throwable)e);
            }
            concatTrack.setFlavor(targetPresenterFlavor);
            concatTrack.setURI(concatTrack.getURI());
            for (String tag : targetTags) {
                concatTrack.addTag(tag);
            }
        } else {
            throw new WorkflowOperationException("Concat operation unsuccessful, no payload returned.");
        }
        mediaPackage.add(concatTrack);
        try {
            this.workspace.cleanup(mediaPackage.getIdentifier());
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        logger.debug("Video Grid operation completed");
        return result;
    }

    private List<String> compositeSection(LayoutArea layoutArea, EditDecisionListSection videoEdl) {
        long duration = videoEdl.nextTimeStamp - videoEdl.timeStamp;
        logger.info("Cut timeStamp {}, duration {}", (Object)videoEdl.timeStamp, (Object)duration);
        Object ffmpegFilter = String.format("color=c=%s:s=%dx%d:r=24", layoutArea.bgColor, layoutArea.width, layoutArea.height);
        List<VideoInfo> videos = videoEdl.areas;
        int videoCount = videoEdl.areas.size();
        logger.info("Laying out {} videos in {}", (Object)videoCount, (Object)layoutArea.name);
        if (videoCount > 0) {
            int tilesH = 0;
            int tilesV = 0;
            int tileWidth = 0;
            int tileHeight = 0;
            int totalArea = 0;
            for (int tmpTilesV = 1; tmpTilesV < videoCount + 1; ++tmpTilesV) {
                int tmpTilesH = (int)Math.ceil((float)videoCount / (float)tmpTilesV);
                int tmpTileWidth = (int)(2.0 * Math.floor((float)layoutArea.width / (float)tmpTilesH / 2.0f));
                int tmpTileHeight = (int)(2.0 * Math.floor((float)layoutArea.height / (float)tmpTilesV / 2.0f));
                if (tmpTileWidth <= 0 || tmpTileHeight <= 0) continue;
                int tmpTotalArea = 0;
                for (VideoInfo video : videos) {
                    int videoWidth = video.aspectRatioWidth;
                    int videoHeight = video.aspectRatioHeight;
                    VideoInfo videoScaled = this.aspectScale(videoWidth, videoHeight, tmpTileWidth, tmpTileHeight);
                    tmpTotalArea += videoScaled.aspectRatioWidth * videoScaled.aspectRatioHeight;
                }
                if (tmpTotalArea <= totalArea) continue;
                tilesH = tmpTilesH;
                tilesV = tmpTilesV;
                tileWidth = tmpTileWidth;
                tileHeight = tmpTileHeight;
                totalArea = tmpTotalArea;
            }
            int tileX = 0;
            int tileY = 0;
            logger.info("Tiling in a {}x{} grid", (Object)tilesH, (Object)tilesV);
            ffmpegFilter = (String)ffmpegFilter + String.format("[%s_in];", layoutArea.name);
            for (VideoInfo video : videos) {
                logger.info("tile location ({}, {})", (Object)tileX, (Object)tileY);
                int videoWidth = video.aspectRatioWidth;
                int videoHeight = video.aspectRatioHeight;
                logger.info("original aspect: {}x{}", (Object)videoWidth, (Object)videoHeight);
                VideoInfo videoScaled = this.aspectScale(videoWidth, videoHeight, tileWidth, tileHeight);
                logger.info("scaled size: {}x{}", (Object)videoScaled.aspectRatioWidth, (Object)videoScaled.aspectRatioHeight);
                Offset offset = this.padOffset(videoScaled.aspectRatioWidth, videoScaled.aspectRatioHeight, tileWidth, tileHeight);
                logger.info("offset: left: {}, top: {}", (Object)offset.x, (Object)offset.y);
                long seekOffset = 0L;
                logger.info("seek offset: {}", (Object)seekOffset);
                long seek = video.startTime - 10000L;
                if (seek < 0L) {
                    seek = 0L;
                }
                String padName = String.format("%s_x%d_y%d", layoutArea.name, tileX, tileY);
                if (seek > 0L) {
                    seek += seekOffset;
                }
                ffmpegFilter = (String)ffmpegFilter + String.format("movie=%s:sp=%s", "#{" + video.getVideo().getIdentifier() + "}", this.msToS(seek));
                ffmpegFilter = (String)ffmpegFilter + String.format(",setpts=PTS-%s/TB", this.msToS(seekOffset));
                ffmpegFilter = (String)ffmpegFilter + String.format(",fps=%d:start_time=%s", 24, this.msToS(video.startTime));
                ffmpegFilter = (String)ffmpegFilter + String.format(",setpts=PTS-STARTPTS,scale=%d:%d,setsar=1", videoScaled.aspectRatioWidth, videoScaled.aspectRatioHeight);
                ffmpegFilter = (String)ffmpegFilter + String.format(",pad=w=%d:h=%d:x=%d:y=%d:color=%s", tileWidth, tileHeight, offset.x, offset.y, layoutArea.bgColor);
                ffmpegFilter = (String)ffmpegFilter + String.format("[%s_movie];", padName);
                ffmpegFilter = (String)ffmpegFilter + String.format("color=c=%s:s=%dx%d:r=%d", layoutArea.bgColor, tileWidth, tileHeight, 24);
                ffmpegFilter = (String)ffmpegFilter + String.format("[%s_pad];", padName);
                ffmpegFilter = (String)ffmpegFilter + String.format("[%s_movie][%s_pad]concat=n=2:v=1:a=0[%s];", padName, padName, padName);
                if (++tileX < tilesH) continue;
                tileX = 0;
                ++tileY;
            }
            int remaining = videoCount;
            for (tileY = 0; tileY < tilesV; ++tileY) {
                int thisTilesH = Math.min(tilesH, remaining);
                remaining -= thisTilesH;
                for (tileX = 0; tileX < thisTilesH; ++tileX) {
                    ffmpegFilter = (String)ffmpegFilter + String.format("[%s_x%d_y%d]", layoutArea.name, tileX, tileY);
                }
                if (thisTilesH > 1) {
                    ffmpegFilter = (String)ffmpegFilter + String.format("hstack=inputs=%d,", thisTilesH);
                }
                ffmpegFilter = (String)ffmpegFilter + String.format("pad=w=%d:h=%d:color=%s", layoutArea.width, tileHeight, layoutArea.bgColor);
                ffmpegFilter = (String)ffmpegFilter + String.format("[%s_y%d];", layoutArea.name, tileY);
            }
            for (tileY = 0; tileY < tilesV; ++tileY) {
                ffmpegFilter = (String)ffmpegFilter + String.format("[%s_y%d]", layoutArea.name, tileY);
            }
            if (tilesV > 1) {
                ffmpegFilter = (String)ffmpegFilter + String.format("vstack=inputs=%d,", tilesV);
            }
            ffmpegFilter = (String)ffmpegFilter + String.format("pad=w=%d:h=%d:color=%s", layoutArea.width, layoutArea.height, layoutArea.bgColor);
            ffmpegFilter = (String)ffmpegFilter + String.format("[%s];", layoutArea.name);
            ffmpegFilter = (String)ffmpegFilter + String.format("[%s_in][%s]overlay=x=%d:y=%d", layoutArea.name, layoutArea.name, layoutArea.x, layoutArea.y);
        }
        ffmpegFilter = (String)ffmpegFilter + String.format(",trim=end=%s", this.msToS(duration));
        ArrayList<String> ffmpegCmd = new ArrayList<String>(Arrays.asList(FFMPEG));
        ffmpegCmd.add("-filter_complex");
        ffmpegCmd.add((String)ffmpegFilter);
        ffmpegCmd.addAll(Arrays.asList(FFMPEG_WF_ARGS));
        logger.info("Final command:");
        logger.info(String.join((CharSequence)" ", ffmpegCmd));
        return ffmpegCmd;
    }

    private VideoInfo aspectScale(int oldWidth, int oldHeight, int newWidth, int newHeight) {
        if ((float)oldWidth / (float)oldHeight > (float)newWidth / (float)newHeight) {
            newHeight = 2 * Math.round((float)oldHeight * (float)newWidth / (float)oldWidth / 2.0f);
        } else {
            newWidth = 2 * Math.round((float)oldWidth * (float)newHeight / (float)oldHeight / 2.0f);
        }
        return new VideoInfo(this, newHeight, newWidth);
    }

    private Offset padOffset(int videoWidth, int videoHeight, int areaWidth, int areaHeight) {
        int padX = 2 * Math.round((float)(areaWidth - videoWidth) / 4.0f);
        int padY = 2 * Math.round((float)(areaHeight - videoHeight) / 4.0f);
        return new Offset(this, padX, padY);
    }

    private String msToS(long timestamp) {
        double s = (double)timestamp / 1000.0;
        return String.format(Locale.US, "%.3f", s);
    }

    private Track getTrackByID(String trackId, List<Track> tracks) {
        for (Track t : tracks) {
            if (!t.getIdentifier().contains(trackId)) continue;
            logger.debug("Track-Id from smil found in Mediapackage ID: " + t.getIdentifier());
            return t;
        }
        throw new IllegalStateException("No track matching smil Track-id: " + trackId);
    }

    private LayoutArea determineDimension(List<Track> tracks, boolean forceDivisible) {
        Tuple<Track, LayoutArea> trackDimension = this.getLargestTrack(tracks);
        if (trackDimension == null) {
            return null;
        }
        if (forceDivisible && (((LayoutArea)trackDimension.getB()).getHeight() % 2 != 0 || ((LayoutArea)trackDimension.getB()).getWidth() % 2 != 0)) {
            LayoutArea scaledDimension = new LayoutArea(this, ((LayoutArea)trackDimension.getB()).getWidth() / 2 * 2, ((LayoutArea)trackDimension.getB()).getHeight() / 2 * 2);
            logger.info("Determined output dimension {} scaled down from {} for track {}", new Object[]{scaledDimension, trackDimension.getB(), trackDimension.getA()});
            return scaledDimension;
        }
        logger.info("Determined output dimension {} for track {}", trackDimension.getB(), trackDimension.getA());
        return (LayoutArea)trackDimension.getB();
    }

    private Tuple<Track, LayoutArea> getLargestTrack(List<Track> tracks) {
        Track track = null;
        LayoutArea dimension = null;
        for (Track t : tracks) {
            if (!t.hasVideo()) continue;
            VideoStream[] videoStreams = (VideoStream[])TrackSupport.byType((Stream[])t.getStreams(), VideoStream.class);
            int frameWidth = videoStreams[0].getFrameWidth();
            int frameHeight = videoStreams[0].getFrameHeight();
            if (dimension != null && frameWidth * frameHeight <= dimension.getWidth() * dimension.getHeight()) continue;
            dimension = new LayoutArea(this, frameWidth, frameHeight);
            track = t;
        }
        if (track == null || dimension == null) {
            return null;
        }
        return Tuple.tuple(track, dimension);
    }

    private String getTrackPath(Track track) throws WorkflowOperationException {
        File mediaFile;
        try {
            mediaFile = this.workspace.get(track.getURI());
        }
        catch (NotFoundException e) {
            throw new WorkflowOperationException("Error finding the media file in the workspace", (Throwable)e);
        }
        catch (IOException e) {
            throw new WorkflowOperationException("Error reading the media file in the workspace", (Throwable)e);
        }
        return mediaFile.getAbsolutePath();
    }

    private EditDecisionListSection createEditDecisionList(StartStopEvent event, HashMap<Track, StartStopEvent> activeVideos) {
        EditDecisionListSection nextEdl = new EditDecisionListSection(this);
        nextEdl.timeStamp = event.timeStamp;
        for (Map.Entry<Track, StartStopEvent> activeVideo : activeVideos.entrySet()) {
            nextEdl.areas.add(new VideoInfo(this, activeVideo.getKey(), event.timeStamp, activeVideo.getValue().videoInfo.aspectRatioHeight, activeVideo.getValue().videoInfo.aspectRatioWidth, event.timeStamp - activeVideo.getValue().timeStamp));
        }
        return nextEdl;
    }

    private ImmutablePair<Integer, Integer> getResolution(String s) throws IllegalArgumentException {
        String[] parts = s.split("x");
        if (parts.length != 2) {
            throw new IllegalArgumentException(String.format("Unable to create resolution from \"%s\"", s));
        }
        return new ImmutablePair((Object)Integer.parseInt(parts[0]), (Object)Integer.parseInt(parts[1]));
    }

    class LayoutArea {
        private int x = 0;
        private int y = 0;
        private int width = 1920;
        private int height = 1080;
        private String name = "webcam";
        private String bgColor = "0xFFFFFF";

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(String bgColor) {
            this.bgColor = bgColor;
        }

        LayoutArea(VideoGridWorkflowOperationHandler this$0, int width, int height) {
            this.width = width;
            this.height = height;
        }

        LayoutArea(VideoGridWorkflowOperationHandler this$0, String name, int x, int y, int width, int height, String bgColor) {
            this(this$0, width, height);
            this.name = name;
            this.x = x;
            this.y = y;
            this.bgColor = bgColor;
        }
    }

    class VideoInfo {
        private int aspectRatioWidth = 16;
        private int aspectRatioHeight = 9;
        private long startTime = 0L;
        private long duration = 0L;
        private Track video;

        public int getAspectRatioWidth() {
            return this.aspectRatioWidth;
        }

        public void setAspectRatioWidth(int aspectRatioWidth) {
            this.aspectRatioWidth = aspectRatioWidth;
        }

        public int getAspectRatioHeight() {
            return this.aspectRatioHeight;
        }

        public void setAspectRatioHeight(int aspectRatioHeight) {
            this.aspectRatioHeight = aspectRatioHeight;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getDuration() {
            return this.duration;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public Track getVideo() {
            return this.video;
        }

        public void setVideo(Track video) {
            this.video = video;
        }

        VideoInfo(VideoGridWorkflowOperationHandler this$0) {
        }

        VideoInfo(VideoGridWorkflowOperationHandler this$0, int height, int width) {
            this.aspectRatioWidth = width;
            this.aspectRatioHeight = height;
        }

        VideoInfo(VideoGridWorkflowOperationHandler this$0, Track video, long timeStamp, int aspectRatioHeight, int aspectRatioWidth, long startTime) {
            this(this$0, aspectRatioHeight, aspectRatioWidth);
            this.video = video;
            this.startTime = startTime;
        }
    }

    class StartStopEvent
    implements Comparable<StartStopEvent> {
        private boolean start;
        private long timeStamp;
        private Track video;
        private VideoInfo videoInfo;

        public boolean isStart() {
            return this.start;
        }

        public void setStart(boolean start) {
            this.start = start;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public VideoInfo getVideoInfo() {
            return this.videoInfo;
        }

        public void setVideoInfo(VideoInfo videoInfo) {
            this.videoInfo = videoInfo;
        }

        StartStopEvent(VideoGridWorkflowOperationHandler this$0, boolean start, Track video, long timeStamp, VideoInfo videoInfo) {
            this.start = start;
            this.timeStamp = timeStamp;
            this.video = video;
            this.videoInfo = videoInfo;
        }

        @Override
        public int compareTo(StartStopEvent o) {
            return Long.compare(this.timeStamp, o.timeStamp);
        }
    }

    class EditDecisionListSection {
        private long timeStamp = 0L;
        private long nextTimeStamp = 0L;
        private List<VideoInfo> areas = new ArrayList<VideoInfo>();

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        public long getNextTimeStamp() {
            return this.nextTimeStamp;
        }

        public void setNextTimeStamp(long nextTimeStamp) {
            this.nextTimeStamp = nextTimeStamp;
        }

        public List<VideoInfo> getAreas() {
            return this.areas;
        }

        public void setAreas(List<VideoInfo> areas) {
            this.areas = areas;
        }

        EditDecisionListSection(VideoGridWorkflowOperationHandler this$0) {
        }
    }

    class Offset {
        private int x = 16;
        private int y = 9;

        public int getX() {
            return this.x;
        }

        public void setX(int x) {
            this.x = x;
        }

        public int getY() {
            return this.y;
        }

        public void setY(int y) {
            this.y = y;
        }

        Offset(VideoGridWorkflowOperationHandler this$0, int x, int y) {
            this.x = x;
            this.y = y;
        }
    }
}

