/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videogrid.endpoint;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.codec.EncoderException;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.videogrid.api.VideoGridService;
import org.opencastproject.videogrid.api.VideoGridServiceException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/videogrid")
@RestService(name="videogrid", title="VideoGrid Service", abstractText="The Video Grid Service creates a section of the final video grid file for the Video Grid Workflow Operation Handler.", notes={"Only offers one service", "Only meant to be used with the VideoGridWorkflowOperationHandler"})
@Component(immediate=true, service={VideoGridServiceEndpoint.class}, property={"service.description=VideoGrid Service REST Endpoint", "opencast.service.type=org.opencastproject.videogrid", "opencast.service.path=/videogrid", "opencast.service.jobproducer=true"})
@JaxrsResource
public class VideoGridServiceEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(VideoGridServiceEndpoint.class);
    private VideoGridService videoGridService;
    private ServiceRegistry serviceRegistry = null;

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setVideoGridService(VideoGridService videoGridService) {
        this.videoGridService = videoGridService;
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="videogrid")
    @RestQuery(name="videogrid", description="Create a section of the final video grid", restParameters={@RestParameter(name="command", isRequired=true, type=RestParameter.Type.STRING, description="An ffmpeg command as a list. File paths are replaced by track identifiers."), @RestParameter(name="tracks", isRequired=true, type=RestParameter.Type.TEXT, description="The source tracks to concat as XML")}, responses={@RestResponse(description="Video created successfully", responseCode=200), @RestResponse(description="Invalid data", responseCode=400), @RestResponse(description="Internal error", responseCode=500)}, returnDescription="Returns the path to the generated video for the grid")
    public Response createPartialTrack(@FormParam(value="command") String commandString, @FormParam(value="sourceTracks") String tracksXml) throws MediaPackageException, EncoderException {
        Gson gson = new Gson();
        try {
            List command = (List)gson.fromJson(commandString, new TypeToken<List<String>>(this){}.getType());
            List tracks = MediaPackageElementParser.getArrayFromXml((String)tracksXml);
            logger.debug("Start videogrid");
            Job job = this.videoGridService.createPartialTrack(command, tracks.toArray(new Track[tracks.size()]));
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (JsonSyntaxException | NullPointerException e) {
            logger.debug("Invalid data passed to REST endpoint:\ncommand: {}", (Object)commandString);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (VideoGridServiceException e) {
            logger.error("Error generating videos {}", (Object)commandString, (Object)e);
            return Response.serverError().build();
        }
    }

    public JobProducer getService() {
        if (this.videoGridService instanceof JobProducer) {
            logger.debug("get videogrid service");
            return (JobProducer)this.videoGridService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

