/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videogrid.remote;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.EncoderException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.videogrid.api.VideoGridService;
import org.opencastproject.videogrid.api.VideoGridServiceException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VideoGridService.class}, property={"service.description=Remote Video Grid Service"})
public class VideoGridServiceRemoteImpl
extends RemoteBase
implements VideoGridService {
    private static final Logger logger = LoggerFactory.getLogger(VideoGridServiceRemoteImpl.class);
    private static final Gson gson = new Gson();

    public VideoGridServiceRemoteImpl() {
        super("org.opencastproject.videogrid");
    }

    public Job createPartialTrack(List<String> command, Track ... tracks) throws VideoGridServiceException, EncoderException {
        Job job;
        String commandJson = gson.toJson(command);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        try {
            params.add(new BasicNameValuePair("command", commandJson));
            params.add(new BasicNameValuePair("sourceTracks", MediaPackageElementParser.getArrayAsXml(Arrays.asList(tracks))));
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        logger.info("Video-gridding {}", (Object)commandJson);
        HttpResponse response = null;
        try {
            HttpPost post = new HttpPost("/videogrid");
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            response = this.getResponse((HttpRequestBase)post);
            if (response == null) {
                throw new VideoGridServiceException("No response from service");
            }
            Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
            logger.info("Completed video-gridding {}", command);
            job = receipt;
        }
        catch (IOException e) {
            try {
                throw new VideoGridServiceException("Failed building service request", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeConnection(response);
                throw throwable;
            }
        }
        this.closeConnection(response);
        return job;
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

