/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.videoeditor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.SimpleElementSelector;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.videoeditor.api.ProcessFailedException;
import org.opencastproject.videoeditor.api.VideoEditorService;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workflow.handler.workflow.ResumableWorkflowOperationHandlerBase;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Video Editor Workflow Operation Handler", "workflow.operation=editor"})
public class VideoEditorWorkflowOperationHandler
extends ResumableWorkflowOperationHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(VideoEditorWorkflowOperationHandler.class);
    private static final String HOLD_UI_PATH = "/ui/operation/editor/index.html";
    private static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    private static final String PREVIEW_FLAVORS_PROPERTY = "preview-flavors";
    private static final String SKIP_PROCESSING_PROPERTY = "skip-processing";
    private static final String SKIPPED_FLAVORS_PROPERTY = "skipped-flavors";
    private static final String SMIL_FLAVORS_PROPERTY = "smil-flavors";
    private static final String TARGET_SMIL_FLAVOR_PROPERTY = "target-smil-flavor";
    private static final String TARGET_FLAVOR_SUBTYPE_PROPERTY = "target-flavor-subtype";
    private static final String INTERACTIVE_PROPERTY = "interactive";
    private static final String SMIL_FILE_NAME = "smil.smil";
    private static final String SKIP_NOT_TRIMMED_PROPERTY = "skip-if-not-trimmed";
    private SmilService smilService;
    private VideoEditorService videoEditorService;
    private Workspace workspace;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        this.setHoldActionTitle("Review / VideoEdit");
        this.registerHoldStateUserInterface(HOLD_UI_PATH);
        logger.info("Registering videoEditor hold state ui from classpath {}", (Object)HOLD_UI_PATH);
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackageElementFlavor targetSmilFlavor;
        Catalog[] targetSmilCatalogs;
        boolean skipProcessing;
        MediaPackage mp = workflowInstance.getMediaPackage();
        logger.info("Start editor workflow for mediapackage {}", (Object)mp.getIdentifier().toString());
        WorkflowOperationInstance worflowOperationInstance = workflowInstance.getCurrentOperation();
        String smilFlavorsProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(SMIL_FLAVORS_PROPERTY));
        if (smilFlavorsProperty == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set", SMIL_FLAVORS_PROPERTY));
        }
        String targetSmilFlavorProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(TARGET_SMIL_FLAVOR_PROPERTY));
        if (targetSmilFlavorProperty == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set", TARGET_SMIL_FLAVOR_PROPERTY));
        }
        String previewTrackFlavorsProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(PREVIEW_FLAVORS_PROPERTY));
        if (previewTrackFlavorsProperty == null) {
            logger.info("Configuration property '{}' not set, use preview tracks from SMIL catalog", (Object)PREVIEW_FLAVORS_PROPERTY);
        }
        if (!(skipProcessing = BooleanUtils.toBoolean((String)worflowOperationInstance.getConfiguration(SKIP_PROCESSING_PROPERTY))) && StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(TARGET_FLAVOR_SUBTYPE_PROPERTY)) == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set", TARGET_FLAVOR_SUBTYPE_PROPERTY));
        }
        boolean interactive = BooleanUtils.toBoolean((String)worflowOperationInstance.getConfiguration(INTERACTIVE_PROPERTY));
        SimpleElementSelector elementSelector = new SimpleElementSelector();
        for (String flavor : this.asList(smilFlavorsProperty)) {
            elementSelector.addFlavor(flavor);
        }
        Collection smilCatalogs = elementSelector.select(mp, false);
        MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
        if (smilCatalogs.isEmpty()) {
            if (!interactive && !skipProcessing) {
                logger.info("Skipping cutting operation since no edit decision list is available");
                return this.skip(workflowInstance, context);
            }
            if (previewTrackFlavorsProperty == null) {
                throw new WorkflowOperationException(String.format("No SMIL catalogs with flavor %s nor preview files with flavor %s found in mediapackage %s", smilFlavorsProperty, previewTrackFlavorsProperty, mp.getIdentifier().toString()));
            }
            TrackSelector trackSelector = new TrackSelector();
            for (String flavor : this.asList(previewTrackFlavorsProperty)) {
                trackSelector.addFlavor(flavor);
            }
            Collection previewTracks = trackSelector.select(mp, false);
            if (previewTracks.isEmpty()) {
                throw new WorkflowOperationException(String.format("No preview tracks found in mediapackage %s with flavor %s", mp.getIdentifier().toString(), previewTrackFlavorsProperty));
            }
            Track[] previewTracksArr = previewTracks.toArray(new Track[previewTracks.size()]);
            MediaPackageElementFlavor smilFlavor = MediaPackageElementFlavor.parseFlavor((String)smilFlavorsProperty);
            for (Track previewTrack : previewTracks) {
                try {
                    SmilResponse smilResponse = this.smilService.createNewSmil(mp);
                    smilResponse = this.smilService.addParallel(smilResponse.getSmil());
                    smilResponse = this.smilService.addClips(smilResponse.getSmil(), smilResponse.getEntity().getId(), previewTracksArr, 0L, previewTracksArr[0].getDuration().longValue());
                    Smil smil = smilResponse.getSmil();
                    InputStream is = null;
                    try {
                        is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");
                        URI smilURI = this.workspace.put(mp.getIdentifier().toString(), smil.getId(), SMIL_FILE_NAME, is);
                        MediaPackageElementFlavor trackSmilFlavor = previewTrack.getFlavor();
                        if (!"*".equals(smilFlavor.getType())) {
                            trackSmilFlavor = new MediaPackageElementFlavor(smilFlavor.getType(), trackSmilFlavor.getSubtype());
                        }
                        if (!"*".equals(smilFlavor.getSubtype())) {
                            trackSmilFlavor = new MediaPackageElementFlavor(trackSmilFlavor.getType(), smilFlavor.getSubtype());
                        }
                        Catalog catalog = (Catalog)mpeBuilder.elementFromURI(smilURI, MediaPackageElement.Type.Catalog, trackSmilFlavor);
                        catalog.setIdentifier(smil.getId());
                        mp.add(catalog);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
                catch (Exception ex) {
                    throw new WorkflowOperationException(String.format("Failed to create SMIL catalog for mediapackage %s", mp.getIdentifier().toString()), (Throwable)ex);
                }
            }
        }
        if ((targetSmilCatalogs = mp.getCatalogs(targetSmilFlavor = MediaPackageElementFlavor.parseFlavor((String)targetSmilFlavorProperty))) == null || targetSmilCatalogs.length == 0) {
            if (!interactive && !skipProcessing) {
                return this.skip(workflowInstance, context);
            }
            try {
                SmilResponse smilResponse = this.smilService.createNewSmil(mp);
                Smil smil = smilResponse.getSmil();
                InputStream is = null;
                try {
                    is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");
                    URI smilURI = this.workspace.put(mp.getIdentifier().toString(), smil.getId(), SMIL_FILE_NAME, is);
                    Catalog catalog = (Catalog)mpeBuilder.elementFromURI(smilURI, MediaPackageElement.Type.Catalog, targetSmilFlavor);
                    catalog.setIdentifier(smil.getId());
                    mp.add(catalog);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            catch (Exception ex) {
                throw new WorkflowOperationException(String.format("Failed to create an initial empty SMIL catalog for mediapackage %s", mp.getIdentifier().toString()), (Throwable)ex);
            }
            if (!interactive) {
                return this.skip(workflowInstance, context);
            }
            logger.info("Holding for video edit...");
            return this.createResult(mp, WorkflowOperationResult.Action.PAUSE);
        }
        logger.debug("Move on, SMIL catalog ({}) already exists for media package '{}'", (Object)targetSmilFlavor, (Object)mp);
        return this.resume(workflowInstance, context, Collections.emptyMap());
    }

    public WorkflowOperationResult skip(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        boolean skipProcessing;
        MediaPackage mp = workflowInstance.getMediaPackage();
        logger.info("Skip video editor operation for mediapackage {}", (Object)mp.getIdentifier());
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        WorkflowOperationInstance worflowOperationInstance = workflowInstance.getCurrentOperation();
        List fallbackSourceFlavor = new ArrayList();
        String sourceTrackFlavorsProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(SKIPPED_FLAVORS_PROPERTY));
        if (sourceTrackFlavorsProperty == null || sourceTrackFlavorsProperty.isEmpty()) {
            logger.info("\"{}\" option not set, use value of \"{}\"", (Object)SKIPPED_FLAVORS_PROPERTY, (Object)SOURCE_FLAVORS_PROPERTY);
            fallbackSourceFlavor = tagsAndFlavors.getSrcFlavors();
            if (fallbackSourceFlavor.isEmpty()) {
                throw new WorkflowOperationException(String.format("Required configuration property %s not set.", SOURCE_FLAVORS_PROPERTY));
            }
        }
        if (skipProcessing = BooleanUtils.toBoolean((String)worflowOperationInstance.getConfiguration(SKIP_PROCESSING_PROPERTY))) {
            return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
        }
        String targetFlavorSubTypeProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(TARGET_FLAVOR_SUBTYPE_PROPERTY));
        if (targetFlavorSubTypeProperty == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set.", TARGET_FLAVOR_SUBTYPE_PROPERTY));
        }
        TrackSelector trackSelector = new TrackSelector();
        if (sourceTrackFlavorsProperty != null && !sourceTrackFlavorsProperty.isEmpty()) {
            for (Object flavor : this.asList(sourceTrackFlavorsProperty)) {
                trackSelector.addFlavor((String)flavor);
            }
        } else {
            for (Object flavor : fallbackSourceFlavor) {
                trackSelector.addFlavor(flavor);
            }
        }
        Collection sourceTracks = trackSelector.select(mp, false);
        for (Track sourceTrack : sourceTracks) {
            Track clonedTrack = (Track)sourceTrack.clone();
            clonedTrack.setIdentifier(null);
            clonedTrack.setURI(sourceTrack.getURI());
            clonedTrack.setFlavor(new MediaPackageElementFlavor(sourceTrack.getFlavor().getType(), targetFlavorSubTypeProperty));
            mp.addDerived((MediaPackageElement)clonedTrack, (MediaPackageElement)sourceTrack);
        }
        return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
    }

    public WorkflowOperationResult resume(WorkflowInstance workflowInstance, JobContext context, Map<String, String> properties) throws WorkflowOperationException {
        MediaPackage mp = workflowInstance.getMediaPackage();
        logger.info("Resume video editor operation for mediapackage {}", (Object)mp.getIdentifier().toString());
        WorkflowOperationInstance worflowOperationInstance = workflowInstance.getCurrentOperation();
        String sourceTrackFlavorsProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(SOURCE_FLAVORS_PROPERTY));
        if (sourceTrackFlavorsProperty == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set.", SOURCE_FLAVORS_PROPERTY));
        }
        String targetSmilFlavorProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(TARGET_SMIL_FLAVOR_PROPERTY));
        if (targetSmilFlavorProperty == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set.", TARGET_SMIL_FLAVOR_PROPERTY));
        }
        String targetFlavorSybTypeProperty = StringUtils.trimToNull((String)worflowOperationInstance.getConfiguration(TARGET_FLAVOR_SUBTYPE_PROPERTY));
        boolean skipProcessing = BooleanUtils.toBoolean((String)worflowOperationInstance.getConfiguration(SKIP_PROCESSING_PROPERTY));
        if (!skipProcessing && targetFlavorSybTypeProperty == null) {
            throw new WorkflowOperationException(String.format("Required configuration property %s not set.", TARGET_FLAVOR_SUBTYPE_PROPERTY));
        }
        boolean skipIfNoTrim = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)worflowOperationInstance.getConfiguration(SKIP_NOT_TRIMMED_PROPERTY)), (boolean)true);
        TrackSelector trackSelector = new TrackSelector();
        for (String flavor : this.asList(sourceTrackFlavorsProperty)) {
            trackSelector.addFlavor(flavor);
        }
        Collection sourceTracks = trackSelector.select(mp, false);
        if (sourceTracks.isEmpty()) {
            throw new WorkflowOperationException(String.format("No source tracks found in mediapacksge %s with flavors %s.", mp.getIdentifier().toString(), sourceTrackFlavorsProperty));
        }
        MediaPackageElementFlavor smilTargetFlavor = MediaPackageElementFlavor.parseFlavor((String)targetSmilFlavorProperty);
        Catalog[] smilCatalogs = mp.getCatalogs(smilTargetFlavor);
        if (smilCatalogs == null || smilCatalogs.length == 0) {
            throw new WorkflowOperationException(String.format("No SMIL catalog found in mediapackage %s with flavor %s.", mp.getIdentifier().toString(), targetSmilFlavorProperty));
        }
        File smilFile = null;
        Smil smil = null;
        try {
            smilFile = this.workspace.get(smilCatalogs[0].getURI());
            smil = this.smilService.fromXml(smilFile).getSmil();
            smil = this.replaceAllTracksWith(smil, sourceTracks.toArray(new Track[sourceTracks.size()]));
            InputStream is = null;
            try {
                is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");
                this.workspace.delete(mp.getIdentifier().toString(), smilCatalogs[0].getIdentifier());
                mp.remove(smilCatalogs[0]);
                URI newSmilUri = this.workspace.put(mp.getIdentifier().toString(), smil.getId(), SMIL_FILE_NAME, is);
                Catalog catalog = (Catalog)MediaPackageElementBuilderFactory.newInstance().newElementBuilder().elementFromURI(newSmilUri, MediaPackageElement.Type.Catalog, smilCatalogs[0].getFlavor());
                catalog.setIdentifier(smil.getId());
                mp.add(catalog);
            }
            catch (Exception ex) {
                try {
                    throw new WorkflowOperationException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (NotFoundException ex) {
            throw new WorkflowOperationException(String.format("Failed to get SMIL catalog %s from mediapackage %s.", smilCatalogs[0].getIdentifier(), mp.getIdentifier().toString()), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new WorkflowOperationException(String.format("Can't open SMIL catalog %s from mediapackage %s.", smilCatalogs[0].getIdentifier(), mp.getIdentifier().toString()), (Throwable)ex);
        }
        catch (SmilException ex) {
            throw new WorkflowOperationException((Throwable)ex);
        }
        if (skipProcessing) {
            logger.info("VideoEdit workflow {} finished - smil file is {}", (Object)workflowInstance.getId(), (Object)smil.getId());
            return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
        }
        if (skipIfNoTrim) {
            try {
                Smil filteredSmil = this.smilService.fromXml(smil.toXML()).getSmil();
                for (SmilMediaObject element : smil.getBody().getMediaElements()) {
                    SmilMediaContainer container;
                    if (element.isContainer() && SmilMediaContainer.ContainerType.PAR == (container = (SmilMediaContainer)element).getContainerType()) continue;
                    filteredSmil = this.smilService.removeSmilElement(filteredSmil, element.getId()).getSmil();
                }
                switch (filteredSmil.getBody().getMediaElements().size()) {
                    case 0: {
                        logger.info("Skipping SMIL job generation for mediapackage '{}', because the SMIL does not define any trimming points", (Object)mp.getIdentifier());
                        return this.skip(workflowInstance, context);
                    }
                    case 1: {
                        if (mp.getDuration() < 0L) break;
                        SmilMediaContainer parElement = (SmilMediaContainer)filteredSmil.getBody().getMediaElements().get(0);
                        boolean skip = true;
                        for (SmilMediaObject elementChild : parElement.getElements()) {
                            SmilMediaElement media;
                            if (elementChild.isContainer() || (media = (SmilMediaElement)elementChild).getClipBeginMS() == 0L && media.getClipEndMS() == mp.getDuration().longValue()) continue;
                            skip = false;
                            break;
                        }
                        if (!skip) break;
                        logger.info("Skipping SMIL job generation for mediapackage '{}', because the trimming points in the SMIL correspond to the beginning and the end of the video", (Object)mp.getIdentifier());
                        return this.skip(workflowInstance, context);
                    }
                }
            }
            catch (MalformedURLException | JAXBException | SmilException | SAXException e) {
                logger.warn("Error parsing input SMIL to determine if it has trimpoints. We will assume it does and go on creating jobs.");
            }
        }
        List jobs = null;
        try {
            logger.info("Create processing jobs for SMIL file: {}", (Object)smilCatalogs[0].getIdentifier());
            jobs = this.videoEditorService.processSmil(smil);
            if (!this.waitForStatus(jobs.toArray(new Job[jobs.size()])).isSuccess()) {
                throw new WorkflowOperationException(String.format("Processing SMIL file failed: %s", smilCatalogs[0].getIdentifier()));
            }
            logger.info("Finished processing of SMIL file: {}", (Object)smilCatalogs[0].getIdentifier());
        }
        catch (ProcessFailedException ex) {
            throw new WorkflowOperationException(String.format("Finished processing of SMIL file: %s", smilCatalogs[0].getIdentifier()), (Throwable)ex);
        }
        Track editedTrack = null;
        boolean mpAdded = false;
        for (Job job : jobs) {
            try {
                editedTrack = (Track)MediaPackageElementParser.getFromXml((String)job.getPayload());
                MediaPackageElementFlavor editedTrackFlavor = editedTrack.getFlavor();
                editedTrack.setFlavor(new MediaPackageElementFlavor(editedTrackFlavor.getType(), targetFlavorSybTypeProperty));
                URI editedTrackNewUri = this.workspace.moveTo(editedTrack.getURI(), mp.getIdentifier().toString(), editedTrack.getIdentifier(), FilenameUtils.getName((String)editedTrack.getURI().toString()));
                editedTrack.setURI(editedTrackNewUri);
                for (Track track : sourceTracks) {
                    MediaPackageReference reference = editedTrack.getReference();
                    if (reference == null) {
                        logger.warn("Edited track {} has no reference track assigned; skip restoring tags.", (Object)editedTrack.getIdentifier());
                        continue;
                    }
                    if (!track.getIdentifier().equals(reference.getIdentifier())) continue;
                    editedTrack.setTags(track.getTags());
                    mp.addDerived((MediaPackageElement)editedTrack, (MediaPackageElement)track);
                    mpAdded = true;
                    break;
                }
                if (mpAdded) continue;
                mp.add(editedTrack);
            }
            catch (MediaPackageException ex) {
                throw new WorkflowOperationException("Failed to get information about the edited track(s)", (Throwable)ex);
            }
            catch (IOException | IllegalArgumentException | NotFoundException ex) {
                throw new WorkflowOperationException("Moving edited track to work location failed.", ex);
            }
            catch (Exception ex) {
                throw new WorkflowOperationException((Throwable)ex);
            }
        }
        logger.info("VideoEdit workflow {} finished", (Object)workflowInstance.getId());
        return this.createResult(mp, WorkflowOperationResult.Action.CONTINUE);
    }

    protected Smil replaceAllTracksWith(Smil smil, Track[] otherTracks) throws SmilException {
        SmilResponse smilResponse;
        try {
            smilResponse = this.smilService.fromXml(smil.toXML());
        }
        catch (Exception ex) {
            throw new SmilException("Can not parse SMIL files.");
        }
        boolean hasElements = false;
        for (SmilMediaObject elem : smil.getBody().getMediaElements()) {
            long start = -1L;
            long end = -1L;
            if (elem.isContainer()) {
                for (SmilMediaObject child : ((SmilMediaContainer)elem).getElements()) {
                    if (child.isContainer() || !(child instanceof SmilMediaElement)) continue;
                    SmilMediaElement media = (SmilMediaElement)child;
                    start = media.getClipBeginMS();
                    end = media.getClipEndMS();
                    smilResponse = this.smilService.removeSmilElement(smilResponse.getSmil(), media.getId());
                    hasElements = true;
                }
                if (start == -1L || end == -1L) continue;
                smilResponse = this.smilService.addClips(smilResponse.getSmil(), elem.getId(), otherTracks, start, end - start);
                continue;
            }
            if (!(elem instanceof SmilMediaElement)) continue;
            throw new SmilException("Media elements inside SMIL body are not supported yet.");
        }
        if (!hasElements) {
            throw new SmilException("Smil does not define any elements");
        }
        return smilResponse.getSmil();
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    @Reference
    public void setVideoEditorService(VideoEditorService editor) {
        this.videoEditorService = editor;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

