/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.videoeditor;

import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.silencedetection.api.SilenceDetectionFailedException;
import org.opencastproject.silencedetection.api.SilenceDetectionService;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Silence Detection Workflow Operation Handler", "workflow.operation=silence"})
public class SilenceDetectionWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SilenceDetectionWorkflowOperationHandler.class);
    private static final String SOURCE_FLAVORS_PROPERTY = "source-flavors";
    private static final String SOURCE_FLAVOR_PROPERTY = "source-flavor";
    private static final String SMIL_FLAVOR_SUBTYPE_PROPERTY = "smil-flavor-subtype";
    private static final String SMIL_TARGET_FLAVOR_PROPERTY = "target-flavor";
    private static final String REFERENCE_TRACKS_FLAVOR_PROPERTY = "reference-tracks-flavor";
    private static final String EXPORT_SEGMENTS_DURATION = "export-segments-duration";
    private static final String TARGET_FILE_NAME = "smil.smil";
    private SilenceDetectionService detetionService;
    private SmilService smilService;
    private Workspace workspace;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mp = workflowInstance.getMediaPackage();
        logger.debug("Start silence detection workflow operation for mediapackage {}", (Object)mp.getIdentifier().toString());
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none);
        List sourceFlavors = tagsAndFlavors.getSrcFlavors();
        String smilFlavorSubType = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(SMIL_FLAVOR_SUBTYPE_PROPERTY));
        String smilTargetFlavorString = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(SMIL_TARGET_FLAVOR_PROPERTY));
        String exportSegmentsDurationString = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(EXPORT_SEGMENTS_DURATION));
        boolean exportSegmentsDuration = false;
        if (StringUtils.isNotBlank((CharSequence)exportSegmentsDurationString)) {
            try {
                exportSegmentsDuration = BooleanUtils.toBoolean((String)exportSegmentsDurationString);
            }
            catch (IllegalArgumentException e) {
                exportSegmentsDuration = false;
                logger.warn("Unable to parse {} option value {}. Deactivating export of workflow properties.", (Object)EXPORT_SEGMENTS_DURATION, (Object)exportSegmentsDurationString);
            }
        }
        MediaPackageElementFlavor smilTargetFlavor = null;
        if (smilTargetFlavorString != null) {
            smilTargetFlavor = MediaPackageElementFlavor.parseFlavor((String)smilTargetFlavorString);
        }
        if (sourceFlavors.isEmpty()) {
            throw new WorkflowOperationException(String.format("No %s or %s have been specified", SOURCE_FLAVOR_PROPERTY, SOURCE_FLAVORS_PROPERTY));
        }
        if (smilFlavorSubType == null && smilTargetFlavor == null) {
            throw new WorkflowOperationException(String.format("No %s or %s have been specified", SMIL_FLAVOR_SUBTYPE_PROPERTY, SMIL_TARGET_FLAVOR_PROPERTY));
        }
        if (sourceFlavors != null && smilTargetFlavor != null) {
            throw new WorkflowOperationException(String.format("Can't use %s and %s together", SOURCE_FLAVORS_PROPERTY, SMIL_TARGET_FLAVOR_PROPERTY));
        }
        String finalSourceFlavors = smilTargetFlavor != null ? ((MediaPackageElementFlavor)sourceFlavors.get(sourceFlavors.size())).toString() : sourceFlavors.stream().map(MediaPackageElementFlavor::toString).collect(Collectors.joining(","));
        String referenceTracksFlavor = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(REFERENCE_TRACKS_FLAVOR_PROPERTY));
        if (referenceTracksFlavor == null) {
            referenceTracksFlavor = finalSourceFlavors;
        }
        TrackSelector trackSelector = new TrackSelector();
        for (Object flavor : this.asList(finalSourceFlavors)) {
            trackSelector.addFlavor((String)flavor);
        }
        Collection sourceTracks = trackSelector.select(mp, false);
        if (sourceTracks.isEmpty()) {
            logger.info("No source tracks found, skip silence detection");
            return this.createResult(mp, WorkflowOperationResult.Action.SKIP);
        }
        trackSelector = new TrackSelector();
        for (String flavor : this.asList(referenceTracksFlavor)) {
            trackSelector.addFlavor(flavor);
        }
        Collection referenceTracks = trackSelector.select(mp, false);
        if (referenceTracks.isEmpty()) {
            throw new WorkflowOperationException(String.format("No tracks found filtered by flavor(s) '%s'", referenceTracksFlavor));
        }
        MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
        Map<String, String> exportWorkflowProperties = new HashMap<String, String>();
        for (Track sourceTrack : sourceTracks) {
            if (!sourceTrack.hasAudio()) {
                logger.info("Skipping silence detection of track {} since it has no audio", (Object)sourceTrack);
                if (!exportSegmentsDuration) continue;
                exportWorkflowProperties = this.exportEmptySegmentDuration(exportWorkflowProperties, sourceTrack);
                continue;
            }
            logger.info("Executing silence detection on track {}", (Object)sourceTrack.getIdentifier());
            try {
                Job detectionJob = this.detetionService.detect(sourceTrack, referenceTracks.toArray(new Track[referenceTracks.size()]));
                if (!this.waitForStatus(new Job[]{detectionJob}).isSuccess()) {
                    throw new WorkflowOperationException("Silence Detection failed");
                }
                Smil smil = this.smilService.fromXml(detectionJob.getPayload()).getSmil();
                if (smil.getBody().getMediaElements().isEmpty()) {
                    logger.debug("No segments detected in track {}, skip attaching smil file.", (Object)sourceTrack.getIdentifier());
                    if (!exportSegmentsDuration) continue;
                    exportWorkflowProperties = this.exportEmptySegmentDuration(exportWorkflowProperties, sourceTrack);
                    continue;
                }
                InputStream is = null;
                try {
                    is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");
                    URI smilURI = this.workspace.put(mp.getIdentifier().toString(), smil.getId(), TARGET_FILE_NAME, is);
                    MediaPackageElementFlavor smilFlavor = smilTargetFlavor;
                    if (smilFlavor == null) {
                        smilFlavor = new MediaPackageElementFlavor(sourceTrack.getFlavor().getType(), smilFlavorSubType);
                    }
                    Catalog catalog = (Catalog)mpeBuilder.elementFromURI(smilURI, MediaPackageElement.Type.Catalog, smilFlavor);
                    catalog.setIdentifier(smil.getId());
                    mp.add(catalog);
                }
                catch (Exception ex) {
                    try {
                        throw new WorkflowOperationException(String.format("Failed to put smil into workspace. Silence detection for track %s failed", sourceTrack.getIdentifier()), (Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
                if (exportSegmentsDuration) {
                    long durationMS = 0L;
                    for (SmilMediaObject smilElement : smil.getBody().getMediaElements()) {
                        durationMS += this.getSegmentDurationMS(smilElement);
                    }
                    String durationWfPropertyName = this.getDurationWfPropertyName(sourceTrack);
                    exportWorkflowProperties.put(durationWfPropertyName, Long.toString(TimeUnit.MILLISECONDS.toSeconds(durationMS)));
                    String relationWfPropertyName = this.getRelationWfPropertyName(sourceTrack);
                    double durationTrackLengthRelation = 0.0;
                    if (sourceTrack.getDuration() > 0L) {
                        durationTrackLengthRelation = (double)durationMS / (double)sourceTrack.getDuration().longValue();
                        durationTrackLengthRelation *= 100.0;
                    }
                    durationTrackLengthRelation = Math.floor(durationTrackLengthRelation);
                    durationTrackLengthRelation = Math.min(100.0, durationTrackLengthRelation);
                    durationTrackLengthRelation = Math.max(0.0, durationTrackLengthRelation);
                    exportWorkflowProperties.put(relationWfPropertyName, String.format("%.0f", durationTrackLengthRelation));
                }
                logger.info("Finished silence detection on track {}", (Object)sourceTrack.getIdentifier());
            }
            catch (SilenceDetectionFailedException ex) {
                throw new WorkflowOperationException(String.format("Failed to create silence detection job for track %s", sourceTrack.getIdentifier()));
            }
            catch (SmilException ex) {
                throw new WorkflowOperationException(String.format("Failed to get smil from silence detection job for track %s", sourceTrack.getIdentifier()));
            }
        }
        logger.debug("Finished silence detection workflow operation for media package {}", (Object)mp.getIdentifier());
        return this.createResult(mp, exportWorkflowProperties, WorkflowOperationResult.Action.CONTINUE, 0L);
    }

    protected long getSegmentDurationMS(SmilMediaObject smilElement) throws SmilException {
        Iterator iterator;
        if (smilElement.isContainer() && (iterator = ((SmilMediaContainer)smilElement).getElements().iterator()).hasNext()) {
            SmilMediaObject element = (SmilMediaObject)iterator.next();
            return this.getSegmentDurationMS(element);
        }
        SmilMediaElement smilMediaElement = (SmilMediaElement)smilElement;
        return smilMediaElement.getClipEndMS() - smilMediaElement.getClipBeginMS();
    }

    private Map<String, String> exportEmptySegmentDuration(Map<String, String> properties, Track sourceTrack) {
        String durationWfPropertyName = this.getDurationWfPropertyName(sourceTrack);
        properties.put(durationWfPropertyName, Long.toString(0L));
        String relationWfPropertyName = this.getRelationWfPropertyName(sourceTrack);
        properties.put(relationWfPropertyName, String.format("%.0f", 0.0));
        return properties;
    }

    private String getDurationWfPropertyName(Track sourceTrack) {
        return String.format("%s_%s_active_audio_duration", sourceTrack.getFlavor().getType(), sourceTrack.getFlavor().getSubtype());
    }

    private String getRelationWfPropertyName(Track sourceTrack) {
        return String.format("%s_%s_active_audio_duration_percent", sourceTrack.getFlavor().getType(), sourceTrack.getFlavor().getSubtype());
    }

    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering silence detection workflow operation handler");
    }

    @Reference
    public void setDetectionService(SilenceDetectionService detectionService) {
        this.detetionService = detectionService;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

