/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videoeditor.remote;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.videoeditor.api.ProcessFailedException;
import org.opencastproject.videoeditor.api.VideoEditorService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VideoEditorService.class}, property={"service.description=Video Editor Remote Service Proxy"})
public class VideoEditorServiceRemote
extends RemoteBase
implements VideoEditorService {
    private static final Logger logger = LoggerFactory.getLogger(VideoEditorServiceRemote.class);

    public VideoEditorServiceRemote() {
        super("org.opencastproject.videoeditor");
    }

    public List<Job> processSmil(Smil smil) throws ProcessFailedException {
        HttpPost post = new HttpPost("/process-smil");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        try {
            params.add(new BasicNameValuePair("smil", smil.toXML()));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new ProcessFailedException("Unable to assemble a remote videoeditor request for smil " + smil.getId());
        }
        HttpResponse response = null;
        try {
            String entity;
            response = this.getResponse((HttpRequestBase)post);
            if (response != null && StringUtils.isNotEmpty((CharSequence)(entity = EntityUtils.toString((HttpEntity)response.getEntity())))) {
                LinkedList<Job> jobs = new LinkedList<Job>();
                for (JaxbJob job : JobParser.parseJobList((String)entity).getJobs()) {
                    jobs.add(job.toJob());
                }
                logger.info("Start proccessing smil '{}' on remote videoeditor service", (Object)smil.getId());
                LinkedList<Job> linkedList = jobs;
                return linkedList;
            }
        }
        catch (Exception e) {
            throw new ProcessFailedException("Unable to proccess smil " + smil.getId() + " using a remote videoeditor service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new ProcessFailedException("Unable to proccess smil " + smil.getId() + " using a remote videoeditor service.");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

