/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.videoeditor.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.opencastproject.inspection.api.MediaInspectionException;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobBarrier;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageReference;
import org.opencastproject.mediapackage.MediaPackageReferenceImpl;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.smil.entity.media.element.api.SmilMediaElement;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParamGroup;
import org.opencastproject.subtitleparser.webvttparser.WebVTTParser;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitle;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleCue;
import org.opencastproject.subtitleparser.webvttparser.WebVTTWriter;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.videoeditor.api.ProcessFailedException;
import org.opencastproject.videoeditor.api.VideoEditorService;
import org.opencastproject.videoeditor.ffmpeg.FFmpegEdit;
import org.opencastproject.videoeditor.impl.VideoClip;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={VideoEditorService.class, ManagedService.class}, property={"service.description=Video Editor Service"})
public class VideoEditorServiceImpl
extends AbstractJobProducer
implements VideoEditorService,
ManagedService {
    public static final String JOB_LOAD_KEY = "job.load.videoeditor";
    private static final float DEFAULT_JOB_LOAD = 0.8f;
    private float jobload = 0.8f;
    public static final String SEGMENTS_MIN_DURATION_KEY = "segments.min.duration";
    private static final int DEFAULT_SEGMENTS_MIN_DURATION = 2000;
    private int segmentsMinDuration = 2000;
    public static final String SEGMENTS_MIN_CUT_DURATION_KEY = "segments.min.cut.duration";
    private static final int DEFAULT_SEGMENTS_MIN_CUT_DURATION = 2000;
    private int segmentsMinCutDuration = 2000;
    private static final Logger logger = LoggerFactory.getLogger(VideoEditorServiceImpl.class);
    private static final String JOB_TYPE = "org.opencastproject.videoeditor";
    private static final String COLLECTION_ID = "videoeditor";
    private static final String SINK_FLAVOR_SUBTYPE = "trimmed";
    private MediaInspectionService inspectionService = null;
    private Workspace workspace = null;
    private ServiceRegistry serviceRegistry;
    protected OrganizationDirectoryService organizationDirectoryService = null;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected SmilService smilService = null;
    private Properties properties = new Properties();

    public VideoEditorServiceImpl() {
        super(JOB_TYPE);
    }

    protected Track processSmil(Job job, Smil smil, String trackParamGroupId) throws ProcessFailedException {
        Track sourceTrack;
        Job inspectionJob;
        File sourceFile;
        SmilMediaParamGroup trackParamGroup;
        ArrayList<String> inputfile = new ArrayList<String>();
        ArrayList<VideoClip> videoclips = new ArrayList<VideoClip>();
        ArrayList<VideoClip> refElements = new ArrayList<VideoClip>();
        try {
            trackParamGroup = (SmilMediaParamGroup)smil.get(trackParamGroupId);
        }
        catch (SmilException ex) {
            throw new ProcessFailedException("Smil does not contain a paramGroup element with Id " + trackParamGroupId);
        }
        MediaPackageElementFlavor sourceTrackFlavor = null;
        String sourceTrackUri = null;
        MediaPackageReferenceImpl ref = null;
        for (SmilMediaParam param : trackParamGroup.getParams()) {
            if ("track-src".equals(param.getName())) {
                sourceTrackUri = param.getValue();
                continue;
            }
            if ("track-flavor".equals(param.getName())) {
                sourceTrackFlavor = MediaPackageElementFlavor.parseFlavor((String)param.getValue());
                continue;
            }
            if (!"track-id".equals(param.getName())) continue;
            ref = new MediaPackageReferenceImpl("track", param.getValue());
        }
        try {
            sourceFile = this.workspace.get(new URI(sourceTrackUri));
        }
        catch (IOException ex) {
            throw new ProcessFailedException("Can't read " + sourceTrackUri);
        }
        catch (NotFoundException ex) {
            throw new ProcessFailedException("Workspace does not contain a track " + sourceTrackUri);
        }
        catch (URISyntaxException ex) {
            throw new ProcessFailedException("Source URI " + sourceTrackUri + " is not valid.");
        }
        try {
            inspectionJob = this.inspect(job, new URI(sourceTrackUri));
            sourceTrack = (Track)MediaPackageElementParser.getFromXml((String)inspectionJob.getPayload());
        }
        catch (URISyntaxException e) {
            throw new ProcessFailedException("Source URI " + sourceTrackUri + " is not valid.");
        }
        catch (MediaInspectionException e) {
            throw new ProcessFailedException("Media inspection of " + sourceTrackUri + " failed", (Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new ProcessFailedException("Deserialization of source track " + sourceTrackUri + " failed", (Throwable)e);
        }
        File tempDirectory = new File(new File(this.workspace.rootDirectory()), "editor");
        tempDirectory = new File(tempDirectory, Long.toString(job.getId()));
        inputfile.add(sourceFile.getAbsolutePath());
        int srcIndex = inputfile.indexOf(sourceFile.getAbsolutePath());
        logger.info("Start processing srcfile {}", (Object)sourceFile.getAbsolutePath());
        try {
            String extension;
            URI newTrackURI;
            List<VideoClip> cleanclips;
            String filename;
            File outputPath;
            String extension2;
            for (SmilMediaObject element : smil.getBody().getMediaElements()) {
                if (!element.isContainer()) continue;
                SmilMediaContainer container = (SmilMediaContainer)element;
                if (SmilMediaContainer.ContainerType.PAR == container.getContainerType()) {
                    for (SmilMediaObject elementChild : container.getElements()) {
                        if (!elementChild.isContainer()) {
                            int index;
                            SmilMediaElement media = (SmilMediaElement)elementChild;
                            if (!trackParamGroupId.equals(media.getParamGroup())) continue;
                            long begin = media.getClipBeginMS();
                            long end = media.getClipEndMS();
                            URI clipTrackURI = media.getSrc();
                            Object clipSourceFile = null;
                            if (clipTrackURI != null) {
                                try {
                                    clipSourceFile = this.workspace.get(clipTrackURI);
                                }
                                catch (IOException ex) {
                                    throw new ProcessFailedException("Can't read " + String.valueOf(clipTrackURI));
                                }
                                catch (NotFoundException ex) {
                                    throw new ProcessFailedException("Workspace does not contain a track " + String.valueOf(clipTrackURI));
                                }
                            }
                            if (clipSourceFile != null) {
                                index = inputfile.indexOf(((File)clipSourceFile).getAbsolutePath());
                                if (index == -1) {
                                    inputfile.add(((File)clipSourceFile).getAbsolutePath());
                                }
                                index = inputfile.indexOf(((File)clipSourceFile).getAbsolutePath());
                            } else {
                                index = srcIndex;
                            }
                            if (media.getMediaType() == SmilMediaElement.MediaType.REF) {
                                refElements.add(new VideoClip(index, begin, end));
                                continue;
                            }
                            videoclips.add(new VideoClip(index, begin, end));
                            continue;
                        }
                        throw new ProcessFailedException("Smil container '" + ((SmilMediaContainer)elementChild).getContainerType().toString() + "'is not supported yet");
                    }
                    continue;
                }
                throw new ProcessFailedException("Smil container '" + container.getContainerType().toString() + "'is not supported yet");
            }
            if (videoclips.size() > 0 && refElements.size() > 0) {
                throw new ProcessFailedException("Can not process media elements together with ref elements. There likely is an error in the SMIL file");
            }
            Object outputFileExtension = null;
            if (videoclips.size() > 0) {
                outputFileExtension = this.properties.getProperty(".mp4", ".mp4");
            }
            if (refElements.size() > 0 && "vtt".equals(extension2 = FilenameUtils.getExtension((String)sourceTrackUri))) {
                outputFileExtension = this.properties.getProperty("vtt", ".vtt");
            }
            if (!((String)(outputFileExtension = this.properties.getProperty("outputfile.extension", (String)outputFileExtension))).startsWith(".")) {
                outputFileExtension = "." + (String)outputFileExtension;
            }
            if (!(outputPath = new File(tempDirectory, filename = String.format("%s-%s%s", sourceTrackFlavor, FilenameUtils.removeExtension((String)sourceFile.getName()), outputFileExtension))).getParentFile().exists()) {
                outputPath.getParentFile().mkdirs();
            }
            if (videoclips.size() > 0) {
                cleanclips = VideoEditorServiceImpl.sortSegments(videoclips, this.segmentsMinDuration, this.segmentsMinCutDuration);
                String error = null;
                String outputResolution = "";
                FFmpegEdit ffmpeg = new FFmpegEdit(this.properties);
                error = ffmpeg.processEdits(inputfile, outputPath.getAbsolutePath(), outputResolution, cleanclips, sourceTrack.hasAudio(), sourceTrack.hasVideo());
                if (error != null) {
                    FileUtils.deleteQuietly((File)tempDirectory);
                    throw new ProcessFailedException("Editing pipeline exited abnormally! Error: " + error);
                }
            }
            if (refElements.size() > 0) {
                cleanclips = VideoEditorServiceImpl.sortSegments(refElements, this.segmentsMinDuration, this.segmentsMinCutDuration);
                String extension3 = FilenameUtils.getExtension((String)sourceTrackUri);
                if ("vtt".equals(extension3)) {
                    WebVTTSubtitle subtitle;
                    WebVTTParser parser = new WebVTTParser();
                    try (FileInputStream fin = new FileInputStream(sourceFile);){
                        subtitle = parser.parse((InputStream)fin);
                    }
                    ArrayList<WebVTTSubtitleCue> cutCues = new ArrayList<WebVTTSubtitleCue>();
                    double removedTime = 0.0;
                    for (int i = 0; i < cleanclips.size(); ++i) {
                        removedTime = i == 0 ? (removedTime += (double)cleanclips.get(i).getStartInMilliseconds()) : removedTime + (double)cleanclips.get(i).getStartInMilliseconds() - (double)cleanclips.get(i - 1).getEndInMilliseconds();
                        for (WebVTTSubtitleCue cue : subtitle.getCues()) {
                            if (cleanclips.get(i).getStartInMilliseconds() - 500L > cue.getStartTime() || cleanclips.get(i).getEndInMilliseconds() + 500L < cue.getEndTime()) continue;
                            cue.setStartTime((long)((double)cue.getStartTime() - removedTime));
                            cue.setEndTime((long)((double)cue.getEndTime() - removedTime));
                            cutCues.add(cue);
                        }
                    }
                    subtitle.setCues(cutCues);
                    try (FileOutputStream fos = new FileOutputStream(outputPath);){
                        WebVTTWriter writer = new WebVTTWriter();
                        writer.write(subtitle, (OutputStream)fos);
                    }
                }
                throw new ProcessFailedException("The video editor does not support the following file: " + sourceTrackUri);
            }
            String newTrackId = IdImpl.fromUUID().toString();
            FileInputStream in = new FileInputStream(outputPath);
            try {
                newTrackURI = this.workspace.putInCollection(COLLECTION_ID, String.format("%s-%s%s", sourceTrackFlavor.getType(), newTrackId, outputFileExtension), (InputStream)in);
            }
            catch (IllegalArgumentException ex) {
                throw new ProcessFailedException("Copy track into workspace failed! " + ex.getMessage());
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                FileUtils.deleteQuietly((File)tempDirectory);
            }
            try {
                inspectionJob = this.inspect(job, newTrackURI);
            }
            catch (MediaInspectionException e) {
                throw new ProcessFailedException("Media inspection of " + String.valueOf(newTrackURI) + " failed", (Throwable)e);
            }
            Track editedTrack = (Track)MediaPackageElementParser.getFromXml((String)inspectionJob.getPayload());
            logger.info("Finished editing track {}", (Object)editedTrack);
            editedTrack.setIdentifier(newTrackId);
            editedTrack.setReference((MediaPackageReference)ref);
            if (videoclips.size() > 0) {
                editedTrack.setFlavor(new MediaPackageElementFlavor(sourceTrackFlavor.getType(), SINK_FLAVOR_SUBTYPE));
            }
            if (refElements.size() > 0 && "vtt".equals(extension = FilenameUtils.getExtension((String)sourceTrackUri))) {
                editedTrack.setFlavor(new MediaPackageElementFlavor(sourceTrackFlavor.getType(), sourceTrackFlavor.getSubtype() + "+trimmed"));
            }
            Track track = editedTrack;
            return track;
        }
        catch (MediaInspectionException ex) {
            throw new ProcessFailedException("Inspecting encoded Track failed with: " + ex.getMessage());
        }
        catch (MediaPackageException ex) {
            throw new ProcessFailedException("Unable to serialize edited Track! " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new ProcessFailedException("Unable to process SMIL: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            FileUtils.deleteQuietly((File)tempDirectory);
        }
    }

    protected Job inspect(Job job, URI workspaceURI) throws MediaInspectionException, ProcessFailedException {
        Job inspectionJob;
        try {
            inspectionJob = this.inspectionService.inspect(workspaceURI);
        }
        catch (MediaInspectionException e) {
            this.incident().recordJobCreationIncident(job, (Throwable)e);
            throw new MediaInspectionException("Media inspection of " + String.valueOf(workspaceURI) + " failed", (Throwable)e);
        }
        JobBarrier barrier = new JobBarrier(job, this.serviceRegistry, new Job[]{inspectionJob});
        if (!barrier.waitForJobs().isSuccess()) {
            throw new ProcessFailedException("Media inspection of " + String.valueOf(workspaceURI) + " failed");
        }
        return inspectionJob;
    }

    private static List<VideoClip> sortSegments(List<VideoClip> edits, int segmentsMinDuration, int segmentsMinCutDuration) {
        VideoClip clip2;
        LinkedList<VideoClip> ll = new LinkedList<VideoClip>();
        ArrayList<VideoClip> clips = new ArrayList<VideoClip>();
        for (VideoClip clip2 : edits) {
            if (clip2.getDurationInMilliseconds() <= (long)segmentsMinDuration) continue;
            ll.add(clip2);
        }
        clip2 = (VideoClip)ll.pop();
        while (!ll.isEmpty()) {
            if (ll.peek() == null) continue;
            VideoClip nextclip = (VideoClip)ll.pop();
            if (nextclip.getSrc() == clip2.getSrc() && nextclip.getStartInMilliseconds() - clip2.getEndInMilliseconds() < (long)segmentsMinCutDuration) {
                clip2.setEnd(nextclip.getEndInMilliseconds());
                continue;
            }
            clips.add(clip2);
            clip2 = nextclip;
        }
        clips.add(clip2);
        return clips;
    }

    public List<Job> processSmil(Smil smil) throws ProcessFailedException {
        if (smil == null) {
            throw new ProcessFailedException("Smil document is null!");
        }
        LinkedList<Job> jobs = new LinkedList<Job>();
        try {
            for (SmilMediaParamGroup paramGroup : smil.getHead().getParamGroups()) {
                for (SmilMediaParam param : paramGroup.getParams()) {
                    if (!"track-id".equals(param.getName())) continue;
                    jobs.add(this.serviceRegistry.createJob(this.getJobType(), Operation.PROCESS_SMIL.toString(), Arrays.asList(smil.toXML(), paramGroup.getId()), Float.valueOf(this.jobload)));
                }
            }
            return jobs;
        }
        catch (JAXBException ex) {
            throw new ProcessFailedException("Failed to serialize smil " + smil.getId());
        }
        catch (ServiceRegistryException ex) {
            throw new ProcessFailedException("Failed to create job: " + ex.getMessage());
        }
        catch (Exception ex) {
            throw new ProcessFailedException(ex.getMessage());
        }
    }

    protected String process(Job job) throws Exception {
        if (Operation.PROCESS_SMIL.toString().equals(job.getOperation())) {
            Smil smil = this.smilService.fromXml((String)job.getArguments().get(0)).getSmil();
            if (smil == null) {
                throw new ProcessFailedException("Smil document is null!");
            }
            Track editedTrack = this.processSmil(job, smil, (String)job.getArguments().get(1));
            return MediaPackageElementParser.getAsXml((MediaPackageElement)editedTrack);
        }
        throw new ProcessFailedException("Can't handle this operation: " + job.getOperation());
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    @Activate
    public void activate(ComponentContext context) {
        logger.debug("activating...");
        super.activate(context);
        FFmpegEdit.init(context.getBundleContext());
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        logger.debug("deactivating...");
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.properties = new Properties();
        if (properties == null) {
            logger.info("No configuration available, using defaults");
            return;
        }
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            this.properties.put(key, properties.get(key));
        }
        logger.debug("Properties updated!");
        this.jobload = LoadUtil.getConfiguredLoadValue(properties, (String)JOB_LOAD_KEY, (Float)Float.valueOf(0.8f), (ServiceRegistry)this.serviceRegistry);
        this.segmentsMinDuration = Integer.parseInt(this.properties.getProperty(SEGMENTS_MIN_DURATION_KEY, String.valueOf(2000)));
        this.segmentsMinCutDuration = Integer.parseInt(this.properties.getProperty(SEGMENTS_MIN_CUT_DURATION_KEY, String.valueOf(2000)));
    }

    @Reference
    public void setMediaInspectionService(MediaInspectionService inspectionService) {
        this.inspectionService = inspectionService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    private static enum Operation {
        PROCESS_SMIL;

    }
}

