/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.usertracking.endpoint;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.usertracking.api.UserTrackingException;
import org.opencastproject.usertracking.api.UserTrackingService;
import org.opencastproject.usertracking.endpoint.FootprintsListImpl;
import org.opencastproject.usertracking.endpoint.ReportImpl;
import org.opencastproject.usertracking.endpoint.StatsImpl;
import org.opencastproject.usertracking.impl.UserActionImpl;
import org.opencastproject.usertracking.impl.UserActionListImpl;
import org.opencastproject.usertracking.impl.UserSessionImpl;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@RestService(name="usertracking", title="User Tracking Service", abstractText="This service is used for tracking user interaction creates, edits and retrieves user actions and viewing statistics.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={UserTrackingRestService.class}, property={"service.description=User Tracking REST Endpoint", "opencast.service.type=org.opencastproject.usertracking", "opencast.service.path=/usertracking"})
public class UserTrackingRestService {
    private static final Logger logger = LoggerFactory.getLogger(UserTrackingRestService.class);
    private UserTrackingService usertrackingService;
    protected SecurityService securityService;
    protected String serverUrl = "http://localhost:8080";
    protected String serviceUrl = "/usertracking";

    @Reference
    public void setService(UserTrackingService service) {
        this.usertrackingService = service;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    public void activate(ComponentContext cc) {
        if (cc == null) {
            this.serverUrl = "http://localhost:8080";
        } else {
            String ccServerUrl = cc.getBundleContext().getProperty("org.opencastproject.server.url");
            logger.info("configured server url is {}", (Object)ccServerUrl);
            this.serverUrl = ccServerUrl == null ? "http://localhost:8080" : ccServerUrl;
            this.serviceUrl = (String)cc.getProperties().get("opencast.service.path");
        }
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="/actions.xml")
    @RestQuery(name="actionsasxml", description="Get user actions by type and day", returnDescription="The user actions.", restParameters={@RestParameter(name="type", description="The type of the user action", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="day", description="The day of creation (format: YYYYMMDD)", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="An XML representation of the user actions")})
    public UserActionListImpl getUserActionsAsXml(@QueryParam(value="id") String id, @QueryParam(value="type") String type, @QueryParam(value="day") String day, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        if (offset < 0 || limit < 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (limit == 0) {
            limit = 10;
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)id) && !StringUtils.isEmpty((CharSequence)type)) {
                return (UserActionListImpl)this.usertrackingService.getUserActionsByTypeAndMediapackageId(type, id, offset, limit);
            }
            if (!StringUtils.isEmpty((CharSequence)type) && !StringUtils.isEmpty((CharSequence)day)) {
                return (UserActionListImpl)this.usertrackingService.getUserActionsByTypeAndDay(type, day, offset, limit);
            }
            if (!StringUtils.isEmpty((CharSequence)type)) {
                return (UserActionListImpl)this.usertrackingService.getUserActionsByType(type, offset, limit);
            }
            if (!StringUtils.isEmpty((CharSequence)day)) {
                return (UserActionListImpl)this.usertrackingService.getUserActionsByDay(day, offset, limit);
            }
            return (UserActionListImpl)this.usertrackingService.getUserActions(offset, limit);
        }
        catch (UserTrackingException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/actions.json")
    @RestQuery(name="actionsasjson", description="Get user actions by type and day", returnDescription="The user actions.", restParameters={@RestParameter(name="type", description="The type of the user action", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="day", description="The day of creation (format: YYYYMMDD)", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the user actions")})
    public UserActionListImpl getUserActionsAsJson(@QueryParam(value="id") String id, @QueryParam(value="type") String type, @QueryParam(value="day") String day, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        return this.getUserActionsAsXml(id, type, day, limit, offset);
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="/stats.xml")
    @RestQuery(name="statsasxml", description="Get the statistics for an episode", returnDescription="The statistics.", restParameters={@RestParameter(name="id", description="The ID of the single episode to return the statistics for, if it exists", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the episode's statistics")})
    public StatsImpl statsAsXml(@QueryParam(value="id") String mediapackageId) {
        StatsImpl s = new StatsImpl();
        s.setMediapackageId(mediapackageId);
        try {
            s.setViews(this.usertrackingService.getViews(mediapackageId));
        }
        catch (UserTrackingException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return s;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/stats.json")
    @RestQuery(name="statsasjson", description="Get the statistics for an episode", returnDescription="The statistics.", restParameters={@RestParameter(name="id", description="The ID of the single episode to return the statistics for, if it exists", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the episode's statistics")})
    public StatsImpl statsAsJson(@QueryParam(value="id") String mediapackageId) {
        return this.statsAsXml(mediapackageId);
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="/report.xml")
    @RestQuery(name="reportasxml", description="Get a report for a time range", returnDescription="The report.", restParameters={@RestParameter(name="from", description="The beginning of the time range", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="to", description="The end of the time range", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="An XML representation of the report")})
    public ReportImpl reportAsXml(@QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) {
        if (offset < 0 || limit < 0) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        if (limit == 0) {
            limit = 10;
        }
        try {
            if (from == null && to == null) {
                return (ReportImpl)this.usertrackingService.getReport(offset, limit);
            }
            return (ReportImpl)this.usertrackingService.getReport(from, to, offset, limit);
        }
        catch (UserTrackingException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (ParseException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/report.json")
    @RestQuery(name="reportasjson", description="Get a report for a time range", returnDescription="The report.", restParameters={@RestParameter(name="from", description="The beginning of the time range", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="to", description="The end of the time range", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", description="The maximum number of items to return per page", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", description="The page number", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the report")})
    public ReportImpl reportAsJson(@QueryParam(value="from") String from, @QueryParam(value="to") String to, @QueryParam(value="offset") int offset, @QueryParam(value="limit") int limit) {
        return this.reportAsXml(from, to, offset, limit);
    }

    @PUT
    @Path(value="")
    @Produces(value={"text/xml"})
    @RestQuery(name="add", description="Record a user action", returnDescription="An XML representation of the user action", restParameters={@RestParameter(name="id", description="The episode identifier", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="type", description="The episode identifier", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="in", description="The beginning of the time range", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="out", description="The end of the time range", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="playing", description="Whether the player is currently playing", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=201, description="An XML representation of the user action")})
    public Response addFootprint(@FormParam(value="id") String mediapackageId, @FormParam(value="in") String inString, @FormParam(value="out") String outString, @FormParam(value="type") String type, @FormParam(value="playing") String isPlaying, @Context HttpServletRequest request) {
        URI uri;
        String sessionId = request.getSession().getId();
        String userId = this.securityService.getUser().getUsername();
        if (StringUtils.isEmpty((CharSequence)inString)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"in must be a non null integer").build());
        }
        Integer in = null;
        try {
            in = Integer.parseInt(StringUtils.trim((String)inString));
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"in must be a non null integer").build());
        }
        Integer out = null;
        if (StringUtils.isEmpty((CharSequence)outString)) {
            out = in;
        } else {
            try {
                out = Integer.parseInt(StringUtils.trim((String)outString));
            }
            catch (NumberFormatException e) {
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"out must be a non null integer").build());
            }
        }
        String clientIP = request.getHeader("X-FORWARDED-FOR");
        if (clientIP == null) {
            clientIP = request.getRemoteAddr();
        }
        logger.debug("Got client ip: {}", (Object)clientIP);
        UserSessionImpl s = new UserSessionImpl();
        s.setSessionId(sessionId);
        s.setUserIp(clientIP);
        s.setUserId(userId);
        String userAgent = StringUtils.trimToNull((String)request.getHeader("User-Agent"));
        if (userAgent != null && userAgent.length() > 255) {
            s.setUserAgent(userAgent.substring(0, 255));
        } else {
            s.setUserAgent(userAgent);
        }
        UserActionImpl a = new UserActionImpl();
        a.setMediapackageId(mediapackageId);
        a.setSession(s);
        a.setInpoint(in);
        a.setOutpoint(out);
        a.setType(type);
        a.setIsPlaying(Boolean.valueOf(isPlaying));
        try {
            a = "FOOTPRINT".equals(type) ? (UserActionImpl)this.usertrackingService.addUserFootprint(a, s) : (UserActionImpl)this.usertrackingService.addUserTrackingEvent(a, s);
        }
        catch (UserTrackingException e) {
            throw new WebApplicationException((Throwable)e);
        }
        try {
            uri = new URI(UrlSupport.concat((String[])new String[]{this.serverUrl, this.serviceUrl, "action", a.getId().toString(), ".xml"}));
        }
        catch (URISyntaxException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return Response.created((URI)uri).entity((Object)a).build();
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="/action/{id}.xml")
    @RestQuery(name="add", description="Record a user action", returnDescription="An XML representation of the user action", pathParameters={@RestParameter(name="id", description="The episode identifier", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the user action")})
    public UserActionImpl getActionAsXml(@PathParam(value="id") String actionId) {
        Long id = null;
        try {
            id = Long.parseLong(actionId);
        }
        catch (NumberFormatException e) {
            throw new WebApplicationException((Throwable)e);
        }
        try {
            return (UserActionImpl)this.usertrackingService.getUserAction(id);
        }
        catch (UserTrackingException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (NotFoundException e) {
            return null;
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/action/{id}.json")
    @RestQuery(name="add", description="Record a user action", returnDescription="A JSON representation of the user action", pathParameters={@RestParameter(name="id", description="The episode identifier", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the user action")})
    public UserActionImpl getActionAsJson(@PathParam(value="id") String actionId) {
        return this.getActionAsXml(actionId);
    }

    @GET
    @Produces(value={"text/xml"})
    @Path(value="/footprint.xml")
    @RestQuery(name="footprintasxml", description="Gets the 'footprint' action for an episode", returnDescription="An XML representation of the footprints", restParameters={@RestParameter(name="id", description="The episode identifier", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="An XML representation of the footprints")})
    public FootprintsListImpl getFootprintAsXml(@QueryParam(value="id") String mediapackageId) {
        String userId = this.securityService.getUser().getUsername();
        if (mediapackageId == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            return (FootprintsListImpl)this.usertrackingService.getFootprints(mediapackageId, userId);
        }
        catch (UserTrackingException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/footprint.json")
    @RestQuery(name="footprintasxml", description="Gets the 'footprint' action for an episode", returnDescription="A JSON representation of the footprints", restParameters={@RestParameter(name="id", description="The episode identifier", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="A JSON representation of the footprints")})
    public FootprintsListImpl getFootprintAsJson(@QueryParam(value="id") String mediapackageId) {
        return this.getFootprintAsXml(mediapackageId);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/detailenabled")
    public Response getUserTrackingEnabled() {
        return Response.ok((Object)this.usertrackingService.getUserTrackingEnabled()).build();
    }
}

