/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.utils;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;

public final class UserDirectoryUtils {
    private UserDirectoryUtils() {
    }

    public static boolean isCurrentUserAuthorizedHandleRoles(SecurityService securityService, Set<Role> roles) {
        User user = securityService.getUser();
        if (user == null) {
            return false;
        }
        Organization org = user.getOrganization();
        for (Role role : roles) {
            if (StringUtils.equals((CharSequence)"ROLE_ADMIN", (CharSequence)role.getName())) {
                return user.hasRole("ROLE_ADMIN");
            }
            if (org == null || !StringUtils.equals((CharSequence)org.getAdminRole(), (CharSequence)role.getName())) continue;
            return user.hasRole("ROLE_ADMIN") || user.hasRole(org.getAdminRole());
        }
        return true;
    }
}

