/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.endpoint;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONValue;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.JaxbUserList;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUser;
import org.opencastproject.userdirectory.JpaUserAndRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/user-utils")
@RestService(name="UsersUtils", title="User utils", notes={"This service offers the default CRUD Operations for the internal Opencast users."}, abstractText="Provides operations for internal Opencast users")
@Component(property={"service.description=User REST endpoint", "opencast.service.type=org.opencastproject.userdirectory.endpoint.UserEndpoint", "opencast.service.path=/user-utils", "opencast.service.jobproducer=false"}, immediate=true, service={UserEndpoint.class})
@JaxrsResource
public class UserEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(UserEndpoint.class);
    private JpaUserAndRoleProvider jpaUserAndRoleProvider;
    private SecurityService securityService;
    private String endpointBaseUrl;

    public void activate(ComponentContext cc) {
        logger.info("Start users endpoint");
        Tuple endpointUrl = RestUtil.getEndpointUrl((ComponentContext)cc);
        this.endpointBaseUrl = UrlSupport.concat((String)((String)endpointUrl.getA()), (String)((String)endpointUrl.getB()));
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setJpaUserAndRoleProvider(JpaUserAndRoleProvider jpaUserAndRoleProvider) {
        this.jpaUserAndRoleProvider = jpaUserAndRoleProvider;
    }

    @GET
    @Path(value="users.json")
    @Produces(value={"application/json"})
    @RestQuery(name="allusersasjson", description="Returns a list of users", returnDescription="Returns a JSON representation of the list of user accounts", restParameters={@RestParameter(name="limit", defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="offset", defaultValue="0", description="The page number.", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user accounts.")})
    public JaxbUserList getUsersAsJson(@QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws IOException {
        if (limit < 1) {
            limit = 100;
        }
        JaxbUserList userList = new JaxbUserList();
        Iterator<User> i = this.jpaUserAndRoleProvider.findUsers("%", offset, limit);
        while (i.hasNext()) {
            userList.add(i.next());
        }
        return userList;
    }

    @GET
    @Path(value="{username}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="user", description="Returns a user", returnDescription="Returns a JSON representation of a user", pathParameters={@RestParameter(name="username", description="The username.", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user account."), @RestResponse(responseCode=404, description="User not found")})
    public Response getUserAsJson(@PathParam(value="username") String username) throws NotFoundException {
        User user = this.jpaUserAndRoleProvider.loadUser(username);
        if (user == null) {
            logger.debug("Requested user not found: {}", (Object)username);
            return Response.status((int)404).build();
        }
        return Response.ok((Object)JaxbUser.fromUser((User)user)).build();
    }

    @GET
    @Path(value="users/md5.json")
    @Produces(value={"application/json"})
    @RestQuery(name="users-with-insecure-hashing", description="Returns a list of users which passwords are stored using MD5 hashes", returnDescription="Returns a JSON representation of the list of matching user accounts", responses={@RestResponse(responseCode=200, description="The user accounts.")})
    public JaxbUserList getUserWithInsecurePasswordHashingAsJson() {
        JaxbUserList userList = new JaxbUserList();
        for (User user : this.jpaUserAndRoleProvider.findInsecurePasswordHashes()) {
            userList.add(user);
        }
        return userList;
    }

    @POST
    @Path(value="/")
    @RestQuery(name="createUser", description="Create a new  user", returnDescription="Location of the new ressource", restParameters={@RestParameter(name="username", description="The username.", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="password", description="The password.", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="name", description="The name.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="email", description="The email.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="The user roles as a json array, for example: [\"ROLE_USER\", \"ROLE_ADMIN\"]", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=400, description="Malformed request syntax."), @RestResponse(responseCode=201, description="User has been created."), @RestResponse(responseCode=409, description="An user with this username already exist."), @RestResponse(responseCode=403, description="Not enough permissions to create a user with the admin role.")})
    public Response createUser(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="name") String name, @FormParam(value="email") String email, @FormParam(value="roles") String roles) {
        if (this.jpaUserAndRoleProvider.loadUser(username) != null) {
            return Response.status((int)409).build();
        }
        try {
            Set<JpaRole> rolesSet = this.parseRoles(roles);
            logger.debug("Updating user {}", (Object)username);
            JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
            JpaUser user = new JpaUser(username, password, organization, name, email, this.jpaUserAndRoleProvider.getName(), true, rolesSet);
            try {
                this.jpaUserAndRoleProvider.addUser(user);
                return Response.created((URI)UrlSupport.uri((Object[])new Object[]{this.endpointBaseUrl, user.getUsername() + ".json"})).build();
            }
            catch (UnauthorizedException ex) {
                logger.debug("Create user failed", (Throwable)ex);
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
        }
        catch (IllegalArgumentException e) {
            logger.debug("Request with malformed ROLE data: {}", (Object)roles);
            return Response.status((int)400).build();
        }
    }

    @PUT
    @Path(value="{username}.json")
    @RestQuery(name="updateUser", description="Update an user", returnDescription="Status ok", restParameters={@RestParameter(name="password", description="The password.", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="name", description="The name.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="email", description="The email.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="The user roles as a json array, for example: [\"ROLE_USER\", \"ROLE_ADMIN\"]", isRequired=false, type=RestParameter.Type.STRING)}, pathParameters={@RestParameter(name="username", description="The username", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=400, description="Malformed request syntax."), @RestResponse(responseCode=403, description="Not enough permissions to update a user with the admin role."), @RestResponse(responseCode=200, description="User has been updated.")})
    public Response setUser(@PathParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="name") String name, @FormParam(value="email") String email, @FormParam(value="roles") String roles) {
        try {
            User user = this.jpaUserAndRoleProvider.loadUser(username);
            if (user == null) {
                return this.createUser(username, password, name, email, roles);
            }
            Set<JpaRole> rolesSet = this.parseRoles(roles);
            logger.debug("Updating user {}", (Object)username);
            JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
            this.jpaUserAndRoleProvider.updateUser(new JpaUser(username, password, organization, name, email, this.jpaUserAndRoleProvider.getName(), true, rolesSet));
            return Response.status((int)200).build();
        }
        catch (NotFoundException e) {
            logger.debug("User {} not found.", (Object)username);
            return Response.status((int)404).build();
        }
        catch (UnauthorizedException e) {
            logger.debug("Update user failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (IllegalArgumentException e) {
            logger.debug("Request with malformed ROLE data: {}", (Object)roles);
            return Response.status((int)400).build();
        }
    }

    @DELETE
    @Path(value="{username}.json")
    @RestQuery(name="deleteUser", description="Delete a new  user", returnDescription="Status ok", pathParameters={@RestParameter(name="username", type=RestParameter.Type.STRING, isRequired=true, description="The username")}, responses={@RestResponse(responseCode=200, description="User has been deleted."), @RestResponse(responseCode=403, description="Not enough permissions to delete a user with the admin role."), @RestResponse(responseCode=404, description="User not found.")})
    public Response deleteUser(@PathParam(value="username") String username) {
        try {
            this.jpaUserAndRoleProvider.deleteUser(username, this.securityService.getOrganization().getId());
        }
        catch (NotFoundException e) {
            logger.debug("User {} not found.", (Object)username);
            return Response.status((int)404).build();
        }
        catch (UnauthorizedException e) {
            logger.debug("Error during deletion of user {}", (Object)username, (Object)e);
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            logger.error("Error during deletion of user {}", (Object)username, (Object)e);
            return Response.status((int)500).build();
        }
        logger.debug("User {} removed.", (Object)username);
        return Response.status((int)200).build();
    }

    private Set<JpaRole> parseRoles(String roles) throws IllegalArgumentException {
        JSONArray rolesArray = null;
        try {
            rolesArray = (JSONArray)JSONValue.parseWithException((String)(StringUtils.isEmpty((CharSequence)roles) ? "[]" : roles));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing JSON array", e);
        }
        HashSet<JpaRole> rolesSet = new HashSet<JpaRole>();
        for (Object role : rolesArray) {
            try {
                rolesSet.add(new JpaRole((String)role, (JpaOrganization)this.securityService.getOrganization()));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Error parsing array vales as String", e);
            }
        }
        return rolesSet;
    }
}

