/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.endpoint;

import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.JaxbGroupList;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.userdirectory.ConflictException;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/groups")
@RestService(name="groups", title="Internal group manager", abstractText="This service offers the ability to manage the groups for internal accounts.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(property={"service.description=Group Role REST EndPoint", "opencast.service.type=org.opencastproject.userdirectory.endpoint.GroupRoleEndpoint", "opencast.service.jobproducer=false", "opencast.service.path=/groups"}, immediate=false, service={GroupRoleEndpoint.class})
@JaxrsResource
public class GroupRoleEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(GroupRoleEndpoint.class);
    private JpaGroupRoleProvider jpaGroupRoleProvider;

    @Reference
    public void setJpaGroupRoleProvider(JpaGroupRoleProvider jpaGroupRoleProvider) {
        this.jpaGroupRoleProvider = jpaGroupRoleProvider;
    }

    @Activate
    public void activate() {
        logger.info("Activating  {}", (Object)this.getClass().getName());
    }

    @GET
    @Produces(value={"text/xml", "application/json"})
    @Path(value="groups.{format:xml|json}")
    @RestQuery(name="allgroup", description="Returns a list of groups", returnDescription="Returns a JSON or XML representation of the list of groups available the current user's organization", pathParameters={@RestParameter(name="format", description="The output format (json or xml) of the response body.", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="limit", defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="offset", defaultValue="0", description="The page number.", isRequired=false, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The groups.")})
    public Response getGroupsAsJsonOrXml(@PathParam(value="format") String format, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) {
        try {
            String type = "json".equals(format) ? "application/json" : "application/xml";
            JaxbGroupList list = this.jpaGroupRoleProvider.getGroups(limit, offset);
            return Response.ok().entity((Object)list).type(type).build();
        }
        catch (Exception e) {
            logger.info("Unable to get groups", (Throwable)e);
            return Response.serverError().entity((Object)this.buildUnexpectedErrorMessage(e)).build();
        }
    }

    @DELETE
    @Path(value="{id}")
    @RestQuery(name="removegroup", description="Remove a group", returnDescription="Return no content", pathParameters={@RestParameter(name="id", description="The group identifier", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Group deleted"), @RestResponse(responseCode=403, description="Not enough permissions to remove a group with the admin role."), @RestResponse(responseCode=404, description="Group not found."), @RestResponse(responseCode=500, description="An internal server error occured.")})
    public Response removeGroup(@PathParam(value="id") String groupId) {
        try {
            this.jpaGroupRoleProvider.removeGroup(groupId);
            return Response.noContent().build();
        }
        catch (NotFoundException e) {
            return Response.status((int)404).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="")
    @RestQuery(name="createGroup", description="Add a group", returnDescription="Return the status codes", restParameters={@RestParameter(name="name", description="The group name", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="description", description="The group description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="A comma seperated string of additional group roles", isRequired=false, type=RestParameter.Type.TEXT), @RestParameter(name="users", description="A comma seperated string of group members", isRequired=false, type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=201, description="Group created"), @RestResponse(responseCode=400, description="Name too long"), @RestResponse(responseCode=403, description="Not enough permissions to create a group with the admin role."), @RestResponse(responseCode=409, description="An group with this name already exists.")})
    public Response createGroup(@FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="roles") String roles, @FormParam(value="users") String users) {
        try {
            this.jpaGroupRoleProvider.createGroup(name, description, roles, users);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to create group {}: {}", (Object)name, (Object)e.getMessage());
            return Response.status((int)400).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((int)403).build();
        }
        catch (ConflictException e) {
            return Response.status((int)409).build();
        }
        return Response.status((int)201).build();
    }

    @PUT
    @Path(value="{id}")
    @RestQuery(name="updateGroup", description="Update a group", returnDescription="Return the status codes", pathParameters={@RestParameter(name="id", description="The group identifier", isRequired=true, type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="name", description="The group name", isRequired=true, type=RestParameter.Type.STRING), @RestParameter(name="description", description="The group description", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="roles", description="A comma seperated string of additional group roles", isRequired=false, type=RestParameter.Type.TEXT), @RestParameter(name="users", description="A comma seperated string of group members", isRequired=true, type=RestParameter.Type.TEXT)}, responses={@RestResponse(responseCode=200, description="Group updated"), @RestResponse(responseCode=403, description="Not enough permissions to update a group with the admin role."), @RestResponse(responseCode=404, description="Group not found"), @RestResponse(responseCode=400, description="Name too long")})
    public Response updateGroup(@PathParam(value="id") String groupId, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="roles") String roles, @FormParam(value="users") String users) throws NotFoundException {
        try {
            this.jpaGroupRoleProvider.updateGroup(groupId, name, description, roles, users);
        }
        catch (IllegalArgumentException e) {
            logger.warn("Unable to update group id {}: {}", (Object)groupId, (Object)e.getMessage());
            return Response.status((int)400).build();
        }
        catch (UnauthorizedException ex) {
            return Response.status((int)403).build();
        }
        return Response.ok().build();
    }

    private String buildUnexpectedErrorMessage(Exception e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Unexpected error (").append(e.getClass().getName()).append(")");
        String message = e.getMessage();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            sb.append(": ").append(message);
        }
        return sb.toString();
    }
}

