/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides the user id role"}, immediate=true, service={RoleProvider.class, UserIdRoleProvider.class, ManagedService.class})
public class UserIdRoleProvider
implements RoleProvider,
ManagedService {
    private static final String ROLE_USER = "ROLE_USER";
    private static final String ROLE_USER_PREFIX_KEY = "role.user.prefix";
    private static final String DEFAULT_ROLE_USER_PREFIX = "ROLE_USER_";
    private static final String SANITIZE_KEY = "sanitize";
    private static final boolean DEFAULT_SANITIZE = true;
    private static final CharMatcher SAFE_USERNAME = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).negate().precomputed();
    private static final Logger logger = LoggerFactory.getLogger(UserIdRoleProvider.class);
    protected SecurityService securityService = null;
    private static String userRolePrefix = "ROLE_USER_";
    private static boolean sanitize = true;
    protected UserDirectoryService userDirectoryService = null;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public static boolean isSanitize() {
        return sanitize;
    }

    public static String getUserRolePrefix() {
        return userRolePrefix;
    }

    public static String getUserIdRole(String userName) {
        if (sanitize) {
            userName = SAFE_USERNAME.replaceFrom((CharSequence)userName, (CharSequence)"_").toUpperCase();
        }
        return userRolePrefix.concat(userName);
    }

    public List<Role> getRolesForUser(String userName) {
        Organization organization = this.securityService.getOrganization();
        ArrayList<JaxbRole> roles = new ArrayList<JaxbRole>();
        roles.add(new JaxbRole(UserIdRoleProvider.getUserIdRole(userName), JaxbOrganization.fromOrganization((Organization)organization), "The user id role", Role.Type.SYSTEM));
        roles.add(new JaxbRole(ROLE_USER, JaxbOrganization.fromOrganization((Organization)organization), "The authenticated user role", Role.Type.SYSTEM));
        return Collections.unmodifiableList(roles);
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        if (target == Role.Target.USER) {
            return Collections.emptyIterator();
        }
        logger.debug("findRoles(query={} offset={} limit={})", new Object[]{query, offset, limit});
        HashSet<JaxbRole> foundRoles = new HashSet<JaxbRole>();
        Organization organization = this.securityService.getOrganization();
        if (UserIdRoleProvider.like(ROLE_USER, query)) {
            foundRoles.add(new JaxbRole(ROLE_USER, JaxbOrganization.fromOrganization((Organization)organization), "The authenticated user role", Role.Type.SYSTEM));
        }
        if (!"%".equals(query) && !query.startsWith(userRolePrefix)) {
            return foundRoles.iterator();
        }
        String userQuery = "%";
        if (query.startsWith(userRolePrefix)) {
            userQuery = query.substring(userRolePrefix.length());
        }
        Iterator users = this.userDirectoryService.findUsers(userQuery, offset, limit);
        while (users.hasNext()) {
            User u = (User)users.next();
            if ("system".equals(u.getProvider())) continue;
            foundRoles.add(new JaxbRole(UserIdRoleProvider.getUserIdRole(u.getUsername()), JaxbOrganization.fromOrganization((Organization)u.getOrganization()), "User id role", Role.Type.SYSTEM));
        }
        return foundRoles.iterator();
    }

    private static boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        Option userPrefixProperty = OsgiUtil.getOptCfg((Dictionary)properties, (String)ROLE_USER_PREFIX_KEY);
        if (userPrefixProperty.isSome()) {
            userRolePrefix = (String)userPrefixProperty.get();
            logger.info("Using configured userRole prefix '{}'", (Object)userRolePrefix);
        } else {
            userRolePrefix = DEFAULT_ROLE_USER_PREFIX;
            logger.info("Using default userRole prefix '{}'", (Object)userRolePrefix);
        }
        Option sanitizeProperty = OsgiUtil.getOptCfg((Dictionary)properties, (String)SANITIZE_KEY);
        if (sanitizeProperty.isSome()) {
            sanitize = BooleanUtils.toBoolean((String)((String)sanitizeProperty.get()));
            logger.info("Using configured will sanitize user names '{}'", (Object)sanitize);
        } else {
            sanitize = true;
            logger.info("Using default for sanitizing user names '{}'", (Object)sanitize);
        }
    }
}

