/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.io.IOException;
import java.util.Iterator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.JaxbUserList;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/users")
@RestService(name="users", title="User account manager", notes={"This service offers the ability to manage the roles for internal accounts."}, abstractText="Displays the users available in the current user's organization")
@Component(property={"service.description=User listing REST endpoint", "opencast.service.type=org.opencastproject.userdirectory.users", "opencast.service.path=/users", "opencast.service.jobproducer=false"}, immediate=true, service={UserEndpoint.class})
@JaxrsResource
public class UserEndpoint {
    protected UserDirectoryService userDirectoryService = null;

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @GET
    @Path(value="users.xml")
    @Produces(value={"application/xml"})
    @RestQuery(name="allusersasxml", description="Returns a list of users", returnDescription="Returns a XML representation of the list of user accounts", restParameters={@RestParameter(name="query", description="The search query, must be at lest 3 characters long.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", defaultValue="0", description="The page number.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The user accounts.")})
    public Response getUsersAsXml(@QueryParam(value="query") String queryString, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws IOException {
        if (limit < 1) {
            limit = 100;
        }
        String query = "%";
        if (StringUtils.isNotBlank((CharSequence)queryString)) {
            if (queryString.trim().length() < 3) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            query = queryString;
        }
        JaxbUserList userList = new JaxbUserList();
        Iterator i = this.userDirectoryService.findUsers(query, offset, limit);
        while (i.hasNext()) {
            userList.add((User)i.next());
        }
        return Response.ok((Object)userList).build();
    }

    @GET
    @Path(value="users.json")
    @Produces(value={"application/json"})
    @RestQuery(name="allusersasjson", description="Returns a list of users", returnDescription="Returns a JSON representation of the list of user accounts", restParameters={@RestParameter(name="query", description="The search query, must be at lest 3 characters long.", isRequired=false, type=RestParameter.Type.STRING), @RestParameter(name="limit", defaultValue="100", description="The maximum number of items to return per page.", isRequired=false, type=RestParameter.Type.INTEGER), @RestParameter(name="offset", defaultValue="0", description="The page number.", isRequired=false, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(responseCode=200, description="The user accounts.")})
    public Response getUsersAsJson(@QueryParam(value="query") String queryString, @QueryParam(value="limit") int limit, @QueryParam(value="offset") int offset) throws IOException {
        return this.getUsersAsXml(queryString, limit, offset);
    }

    @GET
    @Path(value="{username}.xml")
    @Produces(value={"application/xml"})
    @RestQuery(name="user", description="Returns a user", returnDescription="Returns a XML representation of a user", pathParameters={@RestParameter(description="The username.", isRequired=true, name="username", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user account."), @RestResponse(responseCode=404, description="User not found")})
    public JaxbUser getUserAsXml(@PathParam(value="username") String username) throws NotFoundException {
        User user = this.userDirectoryService.loadUser(username);
        if (user == null) {
            throw new NotFoundException();
        }
        return JaxbUser.fromUser((User)user);
    }

    @GET
    @Path(value="{username}.json")
    @Produces(value={"application/json"})
    @RestQuery(name="user", description="Returns a user", returnDescription="Returns a JSON representation of a user", pathParameters={@RestParameter(description="The username.", isRequired=true, name="username", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="The user account."), @RestResponse(responseCode=404, description="User not found")})
    public JaxbUser getUserAsJson(@PathParam(value="username") String username) throws NotFoundException {
        return this.getUserAsXml(username);
    }
}

