/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.GroupProvider;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleDirectoryService;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.util.data.Collections;
import org.opencastproject.util.data.Tuple;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

@Component(property={"service.description=Provides a user directory"}, immediate=true, service={UserDirectoryService.class, RoleDirectoryService.class, UserDetailsService.class})
public class UserAndRoleDirectoryServiceImpl
implements UserDirectoryService,
UserDetailsService,
RoleDirectoryService {
    private static final Logger logger = LoggerFactory.getLogger(UserAndRoleDirectoryServiceImpl.class);
    private static final String DEFAULT_PASSWORD = "4b3e4b30-718c-11e2-bcfd-0800200c9a66";
    public static final String USER_CACHE_SIZE_KEY = "org.opencastproject.userdirectory.cache.size";
    public static final String USER_CACHE_EXPIRY_KEY = "org.opencastproject.userdirectory.cache.expiry";
    protected List<UserProvider> userProviders = new CopyOnWriteArrayList<UserProvider>();
    protected List<RoleProvider> roleProviders = new CopyOnWriteArrayList<RoleProvider>();
    protected SecurityService securityService = null;
    private Object nullToken = new Object();
    private final CacheLoader<Tuple<String, String>, Object> userLoader = new CacheLoader<Tuple<String, String>, Object>(){

        public Object load(Tuple<String, String> orgUser) {
            User user = UserAndRoleDirectoryServiceImpl.this.loadUser(orgUser);
            return user == null ? UserAndRoleDirectoryServiceImpl.this.nullToken : user;
        }
    };
    private LoadingCache<Tuple<String, String>, Object> cache;
    private int cacheSize = 200;
    private int cacheExpiryTimeInMinutes = 1;

    protected void activate(ComponentContext cc) {
        if (cc != null) {
            String stringValue = cc.getBundleContext().getProperty(USER_CACHE_SIZE_KEY);
            if (StringUtils.isNotEmpty((CharSequence)stringValue)) {
                try {
                    this.cacheSize = Integer.parseInt(StringUtils.trimToNull((String)stringValue));
                }
                catch (Exception e) {
                    logger.warn("Ignoring invalid value {} for user cache size", (Object)stringValue);
                }
            } else {
                logger.info("Using default value {} for user cache size", (Object)this.cacheSize);
            }
            stringValue = cc.getBundleContext().getProperty(USER_CACHE_EXPIRY_KEY);
            if (StringUtils.isNotBlank((CharSequence)stringValue)) {
                try {
                    this.cacheExpiryTimeInMinutes = Integer.parseInt(StringUtils.trimToNull((String)stringValue));
                }
                catch (Exception e) {
                    logger.warn("Ignoring invalid value {} for user cache expiry time", (Object)stringValue);
                }
            } else {
                logger.info("Using default value {} for user cache expiry time", (Object)this.cacheExpiryTimeInMinutes);
            }
        }
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.cacheExpiryTimeInMinutes, TimeUnit.MINUTES).maximumSize((long)this.cacheSize).build(this.userLoader);
        logger.info("Activated UserAndRoleDirectoryService with user cache of size {}, expiry time {} minutes", (Object)this.cacheSize, (Object)this.cacheExpiryTimeInMinutes);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeUserProvider")
    protected synchronized void addUserProvider(UserProvider userProvider) {
        logger.debug("Adding {} to the list of user providers", (Object)userProvider);
        if ("system".equals(userProvider.getName())) {
            this.userProviders.add(0, userProvider);
        } else {
            this.userProviders.add(userProvider);
        }
    }

    protected synchronized void removeUserProvider(UserProvider userProvider) {
        logger.debug("Removing {} from the list of user providers", (Object)userProvider);
        this.userProviders.remove(userProvider);
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="removeRoleProvider")
    protected synchronized void addRoleProvider(RoleProvider roleProvider) {
        logger.debug("Adding {} to the list of role providers", (Object)roleProvider);
        this.roleProviders.add(roleProvider);
    }

    protected synchronized void removeRoleProvider(RoleProvider roleProvider) {
        logger.debug("Removing {} from the list of role providers", (Object)roleProvider);
        this.roleProviders.remove(roleProvider);
    }

    public List<User> getUsers() {
        Organization org = this.securityService.getOrganization();
        if (org == null) {
            throw new IllegalStateException("No organization is set");
        }
        ArrayList<User> users = new ArrayList<User>();
        for (UserProvider userProvider : this.userProviders) {
            String providerOrgId = userProvider.getOrganization();
            if (!"*".equals(providerOrgId)) {
                if (!org.getId().equals(providerOrgId)) continue;
            }
            userProvider.getUsers().forEachRemaining(users::add);
        }
        users.sort(Comparator.comparing(User::getUsername));
        return users;
    }

    public User loadUser(String userName) throws IllegalStateException {
        Organization org = this.securityService.getOrganization();
        if (org == null) {
            throw new IllegalStateException("No organization is set");
        }
        Object user = this.cache.getUnchecked((Object)Tuple.tuple((Object)org.getId(), (Object)userName));
        if (user == this.nullToken) {
            this.cache.invalidate((Object)Tuple.tuple((Object)org.getId(), (Object)userName));
            return null;
        }
        return (User)user;
    }

    public Iterator<User> loadUsers(Collection<String> userNames) {
        Organization org = this.securityService.getOrganization();
        HashMap<String, User> result = new HashMap<String, User>(userNames.size());
        HashSet<String> remainingNames = new HashSet<String>(userNames);
        for (UserProvider userProvider : this.userProviders) {
            String providerOrgId = userProvider.getOrganization();
            if (!"*".equals(providerOrgId) && !org.getId().equals(providerOrgId)) continue;
            Iterator it = userProvider.findUsers(remainingNames);
            while (it.hasNext()) {
                User user = (User)it.next();
                User priorUser = (User)result.get(user.getUsername());
                if (priorUser != null) {
                    result.put(user.getUsername(), this.mergeUsers(priorUser, user));
                } else {
                    result.put(user.getUsername(), user);
                }
                if (!"system".equals(userProvider.getName())) continue;
                remainingNames.remove(user.getUsername());
            }
        }
        return result.values().iterator();
    }

    private User loadUser(Tuple<String, String> orgUser) {
        Object user = null;
        for (UserProvider userProvider : this.userProviders) {
            User user2;
            String providerOrgId = userProvider.getOrganization();
            if (!"*".equals(providerOrgId) && !((String)orgUser.getA()).equals(providerOrgId) || (user2 = userProvider.loadUser((String)orgUser.getB())) == null) continue;
            JaxbUser tmpUser = JaxbUser.fromUser((User)user2);
            user = user == null ? tmpUser : this.mergeUsers((User)user, (User)tmpUser);
            if (!"system".equals(userProvider.getName())) continue;
            user = tmpUser;
            break;
        }
        if (user == null) {
            return null;
        }
        HashSet<Object> roles = new HashSet<Object>();
        for (Role role : user.getRoles()) {
            roles.add(JaxbRole.fromRole((Role)role));
        }
        if (!"system".equals(user.getProvider())) {
            for (RoleProvider roleProvider : this.roleProviders) {
                String string = roleProvider.getOrganization();
                if (!"*".equals(string) && !((String)orgUser.getA()).equals(string)) continue;
                for (Role role : roleProvider.getRolesForUser(user.getUsername())) {
                    roles.add(JaxbRole.fromRole((Role)role));
                }
            }
        }
        HashSet<JaxbRole> hashSet = new HashSet<JaxbRole>();
        for (Role role : roles) {
            if (!Role.Type.EXTERNAL_GROUP.equals((Object)role.getType())) continue;
            logger.debug("Resolving transitive roles for user {} from external group {}", (Object)user.getUsername(), (Object)role.getName());
            for (RoleProvider roleProvider : this.roleProviders) {
                if (!(roleProvider instanceof GroupProvider)) continue;
                List groupRoles = ((GroupProvider)roleProvider).getRolesForGroup(role.getName());
                if (groupRoles != null) {
                    for (Role groupRole : groupRoles) {
                        hashSet.add(JaxbRole.fromRole((Role)groupRole));
                    }
                    logger.debug("Adding {} derived role(s) for user {} from internal group {}", new Object[]{hashSet.size(), user.getUsername(), role.getName()});
                    continue;
                }
                logger.warn("Cannot resolve externallly provided group reference for user {} to internal group {}", (Object)user.getUsername(), (Object)role.getName());
            }
        }
        roles.addAll(hashSet);
        JaxbUser mergedUser = new JaxbUser(user.getUsername(), user.getPassword(), user.getName(), user.getEmail(), user.getProvider(), JaxbOrganization.fromOrganization((Organization)user.getOrganization()), roles);
        mergedUser.setManageable(user.isManageable());
        return mergedUser;
    }

    public UserDetails loadUserByUsername(String userName) throws UsernameNotFoundException {
        User user = this.loadUser(userName);
        if (user == null) {
            throw new UsernameNotFoundException(userName);
        }
        this.securityService.setUser(user);
        HashSet<SimpleGrantedAuthority> authorities = new HashSet<SimpleGrantedAuthority>();
        for (Role role : user.getRoles()) {
            authorities.add(new SimpleGrantedAuthority(role.getName()));
        }
        if (!"system".equals(user.getProvider())) {
            for (RoleProvider roleProvider : this.roleProviders) {
                String providerOrgId = roleProvider.getOrganization();
                if (!"*".equals(providerOrgId) && !user.getOrganization().getId().equals(providerOrgId)) continue;
                for (Role role : roleProvider.getRolesForUser(userName)) {
                    authorities.add(new SimpleGrantedAuthority(role.getName()));
                }
            }
        }
        authorities.add(new SimpleGrantedAuthority(this.securityService.getOrganization().getAnonymousRole()));
        String password = user.getPassword() == null ? DEFAULT_PASSWORD : user.getPassword();
        return new org.springframework.security.core.userdetails.User(user.getUsername(), password, true, true, true, true, authorities);
    }

    private User mergeUsers(User user1, User user2) {
        Set mergedRoles = Stream.of(user1, user2).flatMap(u -> u.getRoles().stream()).map(JaxbRole::fromRole).collect(Collectors.toSet());
        String name = (String)StringUtils.defaultIfBlank((CharSequence)user1.getName(), (CharSequence)user2.getName());
        String email = (String)StringUtils.defaultIfBlank((CharSequence)user1.getEmail(), (CharSequence)user2.getEmail());
        String password = StringUtils.defaultString((String)user1.getPassword(), (String)user2.getPassword());
        boolean manageable = user1.isManageable() || user2.isManageable();
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)user1.getOrganization());
        String provider = StringUtils.join((Iterable)Collections.nonNullList((Object[])new String[]{user1.getProvider(), user2.getProvider()}), (String)",");
        JaxbUser jaxbUser = new JaxbUser(user1.getUsername(), password, name, email, provider, organization, mergedRoles);
        jaxbUser.setManageable(manageable);
        return jaxbUser;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        Organization org = this.securityService.getOrganization();
        if (org == null) {
            throw new IllegalStateException("No organization is set");
        }
        ArrayList users = new ArrayList();
        for (UserProvider userProvider : this.userProviders) {
            String providerOrgId = userProvider.getOrganization();
            if (!"*".equals(providerOrgId)) {
                if (!org.getId().equals(providerOrgId)) continue;
            }
            userProvider.findUsers(query, 0, 0).forEachRemaining(users::add);
        }
        Stream<User> stream = users.stream().sorted(Comparator.comparing(User::getUsername)).skip(offset);
        if (limit > 0) {
            return stream.limit(limit).iterator();
        }
        return stream.iterator();
    }

    public List<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        Organization org = this.securityService.getOrganization();
        if (org == null) {
            throw new IllegalStateException("No organization is set");
        }
        ArrayList roles = new ArrayList();
        for (RoleProvider roleProvider : this.roleProviders) {
            String providerOrgId = roleProvider.getOrganization();
            if (!"*".equals(providerOrgId)) {
                if (!org.getId().equals(providerOrgId)) continue;
            }
            roleProvider.findRoles(query, target, 0, 0).forEachRemaining(roles::add);
        }
        Stream<Role> stream = roles.stream().sorted(Comparator.comparing(Role::getName)).skip(offset);
        if (limit > 0) {
            return stream.limit(limit).collect(Collectors.toList());
        }
        return stream.collect(Collectors.toList());
    }

    public long countUsers() {
        return this.userProviders.stream().mapToLong(UserProvider::countUsers).sum();
    }

    public void invalidate(String userName) {
        for (UserProvider userProvider : this.userProviders) {
            userProvider.invalidate(userName);
        }
        Organization org = this.securityService.getOrganization();
        if (org == null) {
            throw new IllegalStateException("No organization is set");
        }
        this.cache.invalidate((Object)Tuple.tuple((Object)org.getId(), (Object)userName));
        logger.trace("Invalidated user {} from user directories", (Object)userName);
    }
}

