/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.opencastproject.security.api.JaxbRoleList;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleDirectoryService;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/roles")
@RestService(name="roles", title="User Roles", notes={""}, abstractText="Displays the roles available in the current user's organization")
@Component(property={"service.description=Role listing REST endpoint", "opencast.service.type=org.opencastproject.userdirectory.roles", "opencast.service.path=/roles", "opencast.service.jobproducer=false"}, immediate=true, service={RoleEndpoint.class})
@JaxrsResource
public class RoleEndpoint {
    protected RoleDirectoryService roleDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    @GET
    @Path(value="roles.xml")
    @Produces(value={"application/xml"})
    @RestQuery(name="rolesasxml", description="Lists the roles as XML", returnDescription="The list of roles as XML", responses={@RestResponse(responseCode=200, description="OK, roles returned")})
    public JaxbRoleList getRolesAsXml() {
        JaxbRoleList roleList = new JaxbRoleList();
        for (Role role : this.roleDirectoryService.findRoles("%", Role.Target.ALL, 0, 0)) {
            roleList.add(role);
        }
        return roleList;
    }

    @GET
    @Path(value="roles.json")
    @Produces(value={"application/json"})
    @RestQuery(name="rolesasjson", description="Lists the roles as JSON", returnDescription="The list of roles as JSON", responses={@RestResponse(responseCode=200, description="OK, roles returned")})
    public JaxbRoleList getRolesAsJson() {
        return this.getRolesAsXml();
    }

    @Reference
    public void setRoleDirectoryService(RoleDirectoryService roleDirectoryService) {
        this.roleDirectoryService = roleDirectoryService;
    }
}

