/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.description=Provides the organizations role"}, immediate=true, service={RoleProvider.class})
public class OrganizationRoleProvider
implements RoleProvider {
    protected SecurityService securityService = null;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    private Iterator<Role> getRoles() {
        Organization organization = this.securityService.getOrganization();
        ArrayList<JaxbRole> roles = new ArrayList<JaxbRole>();
        if (!"ROLE_ADMIN".equals(organization.getAdminRole())) {
            roles.add(new JaxbRole(organization.getAdminRole(), JaxbOrganization.fromOrganization((Organization)organization), "", Role.Type.INTERNAL));
        }
        roles.add(new JaxbRole(organization.getAnonymousRole(), JaxbOrganization.fromOrganization((Organization)organization), "", Role.Type.SYSTEM));
        return roles.iterator();
    }

    public List<Role> getRolesForUser(String userName) {
        return Collections.emptyList();
    }

    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        Organization organization = this.securityService.getOrganization();
        HashSet<Role> foundRoles = new HashSet<Role>();
        Iterator<Role> it = this.getRoles();
        while (it.hasNext()) {
            Role role = it.next();
            if (target == Role.Target.USER && role.getName().equals(organization.getAnonymousRole()) || !this.like(role.getName(), query) && !this.like(role.getDescription(), query)) continue;
            foundRoles.add(role);
        }
        return this.offsetLimitCollection(offset, limit, foundRoles).iterator();
    }

    private <T> HashSet<T> offsetLimitCollection(int offset, int limit, HashSet<T> entries) {
        HashSet<T> result = new HashSet<T>();
        int i = 0;
        for (T entry : entries) {
            if (limit != 0 && result.size() >= limit) break;
            if (i >= offset) {
                result.add(entry);
            }
            ++i;
        }
        return result;
    }

    private boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }
}

