/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.security.api.Group;
import org.opencastproject.security.api.GroupProvider;
import org.opencastproject.security.api.JaxbGroupList;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.impl.jpa.JpaGroup;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.userdirectory.ConflictException;
import org.opencastproject.userdirectory.UserDirectoryPersistenceUtil;
import org.opencastproject.userdirectory.api.AAIRoleProvider;
import org.opencastproject.userdirectory.api.GroupRoleProvider;
import org.opencastproject.userdirectory.utils.UserDirectoryUtils;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides a group role directory"}, immediate=true, service={RoleProvider.class, JpaGroupRoleProvider.class})
public class JpaGroupRoleProvider
implements AAIRoleProvider,
GroupProvider,
GroupRoleProvider {
    private static final Logger logger = LoggerFactory.getLogger(JpaGroupRoleProvider.class);
    public static final String PERSISTENCE_UNIT = "org.opencastproject.common";
    protected SecurityService securityService = null;
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected OrganizationDirectoryService organizationDirectoryService;
    protected UserDirectoryService userDirectoryService = null;
    private ComponentContext cc;

    @Reference(target="(osgi.unit.name=org.opencastproject.common)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("Activate group role provider");
        this.cc = cc;
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Override
    public Iterator<Role> getRoles() {
        String orgId = this.securityService.getOrganization().getId();
        List roles = (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsQuery(orgId, 0, 0));
        return this.getGroupsRoles(roles).iterator();
    }

    @Override
    public List<Role> getRolesForUser(String userName) {
        String orgId = this.securityService.getOrganization().getId();
        List roles = (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsByUserQuery(userName, orgId));
        return this.getGroupsRoles(roles);
    }

    @Override
    public List<Role> getRolesForGroup(String groupName) {
        ArrayList<Role> roles = new ArrayList<Role>();
        String orgId = this.securityService.getOrganization().getId();
        Optional group = (Optional)this.db.exec(UserDirectoryPersistenceUtil.findGroupByRoleQuery(groupName, orgId));
        if (group.isPresent()) {
            for (Role role : ((JpaGroup)group.get()).getRoles()) {
                roles.add((Role)new JaxbRole(role.getName(), role.getOrganizationId(), role.getDescription(), Role.Type.DERIVED));
            }
        } else {
            logger.warn("Group {} not found", (Object)groupName);
        }
        return roles;
    }

    @Override
    public String getOrganization() {
        return "*";
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        String orgId = this.securityService.getOrganization().getId();
        List groups = (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsQuery(orgId, 0, 0));
        ArrayList<JaxbRole> roles = new ArrayList<JaxbRole>();
        for (JpaGroup group : groups) {
            if (!this.like(group.getRole(), query)) continue;
            roles.add(new JaxbRole(group.getRole(), JaxbOrganization.fromOrganization((Organization)group.getOrganization()), "", Role.Type.GROUP));
        }
        HashSet<Role> result = new HashSet<Role>();
        int i = 0;
        for (Role role : roles) {
            if (limit != 0 && result.size() >= limit) break;
            if (i >= offset) {
                result.add(role);
            }
            ++i;
        }
        return result.iterator();
    }

    @Override
    public void updateGroupMembershipFromRoles(String userName, String orgId, List<String> roleList) {
        this.updateGroupMembershipFromRoles(userName, orgId, roleList, "");
    }

    public void updateGroupMembershipFromRoles(String userName, String orgId, List<String> roleList, String prefix) {
        logger.debug("updateGroupMembershipFromRoles({}, size={})", (Object)userName, (Object)roleList.size());
        HashSet<String> membershipRoles = new HashSet<String>();
        List membership = (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsByUserQuery(userName, orgId));
        for (JpaGroup group : membership) {
            if (StringUtils.isNotBlank((CharSequence)prefix) && !group.getRole().startsWith(prefix) || !roleList.contains(group.getRole())) continue;
            membershipRoles.add(group.getRole());
        }
        for (String rolename : roleList) {
            if (membershipRoles.contains(rolename)) continue;
            Optional group = (Optional)this.db.exec(UserDirectoryPersistenceUtil.findGroupByRoleQuery(rolename, orgId));
            if (group.isPresent()) {
                try {
                    logger.debug("Adding user {} to group {}", (Object)userName, (Object)rolename);
                    ((JpaGroup)group.get()).getMembers().add(userName);
                    this.addGroup((JpaGroup)group.get());
                }
                catch (UnauthorizedException e) {
                    logger.warn("Unauthorized to add user {} to group {}", new Object[]{userName, ((JpaGroup)group.get()).getRole(), e});
                }
                continue;
            }
            logger.warn("Cannot add user {} to group {} - no group found with that role", (Object)userName, (Object)rolename);
        }
    }

    public void removeMemberFromAllGroups(String userName, String orgId) {
        List membership = (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsByUserQuery(userName, orgId));
        for (JpaGroup group : membership) {
            try {
                logger.debug("Removing user {} from group {}", (Object)userName, (Object)group.getRole());
                group.getMembers().remove(userName);
                this.addGroup(group);
            }
            catch (UnauthorizedException e) {
                logger.warn("Unauthorized to add or remove user {} from group {}", new Object[]{userName, group.getRole(), e});
            }
        }
    }

    public JpaGroup loadGroup(String groupId, String orgId) {
        return ((Optional)this.db.exec(UserDirectoryPersistenceUtil.findGroupQuery(groupId, orgId))).orElse(null);
    }

    public JpaGroup getGroup(String groupId) {
        String orgId = this.securityService.getOrganization().getId();
        return this.loadGroup(groupId, orgId);
    }

    @Override
    public void addGroup(JpaGroup group) throws UnauthorizedException {
        if (group != null && !UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, group.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to add or update a group with the admin role");
        }
        JpaGroup existingGroup = this.loadGroup(group.getGroupId(), group.getOrganization().getId());
        if (existingGroup != null && !UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, existingGroup.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to update a group with the admin role");
        }
        this.db.execTx(em -> {
            Set<JpaRole> roles = UserDirectoryPersistenceUtil.saveRolesQuery(group.getRoles()).apply((EntityManager)em);
            JpaOrganization organization = UserDirectoryPersistenceUtil.saveOrganizationQuery(group.getOrganization()).apply((EntityManager)em);
            JpaGroup jpaGroup = new JpaGroup(group.getGroupId(), organization, group.getName(), group.getDescription(), roles, group.getMembers());
            Optional<JpaGroup> foundGroup = UserDirectoryPersistenceUtil.findGroupQuery(jpaGroup.getGroupId(), jpaGroup.getOrganization().getId()).apply((EntityManager)em);
            if (foundGroup.isEmpty()) {
                em.persist((Object)jpaGroup);
            } else {
                foundGroup.get().setName(jpaGroup.getName());
                foundGroup.get().setDescription(jpaGroup.getDescription());
                foundGroup.get().setMembers(jpaGroup.getMembers());
                foundGroup.get().setRoles(roles);
                em.merge((Object)foundGroup.get());
            }
        });
    }

    private void removeGroup(String groupId, String orgId) throws NotFoundException, UnauthorizedException {
        JpaGroup group = this.loadGroup(groupId, orgId);
        if (group != null && !UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, group.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to delete a group with the admin role");
        }
        this.db.execTxChecked(UserDirectoryPersistenceUtil.removeGroupQuery(groupId, orgId));
    }

    private List<Role> getGroupsRoles(List<JpaGroup> groups) {
        ArrayList<Role> roles = new ArrayList<Role>();
        for (Group group : groups) {
            roles.add((Role)new JaxbRole(group.getRole(), JaxbOrganization.fromOrganization((Organization)group.getOrganization()), "", Role.Type.GROUP));
            for (Role role : group.getRoles()) {
                roles.add((Role)new JaxbRole(role.getName(), role.getOrganizationId(), role.getDescription(), Role.Type.DERIVED));
            }
        }
        return roles;
    }

    @Override
    public Iterator<Group> getGroups() {
        String orgId = this.securityService.getOrganization().getId();
        return new ArrayList((Collection)this.db.exec(UserDirectoryPersistenceUtil.findGroupsQuery(orgId, 0, 0))).iterator();
    }

    private boolean like(String str, String expr) {
        if (str == null) {
            return false;
        }
        String regex = expr.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(str).matches();
    }

    public JaxbGroupList getGroups(int limit, int offset) throws IOException {
        if (limit < 1) {
            limit = 100;
        }
        String orgId = this.securityService.getOrganization().getId();
        JaxbGroupList groupList = new JaxbGroupList();
        List groups = (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsQuery(orgId, limit, offset));
        for (JpaGroup group : groups) {
            groupList.add((Group)group);
        }
        return groupList;
    }

    public List<JpaGroup> getGroups(Optional<Integer> limit, Optional<Integer> offset, Optional<String> nameFilter, Optional<String> textFilter, ArrayList<SortCriterion> sortCriteria) {
        String orgId = this.securityService.getOrganization().getId();
        return (List)this.db.exec(UserDirectoryPersistenceUtil.findGroupsQuery(orgId, limit, offset, nameFilter, textFilter, sortCriteria));
    }

    public long countTotalGroups(Optional<String> nameFilter, Optional<String> textFilter) {
        String orgId = this.securityService.getOrganization().getId();
        return (Long)this.db.exec(UserDirectoryPersistenceUtil.countTotalGroupsQuery(orgId, nameFilter, textFilter));
    }

    public void removeGroup(String groupId) throws NotFoundException, UnauthorizedException, Exception {
        String orgId = this.securityService.getOrganization().getId();
        this.removeGroup(groupId, orgId);
    }

    public void createGroup(String name, String description, String roles, String users) throws IllegalArgumentException, UnauthorizedException, ConflictException {
        String groupId;
        Optional existingGroup;
        JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
        HashSet<JpaRole> roleSet = new HashSet<JpaRole>();
        if (roles != null) {
            for (String role : StringUtils.split((String)roles, (String)",")) {
                roleSet.add(new JpaRole(StringUtils.trim((String)role), organization));
            }
        }
        HashSet<String> members = new HashSet<String>();
        if (users != null) {
            for (String member : StringUtils.split((String)users, (String)",")) {
                members.add(StringUtils.trim((String)member));
            }
        }
        if ((existingGroup = (Optional)this.db.exec(UserDirectoryPersistenceUtil.findGroupQuery(groupId = name.toLowerCase().replaceAll("\\W", "_"), organization.getId()))).isPresent()) {
            throw new ConflictException("group already exists");
        }
        this.addGroup(new JpaGroup(groupId, organization, name, description, roleSet, members));
    }

    public boolean removeMemberFromGroup(String groupId, String member) throws NotFoundException, UnauthorizedException {
        JpaGroup group = this.getGroup(groupId);
        if (group == null) {
            throw new NotFoundException();
        }
        Set members = group.getMembers();
        if (!members.contains(member)) {
            return false;
        }
        group.removeMember(member);
        this.userDirectoryService.invalidate(member);
        this.addGroup(group);
        return true;
    }

    public boolean addMemberToGroup(String groupId, String member) throws NotFoundException, UnauthorizedException {
        JpaGroup group = this.getGroup(groupId);
        if (group == null) {
            throw new NotFoundException();
        }
        Set members = group.getMembers();
        if (members.contains(member)) {
            return false;
        }
        group.addMember(member);
        this.userDirectoryService.invalidate(member);
        this.addGroup(group);
        return true;
    }

    @Override
    public void updateGroup(String groupId, String name, String description, String roles, String users) throws NotFoundException, UnauthorizedException {
        JpaOrganization organization = (JpaOrganization)this.securityService.getOrganization();
        Optional groupOpt = (Optional)this.db.exec(UserDirectoryPersistenceUtil.findGroupQuery(groupId, organization.getId()));
        if (groupOpt.isEmpty()) {
            throw new NotFoundException();
        }
        JpaGroup group = (JpaGroup)groupOpt.get();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            group.setName(StringUtils.trim((String)name));
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            group.setDescription(StringUtils.trim((String)description));
        }
        if (StringUtils.isNotBlank((CharSequence)roles)) {
            HashSet<JpaRole> roleSet = new HashSet<JpaRole>();
            for (String role : StringUtils.split((String)roles, (String)",")) {
                roleSet.add(new JpaRole(StringUtils.trim((String)role), organization));
            }
            group.setRoles(roleSet);
        } else {
            group.setRoles(new HashSet());
        }
        if (users != null) {
            HashSet<String> members = new HashSet<String>();
            HashSet<String> invalidateUsers = new HashSet<String>();
            Set groupMembers = group.getMembers();
            for (String member : StringUtils.split((String)users, (String)",")) {
                String newMember = StringUtils.trim((String)member);
                members.add(newMember);
                if (groupMembers.contains(newMember)) continue;
                invalidateUsers.add(newMember);
            }
            for (String member : groupMembers) {
                if (members.contains(member)) continue;
                invalidateUsers.add(member);
            }
            group.setMembers(members);
            for (String member : invalidateUsers) {
                this.userDirectoryService.invalidate(member);
            }
        }
        this.addGroup(group);
    }
}

