/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityConstants;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=A user and role provider"}, immediate=true, service={UserProvider.class, RoleProvider.class, ManagedService.class})
public class InMemoryUserAndRoleProvider
implements UserProvider,
RoleProvider,
ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryUserAndRoleProvider.class);
    public static final String PROVIDER_NAME = "system";
    public static final String DIGEST_USER_NAME = "System User";
    public static final String CAPTURE_AGENT_USER_NAME = "Capture Agent";
    public static final String DIGEST_USER_KEY = "org.opencastproject.security.digest.user";
    public static final String CAPTURE_AGENT_USER_PREFIX = "capture_agent.user.";
    public static final String DIGEST_PASSWORD_KEY = "org.opencastproject.security.digest.pass";
    private static final String DIGEST_PASSWORD_DEFAULT_CONFIGURATION = "CHANGE_ME";
    public static final String CAPTURE_AGENT_ROLES_PREFIX = "capture_agent.roles.";
    private final Map<String, List<User>> inMemoryUsers = new ConcurrentHashMap<String, List<User>>();
    private Map<String, List<List<String>>> captureAgentUsers = new ConcurrentHashMap<String, List<List<String>>>();
    protected SecurityService securityService;
    private String digestUsername;
    private String digestUserPass;

    protected void activate(ComponentContext cc) {
        this.digestUsername = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(DIGEST_USER_KEY));
        if (this.digestUsername == null) {
            logger.warn("Digest username has not been configured ({})", (Object)DIGEST_USER_KEY);
        }
        this.digestUserPass = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(DIGEST_PASSWORD_KEY));
        if (this.digestUserPass == null) {
            logger.warn("Digest password has not been configured ({})", (Object)DIGEST_PASSWORD_KEY);
        } else if (DIGEST_PASSWORD_DEFAULT_CONFIGURATION.equals(this.digestUserPass)) {
            logger.warn("\n######################################################\n#                                                    #\n# WARNING: Opencast still uses the default system    #\n#          credentials. Never do this in production. #\n#                                                    #\n#          To change the password, edit the key      #\n#          org.opencastproject.security.digest.pass  #\n#          in custom.properties.                     #\n#                                                    #\n######################################################");
        }
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            this.captureAgentUsers.clear();
            this.inMemoryUsers.clear();
            return;
        }
        ConcurrentHashMap<String, List<List<String>>> newCAUsers = new ConcurrentHashMap<String, List<List<String>>>();
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith(CAPTURE_AGENT_USER_PREFIX)) continue;
            String[] orgUser = key.substring(CAPTURE_AGENT_USER_PREFIX.length()).split("\\.");
            if (orgUser.length != 2) {
                logger.warn("Ignoring invalid capture agent user definition. Should be {}.<organization>.<username>, was {}", (Object)CAPTURE_AGENT_USER_PREFIX, (Object)key);
            }
            String orgId = orgUser[0];
            String username = orgUser[1];
            String password = Objects.toString(properties.get(key), null);
            if (password == null) continue;
            String rolesStr = Objects.toString(properties.get(CAPTURE_AGENT_ROLES_PREFIX + orgId + "." + username), "");
            String[] roles = StringUtils.split((String)rolesStr, (String)", ");
            ArrayList<String> userData = new ArrayList<String>();
            userData.add(username);
            userData.add(password);
            userData.addAll(Arrays.asList(roles));
            if (!newCAUsers.containsKey(orgId)) {
                newCAUsers.put(orgId, new ArrayList());
            }
            ((List)newCAUsers.get(orgId)).add(userData);
        }
        this.captureAgentUsers = newCAUsers;
        this.inMemoryUsers.clear();
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    private List<User> getOrganizationUsers() {
        Organization organization = this.securityService.getOrganization();
        List<User> users = this.inMemoryUsers.get(organization.getId());
        if (users == null) {
            return this.createSystemUsers(organization);
        }
        return users;
    }

    private synchronized List<User> createSystemUsers(Organization organization) {
        List<User> users = this.inMemoryUsers.get(organization.getId());
        if (users != null) {
            logger.trace("Organization users have already been initialized. Aborting.");
            return users;
        }
        users = new ArrayList<User>();
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)organization);
        if (this.digestUsername != null && this.digestUserPass != null) {
            HashSet<JaxbRole> roleList = new HashSet<JaxbRole>();
            for (String roleName : SecurityConstants.GLOBAL_SYSTEM_ROLES) {
                roleList.add(new JaxbRole(roleName, jaxbOrganization));
            }
            JaxbUser digestUser = new JaxbUser(this.digestUsername, this.digestUserPass, DIGEST_USER_NAME, null, this.getName(), jaxbOrganization, roleList);
            users.add((User)digestUser);
            logger.info("Added system digest user '{}' for organization '{}'", (Object)this.digestUsername, (Object)organization.getId());
        }
        for (List userData : (List)this.captureAgentUsers.getOrDefault(organization.getId(), new ArrayList())) {
            String username = (String)userData.get(0);
            String password = (String)userData.get(1);
            HashSet<JaxbRole> caRoleList = new HashSet<JaxbRole>();
            caRoleList.add(new JaxbRole(organization.getAnonymousRole(), jaxbOrganization));
            Arrays.stream(SecurityConstants.GLOBAL_CAPTURE_AGENT_ROLES).forEach(role -> caRoleList.add(new JaxbRole(role, jaxbOrganization)));
            userData.stream().skip(2L).forEach(role -> caRoleList.add(new JaxbRole(role, jaxbOrganization)));
            logger.info("Creating the capture agent digest user '{}'", (Object)username);
            JaxbUser caUser = new JaxbUser(username, password, CAPTURE_AGENT_USER_NAME, null, this.getName(), jaxbOrganization, caRoleList);
            users.add((User)caUser);
        }
        this.inMemoryUsers.put(organization.getId(), users);
        return users;
    }

    public Iterator<User> getUsers() {
        return this.getOrganizationUsers().iterator();
    }

    public User loadUser(String userName) {
        return this.getOrganizationUsers().stream().filter(user -> user.getUsername().equals(userName)).findFirst().orElse(null);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public String getOrganization() {
        return "*";
    }

    public List<Role> getRolesForUser(String userName) {
        return this.getOrganizationUsers().stream().filter(user -> user.getUsername().equals(userName)).flatMap(user -> user.getRoles().stream()).collect(Collectors.toList());
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        return this.getOrganizationUsers().stream().filter(user -> this.like(user.getUsername(), query)).sorted(Comparator.comparing(User::getUsername)).skip(offset).limit(limit <= 0 ? Long.MAX_VALUE : (long)limit).iterator();
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        return this.getOrganizationUsers().stream().flatMap(user -> user.getRoles().stream()).filter(role -> !(!this.like(role.getName(), query) && !this.like(role.getDescription(), query) || target == Role.Target.ACL && "ROLE_SUDO".equals(role.getName()))).sorted(Comparator.comparing(Role::getName)).skip(offset).limit(limit <= 0 ? Long.MAX_VALUE : (long)limit).iterator();
    }

    private boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern pattern = Pattern.compile(regex, 34);
        return pattern.matcher(string).matches();
    }

    public long countUsers() {
        return this.getOrganizationUsers().size();
    }

    public void invalidate(String userName) {
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

