/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides custom roles"}, immediate=true, service={RoleProvider.class})
public class CustomRoleProvider
implements RoleProvider {
    private static final Logger logger = LoggerFactory.getLogger(CustomRoleProvider.class);
    public static final String CUSTOM_ROLES_KEY = "org.opencastproject.security.custom.roles";
    public static final String CUSTOM_ROLES_PATTERN_KEY = "org.opencastproject.security.custom.roles.pattern";
    protected SecurityService securityService = null;
    private Set<String> roles = null;
    private Pattern rolematch = null;

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    protected void activate(ComponentContext cc) {
        String rolePattern;
        this.roles = new TreeSet<String>();
        String customRoleList = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(CUSTOM_ROLES_KEY));
        if (customRoleList != null) {
            List<String> items = Arrays.asList(customRoleList.split("\\s*,\\s*"));
            for (String item : items) {
                logger.debug("Adding custom role '{}'", (Object)item);
                this.roles.add(item);
            }
        }
        if ((rolePattern = StringUtils.trimToNull((String)cc.getBundleContext().getProperty(CUSTOM_ROLES_PATTERN_KEY))) != null) {
            try {
                this.rolematch = Pattern.compile(rolePattern);
            }
            catch (PatternSyntaxException e) {
                logger.warn("Invalid regular expression for custom roles pattern: {}", (Object)rolePattern);
            }
        }
        if (this.rolematch != null) {
            logger.info("CustomRoleProvider activated, {} custom role(s), custom role pattern {}", (Object)this.roles.size(), (Object)rolePattern);
        } else {
            logger.info("CustomRoleProvider activated, {} custom role(s)", (Object)this.roles.size());
        }
    }

    public String getOrganization() {
        return "*";
    }

    public List<Role> getRolesForUser(String userName) {
        return Collections.emptyList();
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        String exactQuery;
        Matcher m;
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        JaxbOrganization organization = JaxbOrganization.fromOrganization((Organization)this.securityService.getOrganization());
        if (target == Role.Target.ACL && this.rolematch != null && (m = this.rolematch.matcher(exactQuery = StringUtils.removeEnd((String)query, (String)"%"))).matches()) {
            return Collections.singletonList(new JaxbRole(exactQuery, organization, "Custom Role", Role.Type.EXTERNAL)).iterator();
        }
        return this.roles.stream().filter(role -> CustomRoleProvider.like(role, query)).skip(offset).limit(limit > 0 ? (long)limit : Long.MAX_VALUE).map(role -> new JaxbRole(role, organization, "Custom Role", Role.Type.INTERNAL)).iterator();
    }

    private static boolean like(String string, String query) {
        if (string == null) {
            return false;
        }
        String regex = query.replace("_", ".").replace("%", ".*?");
        Pattern p = Pattern.compile(regex, 34);
        return p.matcher(string).matches();
    }
}

