/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.impl.jpa.JpaGroup;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUser;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.function.ThrowingConsumer;
import org.opencastproject.util.requests.SortCriterion;

public final class UserDirectoryPersistenceUtil {
    private UserDirectoryPersistenceUtil() {
    }

    public static Function<EntityManager, Set<JpaRole>> saveRolesQuery(Set<? extends Role> roles) {
        return em -> {
            HashSet<JpaRole> updatedRoles = new HashSet<JpaRole>();
            for (Role role : roles) {
                JpaRole jpaRole = (JpaRole)role;
                UserDirectoryPersistenceUtil.saveOrganizationQuery(jpaRole.getJpaOrganization()).apply((EntityManager)em);
                Optional<JpaRole> findRole = UserDirectoryPersistenceUtil.findRoleQuery(jpaRole.getName(), jpaRole.getOrganizationId()).apply((EntityManager)em);
                if (findRole.isEmpty()) {
                    em.persist((Object)jpaRole);
                    updatedRoles.add(jpaRole);
                    continue;
                }
                findRole.get().setDescription(jpaRole.getDescription());
                updatedRoles.add((JpaRole)em.merge((Object)findRole.get()));
            }
            return updatedRoles;
        };
    }

    public static Function<EntityManager, JpaOrganization> saveOrganizationQuery(JpaOrganization organization) {
        return em -> {
            Optional<JpaOrganization> dbOrganization = UserDirectoryPersistenceUtil.findOrganizationQuery(organization).apply((EntityManager)em);
            if (dbOrganization.isEmpty()) {
                em.persist((Object)organization);
                return organization;
            }
            return (JpaOrganization)em.merge((Object)dbOrganization.get());
        };
    }

    public static Function<EntityManager, JpaUser> saveUserQuery(JpaUser user) {
        return em -> {
            Optional<JpaUser> dbUser = UserDirectoryPersistenceUtil.findUserQuery(user.getUsername(), user.getOrganization().getId()).apply((EntityManager)em);
            if (dbUser.isEmpty()) {
                em.persist((Object)user);
                return user;
            }
            user.setId(dbUser.get().getId());
            return (JpaUser)em.merge((Object)user);
        };
    }

    public static Function<EntityManager, List<JpaGroup>> findGroupsQuery(String organization, int limit, int offset) {
        return em -> {
            TypedQuery query = em.createNamedQuery("Group.findAll", JpaGroup.class).setMaxResults(limit).setFirstResult(offset);
            query.setParameter("organization", (Object)organization);
            return query.getResultList();
        };
    }

    public static Function<EntityManager, Long> countTotalGroupsQuery(String orgId, Optional<String> nameFilter, Optional<String> textFilter) {
        return em -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(Long.class);
            Root group = query.from(JpaGroup.class);
            query.select((Selection)cb.count((Expression)group));
            UserDirectoryPersistenceUtil.addWhereToQuery(query, cb, (Root<JpaGroup>)group, orgId, nameFilter, textFilter);
            TypedQuery typedQuery = em.createQuery(query);
            return (Long)typedQuery.getSingleResult();
        };
    }

    private static <E> void addWhereToQuery(CriteriaQuery<E> query, CriteriaBuilder cb, Root<JpaGroup> group, String orgId, Optional<String> nameFilter, Optional<String> textFilter) {
        ArrayList<Predicate> conditions = new ArrayList<Predicate>();
        conditions.add(cb.equal((Expression)group.join("organization").get("id"), (Object)orgId));
        if (nameFilter.isPresent()) {
            conditions.add(cb.equal((Expression)group.get("name"), (Object)nameFilter.get()));
        }
        if (textFilter.isPresent()) {
            String[] tokens;
            ArrayList<Predicate> fulltextConditions = new ArrayList<Predicate>();
            for (String token : tokens = textFilter.get().split("\\s+")) {
                ArrayList<Predicate> fieldConditions = new ArrayList<Predicate>();
                Expression literal = cb.literal((Object)("%" + token + "%"));
                fieldConditions.add(cb.like(cb.lower((Expression)group.get("groupId")), cb.lower(literal)));
                fieldConditions.add(cb.like(cb.lower((Expression)group.get("name")), cb.lower(literal)));
                fieldConditions.add(cb.like(cb.lower((Expression)group.get("description")), cb.lower(literal)));
                fieldConditions.add(cb.like(cb.lower((Expression)group.get("role")), cb.lower(literal)));
                fieldConditions.add(cb.like(cb.lower((Expression)group.joinSet("members", JoinType.LEFT)), cb.lower(literal)));
                fieldConditions.add(cb.like(cb.lower((Expression)group.joinSet("roles", JoinType.LEFT).get("name")), cb.lower(literal)));
                fulltextConditions.add(cb.or(fieldConditions.toArray(new Predicate[0])));
            }
            conditions.add(cb.and(fulltextConditions.toArray(new Predicate[0])));
        }
        query.where((Expression)cb.and(conditions.toArray(new Predicate[0])));
    }

    public static Function<EntityManager, List<JpaGroup>> findGroupsQuery(String orgId, Optional<Integer> limit, Optional<Integer> offset, Optional<String> nameFilter, Optional<String> textFilter, Set<SortCriterion> sortCriteria) {
        return em -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery query = cb.createQuery(JpaGroup.class);
            Root group = query.from(JpaGroup.class);
            query.select((Selection)group);
            query.distinct(true);
            UserDirectoryPersistenceUtil.addWhereToQuery(query, cb, (Root<JpaGroup>)group, orgId, nameFilter, textFilter);
            ArrayList<Order> orders = new ArrayList<Order>();
            block8: for (SortCriterion criterion : sortCriteria) {
                switch (criterion.getFieldName()) {
                    case "name": 
                    case "description": 
                    case "role": {
                        Path expression = group.get(criterion.getFieldName());
                        if (criterion.getOrder() == SortCriterion.Order.Ascending) {
                            orders.add(cb.asc((Expression)expression));
                            continue block8;
                        }
                        if (criterion.getOrder() != SortCriterion.Order.Descending) continue block8;
                        orders.add(cb.desc((Expression)expression));
                        continue block8;
                    }
                }
                throw new IllegalArgumentException("Sorting criterion " + criterion.getFieldName() + " is not supported for groups.");
            }
            query.orderBy(orders);
            TypedQuery typedQuery = em.createQuery(query);
            if (limit.isPresent()) {
                typedQuery.setMaxResults(((Integer)limit.get()).intValue());
            }
            if (offset.isPresent()) {
                typedQuery.setFirstResult(((Integer)offset.get()).intValue());
            }
            return typedQuery.getResultList();
        };
    }

    public static Function<EntityManager, List<JpaRole>> findRolesQuery(String organization, int limit, int offset) {
        return em -> {
            TypedQuery q = em.createNamedQuery("Role.findAll", JpaRole.class).setMaxResults(limit).setFirstResult(offset);
            q.setParameter("org", (Object)organization);
            return q.getResultList();
        };
    }

    public static Function<EntityManager, List<JpaRole>> findRolesByQuery(String orgId, String query, int limit, int offset) {
        return em -> {
            TypedQuery q = em.createNamedQuery("Role.findByQuery", JpaRole.class).setMaxResults(limit).setFirstResult(offset);
            q.setParameter("query", (Object)query.toUpperCase());
            q.setParameter("org", (Object)orgId);
            return q.getResultList();
        };
    }

    public static Function<EntityManager, List<JpaGroup>> findGroupsByUserQuery(String userName, String orgId) {
        return Queries.namedQuery.findAll("Group.findByUser", JpaGroup.class, new Object[]{Pair.of((Object)"username", (Object)userName), Pair.of((Object)"organization", (Object)orgId)});
    }

    public static Function<EntityManager, Optional<JpaOrganization>> findOrganizationQuery(JpaOrganization organization) {
        return Queries.namedQuery.findOpt("Organization.findById", JpaOrganization.class, new Object[]{Pair.of((Object)"id", (Object)organization.getId())});
    }

    public static Function<EntityManager, List<JpaUser>> findUsersByUserNameQuery(Collection<String> userNames, String organizationId) {
        return em -> {
            if (userNames.isEmpty()) {
                return Collections.emptyList();
            }
            TypedQuery q = em.createNamedQuery("User.findAllByUserNames", JpaUser.class);
            q.setParameter("names", (Object)userNames);
            q.setParameter("org", (Object)organizationId);
            return q.getResultList();
        };
    }

    public static Function<EntityManager, Optional<JpaUser>> findUserQuery(String userName, String organizationId) {
        return Queries.namedQuery.findOpt("User.findByUsername", JpaUser.class, new Object[]{Pair.of((Object)"u", (Object)userName), Pair.of((Object)"org", (Object)organizationId)});
    }

    public static Function<EntityManager, Optional<JpaUser>> findUserQuery(long id, String organizationId) {
        return Queries.namedQuery.findOpt("User.findByIdAndOrg", JpaUser.class, new Object[]{Pair.of((Object)"id", (Object)id), Pair.of((Object)"org", (Object)organizationId)});
    }

    public static Function<EntityManager, Long> countUsersQuery(String organizationId) {
        return Queries.namedQuery.find("User.countAllByOrg", Long.class, new Object[]{Pair.of((Object)"org", (Object)organizationId)});
    }

    public static Function<EntityManager, Long> countUsersQuery() {
        return Queries.namedQuery.find("User.countAll", Long.class, new Object[0]);
    }

    public static Function<EntityManager, List<JpaUser>> findUsersByQuery(String orgId, String query, int limit, int offset) {
        return em -> {
            TypedQuery q = em.createNamedQuery("User.findByQuery", JpaUser.class).setMaxResults(limit).setFirstResult(offset);
            q.setParameter("query", (Object)query.toUpperCase());
            q.setParameter("org", (Object)orgId);
            return q.getResultList();
        };
    }

    public static Function<EntityManager, List<JpaUser>> findUsersQuery(String orgId, int limit, int offset) {
        return em -> {
            TypedQuery q = em.createNamedQuery("User.findAll", JpaUser.class).setMaxResults(limit).setFirstResult(offset);
            q.setParameter("org", (Object)orgId);
            return q.getResultList();
        };
    }

    public static Function<EntityManager, Optional<JpaRole>> findRoleQuery(String name, String organization) {
        return Queries.namedQuery.findOpt("Role.findByName", JpaRole.class, new Object[]{Pair.of((Object)"name", (Object)name), Pair.of((Object)"org", (Object)organization)});
    }

    public static Function<EntityManager, Optional<JpaGroup>> findGroupQuery(String groupId, String orgId) {
        return Queries.namedQuery.findOpt("Group.findById", JpaGroup.class, new Object[]{Pair.of((Object)"groupId", (Object)groupId), Pair.of((Object)"organization", (Object)orgId)});
    }

    public static Function<EntityManager, Optional<JpaGroup>> findGroupByRoleQuery(String role, String orgId) {
        return Queries.namedQuery.findOpt("Group.findByRole", JpaGroup.class, new Object[]{Pair.of((Object)"role", (Object)role), Pair.of((Object)"organization", (Object)orgId)});
    }

    public static ThrowingConsumer<EntityManager, NotFoundException> removeGroupQuery(String groupId, String orgId) {
        return em -> {
            Optional<JpaGroup> group = UserDirectoryPersistenceUtil.findGroupQuery(groupId, orgId).apply((EntityManager)em);
            if (group.isEmpty()) {
                throw new NotFoundException("Group with ID " + groupId + " does not exist");
            }
            em.remove(em.merge((Object)group.get()));
        };
    }

    public static ThrowingConsumer<EntityManager, NotFoundException> deleteUserQuery(String username, String orgId) {
        return em -> {
            Optional<JpaUser> user = UserDirectoryPersistenceUtil.findUserQuery(username, orgId).apply((EntityManager)em);
            if (user.isEmpty()) {
                throw new NotFoundException("User with name " + username + " does not exist");
            }
            em.remove(em.merge((Object)user.get()));
        };
    }
}

