/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUserReference;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.userdirectory.UserDirectoryPersistenceUtil;
import org.opencastproject.userdirectory.api.AAIRoleProvider;
import org.opencastproject.userdirectory.api.UserReferenceProvider;
import org.opencastproject.userdirectory.utils.UserDirectoryUtils;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.function.ThrowingConsumer;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides a user reference directory"}, immediate=true, service={UserProvider.class, RoleProvider.class, UserReferenceProvider.class, JpaUserReferenceProvider.class})
public class JpaUserReferenceProvider
implements UserReferenceProvider,
UserProvider,
RoleProvider {
    private static final Logger logger = LoggerFactory.getLogger(JpaUserReferenceProvider.class);
    public static final String PROVIDER_NAME = "matterhorn-reference";
    public static final String USERNAME = "username";
    public static final String ROLES = "roles";
    public static final String ENCODING = "UTF-8";
    protected SecurityService securityService = null;
    protected JpaGroupRoleProvider groupRoleProvider;
    protected AAIRoleProvider roleProvider;
    private static final String DELIMITER = ";==;";
    private LoadingCache<String, Object> cache = null;
    protected final Object nullToken = new Object();
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;

    @Reference(target="(osgi.unit.name=org.opencastproject.common)")
    void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setGroupRoleProvider(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("activate");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String id) {
                String[] key = id.split(JpaUserReferenceProvider.DELIMITER);
                logger.trace("Loading user '{}':'{}' from reference database", (Object)key[0], (Object)key[1]);
                User user = JpaUserReferenceProvider.this.loadUserFromDB(key[0], key[1]);
                return user == null ? JpaUserReferenceProvider.this.nullToken : user;
            }
        });
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public List<Role> getRolesForUser(String userName) {
        if (this.roleProvider != null) {
            return this.roleProvider.getRolesForUser(userName);
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        User user = this.loadUser(userName);
        if (user != null) {
            roles.addAll(user.getRoles());
        }
        return roles;
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        String orgId = this.securityService.getOrganization().getId();
        return ((List)this.db.exec(this.findUserReferencesByQueryQuery(orgId, query, limit, offset))).stream().map(ref -> ref.toUser(PROVIDER_NAME)).collect(Collectors.toList()).iterator();
    }

    public Iterator<User> findUsers(Collection<String> userNames) {
        String orgId = this.securityService.getOrganization().getId();
        return ((List)this.db.exec(this.findUsersByUserNameQuery(orgId, userNames))).stream().map(ref -> ref.toUser(PROVIDER_NAME)).collect(Collectors.toList()).iterator();
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (this.roleProvider == null) {
            return Collections.emptyIterator();
        }
        return this.roleProvider.findRoles(query, target, offset, limit);
    }

    @Override
    public User loadUser(String userName) {
        String orgId = this.securityService.getOrganization().getId();
        return this.loadUserFromCache(userName, orgId);
    }

    private User loadUserFromDB(String userName, String organization) {
        return ((Optional)this.db.exec(this.findUserReferenceQuery(userName, organization))).map(ref -> ref.toUser(PROVIDER_NAME)).orElse(null);
    }

    private User loadUserFromCache(String userName, String organization) {
        Object user = this.cache.getUnchecked((Object)userName.concat(DELIMITER).concat(organization));
        if (user == this.nullToken) {
            return null;
        }
        return (User)user;
    }

    public Iterator<User> getUsers() {
        String orgId = this.securityService.getOrganization().getId();
        return ((List)this.db.exec(this.findUserReferences(orgId, 0, 0))).stream().map(ref -> ref.toUser(PROVIDER_NAME)).collect(Collectors.toList()).iterator();
    }

    public Iterator<Role> getRoles() {
        if (this.roleProvider == null) {
            return Collections.emptyIterator();
        }
        return this.roleProvider.getRoles();
    }

    public String getOrganization() {
        return "*";
    }

    @Override
    public void addUserReference(JpaUserReference user, String mechanism) {
        this.db.execTx(em -> {
            Set<JpaRole> roles = UserDirectoryPersistenceUtil.saveRolesQuery(user.getRoles()).apply((EntityManager)em);
            JpaOrganization organization = UserDirectoryPersistenceUtil.saveOrganizationQuery((JpaOrganization)user.getOrganization()).apply((EntityManager)em);
            JpaUserReference userReference = new JpaUserReference(user.getUsername(), user.getName(), user.getEmail(), mechanism, user.getLastLogin(), organization, roles);
            Optional<JpaUserReference> foundUserRef = this.findUserReferenceQuery(user.getUsername(), user.getOrganization().getId()).apply((EntityManager)em);
            if (foundUserRef.isPresent()) {
                throw new IllegalStateException("User '" + user.getUsername() + "' already exists");
            }
            em.persist((Object)userReference);
        });
        this.cache.put((Object)(user.getUsername() + DELIMITER + user.getOrganization().getId()), (Object)user.toUser(PROVIDER_NAME));
        this.updateGroupMembership(user);
    }

    @Override
    public void updateUserReference(JpaUserReference user) {
        this.db.execTx(em -> {
            Optional<JpaUserReference> foundUserRef = this.findUserReferenceQuery(user.getUsername(), user.getOrganization().getId()).apply((EntityManager)em);
            if (foundUserRef.isEmpty()) {
                throw new IllegalStateException("User '" + user.getUsername() + "' does not exist");
            }
            foundUserRef.get().setName(user.getName());
            foundUserRef.get().setEmail(user.getEmail());
            foundUserRef.get().setLastLogin(user.getLastLogin());
            foundUserRef.get().setRoles(UserDirectoryPersistenceUtil.saveRolesQuery(user.getRoles()).apply((EntityManager)em));
            em.merge((Object)foundUserRef.get());
        });
        this.cache.put((Object)(user.getUsername() + DELIMITER + user.getOrganization().getId()), (Object)user.toUser(PROVIDER_NAME));
        this.updateGroupMembership(user);
    }

    private void updateGroupMembership(JpaUserReference user) {
        logger.debug("updateGroupMembership({}, roles={})", (Object)user.getUsername(), (Object)user.getRoles().size());
        ArrayList<String> internalGroupRoles = new ArrayList<String>();
        for (Role role : user.getRoles()) {
            if (!Role.Type.GROUP.equals((Object)role.getType()) && (!Role.Type.INTERNAL.equals((Object)role.getType()) || !role.getName().startsWith("ROLE_GROUP_"))) continue;
            internalGroupRoles.add(role.getName());
        }
        this.groupRoleProvider.updateGroupMembershipFromRoles(user.getUsername(), user.getOrganization().getId(), internalGroupRoles);
    }

    @Override
    public JpaUserReference findUserReference(String userName, String organizationId) {
        return ((Optional)this.db.exec(this.findUserReferenceQuery(userName, organizationId))).orElse(null);
    }

    private Function<EntityManager, Optional<JpaUserReference>> findUserReferenceQuery(String userName, String organizationId) {
        return Queries.namedQuery.findOpt("UserReference.findByUsername", JpaUserReference.class, new Object[]{Pair.of((Object)"u", (Object)userName), Pair.of((Object)"org", (Object)organizationId)});
    }

    private Function<EntityManager, List<JpaUserReference>> findUserReferencesByQueryQuery(String orgId, String query, int limit, int offset) {
        return em -> {
            TypedQuery q = em.createNamedQuery("UserReference.findByQuery", JpaUserReference.class).setMaxResults(limit).setFirstResult(offset);
            q.setParameter("query", (Object)query.toUpperCase());
            q.setParameter("org", (Object)orgId);
            return q.getResultList();
        };
    }

    private Function<EntityManager, List<JpaUserReference>> findUsersByUserNameQuery(String orgId, Collection<String> names) {
        return em -> {
            if (names.isEmpty()) {
                return Collections.emptyList();
            }
            TypedQuery q = em.createNamedQuery("UserReference.findAllByUserNames", JpaUserReference.class);
            q.setParameter("org", (Object)orgId);
            q.setParameter("names", (Object)names);
            return q.getResultList();
        };
    }

    private Function<EntityManager, List<JpaUserReference>> findUserReferences(String orgId, int limit, int offset) {
        return em -> {
            TypedQuery q = em.createNamedQuery("UserReference.findAll", JpaUserReference.class).setMaxResults(limit).setFirstResult(offset);
            q.setParameter("org", (Object)orgId);
            return q.getResultList();
        };
    }

    public long countUsers() {
        String orgId = this.securityService.getOrganization().getId();
        return ((Number)this.db.exec(Queries.namedQuery.find("UserReference.countAll", Number.class, new Object[]{Pair.of((Object)"org", (Object)orgId)}))).longValue();
    }

    public void invalidate(String userName) {
        String orgId = this.securityService.getOrganization().getId();
        this.cache.invalidate((Object)userName.concat(DELIMITER).concat(orgId));
    }

    public void deleteUser(String username, String orgId) throws NotFoundException, UnauthorizedException, Exception {
        User user = this.loadUser(username);
        if (user != null && !UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, user.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to delete an admin user");
        }
        this.groupRoleProvider.removeMemberFromAllGroups(username, orgId);
        this.db.execTxChecked(this.deleteUserQuery(username, orgId));
        this.cache.invalidate((Object)(username + DELIMITER + orgId));
    }

    private ThrowingConsumer<EntityManager, NotFoundException> deleteUserQuery(String username, String orgId) {
        return em -> {
            Optional<JpaUserReference> user = this.findUserReferenceQuery(username, orgId).apply((EntityManager)em);
            if (user.isEmpty()) {
                throw new NotFoundException("User with name " + username + " does not exist");
            }
            em.remove(em.merge((Object)user.get()));
        };
    }

    @Override
    public void setRoleProvider(RoleProvider roleProvider) {
        this.roleProvider = (AAIRoleProvider)roleProvider;
    }
}

