/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.kernel.security.CustomPasswordEncoder;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUser;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.userdirectory.UserDirectoryPersistenceUtil;
import org.opencastproject.userdirectory.utils.UserDirectoryUtils;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Provides a user directory"}, immediate=true, service={UserProvider.class, RoleProvider.class, JpaUserAndRoleProvider.class})
public class JpaUserAndRoleProvider
implements UserProvider,
RoleProvider {
    private static final Logger logger = LoggerFactory.getLogger(JpaUserAndRoleProvider.class);
    public static final String PERSISTENCE_UNIT = "org.opencastproject.common";
    public static final String PROVIDER_NAME = "opencast";
    public static final String USERNAME = "username";
    public static final String ROLES = "roles";
    public static final String ENCODING = "UTF-8";
    private static final String DELIMITER = ";==;";
    protected SecurityService securityService = null;
    protected JpaGroupRoleProvider groupRoleProvider;
    private LoadingCache<String, Object> cache = null;
    protected Object nullToken = new Object();
    private CustomPasswordEncoder passwordEncoder = new CustomPasswordEncoder();
    protected EntityManagerFactory emf = null;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;

    @Reference(target="(osgi.unit.name=org.opencastproject.common)")
    void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    void setGroupRoleProvider(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("activate");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String id) {
                String[] key = id.split(JpaUserAndRoleProvider.DELIMITER);
                logger.trace("Loading user '{}':'{}' from database", (Object)key[0], (Object)key[1]);
                User user = JpaUserAndRoleProvider.this.loadUser(key[0], key[1]);
                return user == null ? JpaUserAndRoleProvider.this.nullToken : user;
            }
        });
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    public List<Role> getRolesForUser(String userName) {
        ArrayList<Role> roles = new ArrayList<Role>();
        User user = this.loadUser(userName);
        if (user == null) {
            return roles;
        }
        roles.addAll(user.getRoles());
        return roles;
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        String orgId = this.securityService.getOrganization().getId();
        return ((List)this.db.exec(UserDirectoryPersistenceUtil.findUsersByQuery(orgId, query, limit, offset))).stream().map(JpaUserAndRoleProvider::addProviderName).collect(Collectors.toList()).iterator();
    }

    public Iterator<User> findUsers(Collection<String> userNames) {
        String orgId = this.securityService.getOrganization().getId();
        return ((List)this.db.exec(UserDirectoryPersistenceUtil.findUsersByUserNameQuery(userNames, orgId))).stream().map(JpaUserAndRoleProvider::addProviderName).collect(Collectors.toList()).iterator();
    }

    public List<User> findInsecurePasswordHashes() {
        String orgId = this.securityService.getOrganization().getId();
        return (List)this.db.exec(Queries.namedQuery.findAll("User.findInsecureHash", User.class, new Object[]{Pair.of((Object)"org", (Object)orgId)}));
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        if (query == null) {
            throw new IllegalArgumentException("Query must be set");
        }
        return Collections.emptyIterator();
    }

    public User loadUser(String userName) {
        String orgId = this.securityService.getOrganization().getId();
        Object user = this.cache.getUnchecked((Object)userName.concat(DELIMITER).concat(orgId));
        if (user == this.nullToken) {
            return null;
        }
        return (User)user;
    }

    public Iterator<User> getUsers() {
        String orgId = this.securityService.getOrganization().getId();
        return ((List)this.db.exec(UserDirectoryPersistenceUtil.findUsersQuery(orgId, 0, 0))).stream().map(JpaUserAndRoleProvider::addProviderName).collect(Collectors.toList()).iterator();
    }

    public String getOrganization() {
        return "*";
    }

    public String toString() {
        return this.getClass().getName();
    }

    public User loadUser(String userName, String organization) {
        return ((Optional)this.db.exec(UserDirectoryPersistenceUtil.findUserQuery(userName, organization))).map(JpaUserAndRoleProvider::addProviderName).orElse(null);
    }

    public User loadUser(long userId, String organization) {
        return ((Optional)this.db.exec(UserDirectoryPersistenceUtil.findUserQuery(userId, organization))).map(JpaUserAndRoleProvider::addProviderName).orElse(null);
    }

    public void addUser(JpaUser user) throws UnauthorizedException {
        this.addUser(user, false);
    }

    public void addUser(JpaUser user, boolean passwordEncoded) throws UnauthorizedException {
        if (!UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, user.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to set the admin role on other users");
        }
        String encodedPassword = passwordEncoded ? user.getPassword() : this.passwordEncoder.encodePassword(user.getPassword());
        this.db.execTx(em -> {
            Set<JpaRole> roles = UserDirectoryPersistenceUtil.saveRolesQuery(this.filterRoles(user.getRoles())).apply((EntityManager)em);
            JpaOrganization organization = UserDirectoryPersistenceUtil.saveOrganizationQuery((JpaOrganization)user.getOrganization()).apply((EntityManager)em);
            JpaUser newUser = new JpaUser(user.getUsername(), encodedPassword, organization, user.getName(), user.getEmail(), user.getProvider(), user.isManageable(), roles);
            em.persist((Object)newUser);
            this.cache.put((Object)(user.getUsername() + DELIMITER + user.getOrganization().getId()), (Object)newUser);
        });
        this.updateGroupMembership(user);
    }

    public User updateUser(JpaUser user) throws NotFoundException, UnauthorizedException {
        return this.updateUser(user, false);
    }

    public User updateUser(JpaUser user, boolean passwordEncoded) throws NotFoundException, UnauthorizedException {
        if (!UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, user.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to set the admin role on other users");
        }
        try {
            return (User)this.db.execTxChecked(em -> {
                Optional<JpaUser> updateUser = UserDirectoryPersistenceUtil.findUserQuery(user.getUsername(), user.getOrganization().getId()).apply((EntityManager)em);
                if (updateUser.isEmpty()) {
                    throw new NotFoundException("User " + user.getUsername() + " not found.");
                }
                logger.debug("updateUser({})", (Object)user.getUsername());
                if (!UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, updateUser.get().getRoles())) {
                    throw new UnauthorizedException("The user is not allowed to update an admin user");
                }
                String encodedPassword = StringUtils.isEmpty((CharSequence)user.getPassword()) ? updateUser.get().getPassword() : (passwordEncoded ? user.getPassword() : this.passwordEncoder.encodePassword(user.getPassword()));
                Set<JpaRole> roles = UserDirectoryPersistenceUtil.saveRolesQuery(this.filterRoles(user.getRoles())).apply((EntityManager)em);
                JpaOrganization organization = UserDirectoryPersistenceUtil.saveOrganizationQuery((JpaOrganization)user.getOrganization()).apply((EntityManager)em);
                JpaUser updatedUser = UserDirectoryPersistenceUtil.saveUserQuery(new JpaUser(user.getUsername(), encodedPassword, organization, user.getName(), user.getEmail(), user.getProvider(), true, roles)).apply((EntityManager)em);
                this.cache.put((Object)(user.getUsername() + DELIMITER + organization.getId()), (Object)updatedUser);
                this.updateGroupMembership(user);
                return updatedUser;
            });
        }
        catch (RuntimeException | UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Set<JpaRole> filterRoles(Set<Role> userRoles) {
        HashSet<JpaRole> roles = new HashSet<JpaRole>();
        for (Role role : userRoles) {
            if (!Role.Type.INTERNAL.equals((Object)role.getType()) || role.getName().startsWith("ROLE_GROUP_")) continue;
            JpaRole jpaRole = (JpaRole)role;
            roles.add(jpaRole);
        }
        return roles;
    }

    private void updateGroupMembership(JpaUser user) {
        logger.debug("updateGroupMembership({}, roles={})", (Object)user.getUsername(), (Object)user.getRoles().size());
        ArrayList<String> internalGroupRoles = new ArrayList<String>();
        for (Role role : user.getRoles()) {
            if (!Role.Type.GROUP.equals((Object)role.getType()) && (!Role.Type.INTERNAL.equals((Object)role.getType()) || !role.getName().startsWith("ROLE_GROUP_"))) continue;
            internalGroupRoles.add(role.getName());
        }
        this.groupRoleProvider.updateGroupMembershipFromRoles(user.getUsername(), user.getOrganization().getId(), internalGroupRoles);
    }

    public void deleteUser(String username, String orgId) throws NotFoundException, UnauthorizedException, Exception {
        User user = this.loadUser(username, orgId);
        if (user != null && !UserDirectoryUtils.isCurrentUserAuthorizedHandleRoles(this.securityService, user.getRoles())) {
            throw new UnauthorizedException("The user is not allowed to delete an admin user");
        }
        this.groupRoleProvider.removeMemberFromAllGroups(username, orgId);
        this.db.execTxChecked(UserDirectoryPersistenceUtil.deleteUserQuery(username, orgId));
        this.cache.invalidate((Object)(username + DELIMITER + orgId));
    }

    public void addRole(JpaRole jpaRole) {
        HashSet<JpaRole> roles = new HashSet<JpaRole>();
        roles.add(jpaRole);
        this.db.execTx(UserDirectoryPersistenceUtil.saveRolesQuery(roles));
    }

    public String getName() {
        return PROVIDER_NAME;
    }

    private static User addProviderName(JpaUser u) {
        u.setProvider(PROVIDER_NAME);
        return u;
    }

    public long countUsers() {
        String orgId = this.securityService.getOrganization().getId();
        return (Long)this.db.exec(UserDirectoryPersistenceUtil.countUsersQuery(orgId));
    }

    public long countAllUsers() {
        return (Long)this.db.exec(UserDirectoryPersistenceUtil.countUsersQuery());
    }

    public void invalidate(String userName) {
        String orgId = this.securityService.getOrganization().getId();
        this.cache.invalidate((Object)(userName + DELIMITER + orgId));
    }
}

