/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryListener;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityConstants;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.impl.jpa.JpaGroup;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUser;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.userdirectory.JpaGroupRoleProvider;
import org.opencastproject.userdirectory.JpaUserAndRoleProvider;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=System admin user and group loader"}, immediate=true, service={AdminUserAndGroupLoader.class})
public class AdminUserAndGroupLoader
implements OrganizationDirectoryListener {
    private static final Logger logger = LoggerFactory.getLogger(AdminUserAndGroupLoader.class);
    public static final String OPT_ADMIN_PASSWORD = "org.opencastproject.security.admin.pass";
    private static final String DEFAULT_ADMIN_PASSWORD_CONFIGURATION = "opencast";
    public static final String OPT_ADMIN_ROLES = "org.opencastproject.security.admin.roles";
    public static final String SYSTEM_ADMIN_GROUP_SUFFIX = "_SYSTEM_ADMINS";
    private String adminUserName = null;
    private String adminPassword = null;
    private String adminEmail = null;
    private String adminRoles = null;
    protected JpaUserAndRoleProvider userAndRoleProvider;
    protected JpaGroupRoleProvider groupRoleProvider;
    protected OrganizationDirectoryService organizationDirectoryService;
    protected SecurityService securityService;
    protected ComponentContext componentCtx = null;

    @Activate
    public void activate(ComponentContext cc) throws Exception {
        logger.debug("Activating admin group loader");
        BundleContext bundleCtx = cc.getBundleContext();
        this.adminUserName = StringUtils.trimToNull((String)bundleCtx.getProperty("org.opencastproject.security.admin.user"));
        this.adminPassword = StringUtils.trimToNull((String)bundleCtx.getProperty(OPT_ADMIN_PASSWORD));
        this.adminEmail = StringUtils.trimToNull((String)bundleCtx.getProperty("org.opencastproject.admin.email"));
        this.adminRoles = StringUtils.trimToNull((String)bundleCtx.getProperty(OPT_ADMIN_ROLES));
        if (DEFAULT_ADMIN_PASSWORD_CONFIGURATION.equals(this.adminPassword)) {
            logger.warn("\n######################################################\n#                                                    #\n# WARNING: Opencast still uses the default admin     #\n#          credentials. Never do this in production. #\n#                                                    #\n#          To change the password, edit the key      #\n#          org.opencastproject.security.admin.pass   #\n#          in custom.properties.                     #\n#                                                    #\n######################################################");
        }
        this.componentCtx = cc;
        for (Organization organization : this.organizationDirectoryService.getOrganizations()) {
            this.createSystemAdministratorUserAndGroup(organization);
        }
    }

    private JpaOrganization fromOrganization(Organization org) {
        if (org instanceof JpaOrganization) {
            return (JpaOrganization)org;
        }
        return new JpaOrganization(org.getId(), org.getName(), org.getServers(), org.getAdminRole(), org.getAnonymousRole(), org.getProperties());
    }

    private void createSystemAdministratorUserAndGroup(Organization organization) {
        if (this.adminUserName == null || this.adminPassword == null) {
            logger.info("The administrator user and group loader is disabled.");
            return;
        }
        SecurityUtil.runAs((SecurityService)this.securityService, (Organization)organization, (User)SecurityUtil.createSystemUser((ComponentContext)this.componentCtx, (Organization)organization), () -> {
            try {
                JpaOrganization org = this.fromOrganization(this.organizationDirectoryService.getOrganization(organization.getId()));
                boolean userExists = this.userAndRoleProvider.loadUser(this.adminUserName) != null;
                Set adminRolesSet = Arrays.stream(StringUtils.split((String)Objects.toString(this.adminRoles, ""), (char)',')).map(StringUtils::trimToNull).filter(Objects::nonNull).map(r -> new JpaRole(r, org)).collect(Collectors.toSet());
                JpaUser adminUser = new JpaUser(this.adminUserName, this.adminPassword, org, "Administrator", this.adminEmail, "system", false, adminRolesSet);
                if (userExists) {
                    this.userAndRoleProvider.updateUser(adminUser);
                    logger.info("Administrator user for '{}' updated", (Object)org.getId());
                } else {
                    this.userAndRoleProvider.addUser(adminUser);
                    logger.info("Administrator user for '{}' created", (Object)org.getId());
                }
                String adminGroupId = org.getId().toUpperCase().concat(SYSTEM_ADMIN_GROUP_SUFFIX);
                JpaGroup systemAdminGroup = this.groupRoleProvider.loadGroup(adminGroupId, org.getId());
                HashSet<JpaRole> systemAdminRoles = new HashSet<JpaRole>();
                HashSet<String> systemAdminRolesIds = new HashSet<String>();
                for (String role : SecurityConstants.GLOBAL_SYSTEM_ROLES) {
                    systemAdminRoles.add(new JpaRole(role, org));
                    systemAdminRolesIds.add(role);
                }
                if (StringUtils.isNotBlank((CharSequence)org.getAdminRole())) {
                    systemAdminRoles.add(new JpaRole(org.getAdminRole(), org));
                    systemAdminRolesIds.add(org.getAdminRole());
                }
                if (StringUtils.isNotBlank((CharSequence)org.getAnonymousRole())) {
                    systemAdminRoles.add(new JpaRole(org.getAnonymousRole(), org));
                    systemAdminRolesIds.add(org.getAnonymousRole());
                }
                if (this.adminRoles != null) {
                    for (String r2 : StringUtils.split((String)this.adminRoles, (char)',')) {
                        String roleId = StringUtils.trimToNull((String)r2);
                        if (roleId == null) continue;
                        systemAdminRoles.add(new JpaRole(roleId, org));
                        systemAdminRolesIds.add(roleId);
                    }
                }
                HashSet<String> groupMembers = new HashSet<String>();
                groupMembers.add(this.adminUserName);
                String adminGroupName = org.getName().concat(" System Administrators");
                String adminGroupDescription = "System administrators of '" + org.getName() + "'";
                if (systemAdminGroup == null) {
                    logger.info("Creating {}'s system administrator group", (Object)org.getId());
                    systemAdminGroup = new JpaGroup(adminGroupId, org, adminGroupName, adminGroupDescription, systemAdminRoles);
                    systemAdminGroup.setMembers(groupMembers);
                    this.groupRoleProvider.addGroup(systemAdminGroup);
                } else {
                    logger.info("Updating roles of {}'s system administrator group", (Object)org.getId());
                    groupMembers.addAll(systemAdminGroup.getMembers());
                    this.groupRoleProvider.updateGroup(adminGroupId, adminGroupName, adminGroupDescription, StringUtils.join(systemAdminRolesIds, (char)','), StringUtils.join(groupMembers, (char)','));
                }
            }
            catch (Throwable t) {
                logger.error("Unable to load system administrator group", t);
            }
        });
    }

    public void organizationRegistered(Organization organization) {
        this.createSystemAdministratorUserAndGroup(organization);
    }

    public void organizationUnregistered(Organization organization) {
    }

    public void organizationUpdated(Organization organization) {
    }

    @Reference
    void setGroupRoleProvider(JpaGroupRoleProvider groupRoleProvider) {
        this.groupRoleProvider = groupRoleProvider;
    }

    @Reference
    void setUserAndRoleProvider(JpaUserAndRoleProvider userAndRoleProvider) {
        this.userAndRoleProvider = userAndRoleProvider;
    }

    @Reference
    void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
        this.organizationDirectoryService.addOrganizationDirectoryListener((OrganizationDirectoryListener)this);
    }

    @Reference
    void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }
}

