/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.studip;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.studip.StudipUserProviderInstance;
import org.opencastproject.util.NotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedServiceFactory.class}, property={"service.pid=org.opencastproject.userdirectory.studip", "service.description=Provides Studip user directory instances"})
public class StudipUserProviderFactory
implements ManagedServiceFactory {
    protected static final Logger logger = LoggerFactory.getLogger(StudipUserProviderFactory.class);
    public static final String PID = "org.opencastproject.userdirectory.studip";
    private static final String ORGANIZATION_KEY = "org.opencastproject.userdirectory.studip.org";
    private static final String STUDIP_URL_KEY = "org.opencastproject.userdirectory.studip.url";
    private static final String STUDIP_TOKEN_KEY = "org.opencastproject.userdirectory.studip.token";
    private static final String CACHE_SIZE = "org.opencastproject.userdirectory.studip.cache.size";
    private static final String CACHE_EXPIRATION = "org.opencastproject.userdirectory.studip.cache.expiration";
    private Map<String, ServiceRegistration> providerRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();
    protected BundleContext bundleContext = null;
    private OrganizationDirectoryService orgDirectory;

    @Reference
    public void setOrgDirectory(OrganizationDirectoryService orgDirectory) {
        this.orgDirectory = orgDirectory;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("Activate StudipUserProviderFactory");
        this.bundleContext = cc.getBundleContext();
    }

    public String getName() {
        return PID;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        Organization org;
        logger.debug("updated StudipUserProviderFactory");
        String organization = (String)properties.get(ORGANIZATION_KEY);
        if (StringUtils.isBlank((CharSequence)organization)) {
            throw new ConfigurationException(ORGANIZATION_KEY, "is not set");
        }
        URI url = null;
        try {
            url = new URI((String)properties.get(STUDIP_URL_KEY));
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(STUDIP_URL_KEY, "URI is invalid", (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)url.toString())) {
            throw new ConfigurationException(STUDIP_URL_KEY, "is not set");
        }
        String token = (String)properties.get(STUDIP_TOKEN_KEY);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ConfigurationException(STUDIP_TOKEN_KEY, "is not set");
        }
        int cacheSize = 1000;
        try {
            Integer configuredCacheSize;
            if (properties.get(CACHE_SIZE) != null && (configuredCacheSize = Integer.valueOf(Integer.parseInt(properties.get(CACHE_SIZE).toString()))) != null) {
                cacheSize = configuredCacheSize;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("{} could not be loaded", CACHE_SIZE);
        }
        int cacheExpiration = 60;
        try {
            Integer configuredCacheExpiration;
            if (properties.get(CACHE_EXPIRATION) != null && (configuredCacheExpiration = Integer.valueOf(Integer.parseInt(properties.get(CACHE_EXPIRATION).toString()))) != null) {
                cacheExpiration = configuredCacheExpiration;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("{} could not be loaded", CACHE_EXPIRATION);
        }
        ServiceRegistration existingRegistration = this.providerRegistrations.remove(pid);
        if (existingRegistration != null) {
            existingRegistration.unregister();
        }
        try {
            org = this.orgDirectory.getOrganization(organization);
        }
        catch (NotFoundException e) {
            logger.warn("Organization {} not found!", (Object)organization);
            throw new ConfigurationException(ORGANIZATION_KEY, "not found");
        }
        logger.debug("creating new StudipUserProviderInstance for pid=" + pid);
        StudipUserProviderInstance provider = new StudipUserProviderInstance(pid, org, url, token, cacheSize, cacheExpiration);
        this.providerRegistrations.put(pid, this.bundleContext.registerService(UserProvider.class.getName(), (Object)provider, null));
        this.providerRegistrations.put(pid, this.bundleContext.registerService(RoleProvider.class.getName(), (Object)provider, null));
    }

    public void deleted(String pid) {
        logger.debug("delete StudipUserProviderInstance for pid=" + pid);
        ServiceRegistration registration = this.providerRegistrations.remove(pid);
        if (registration != null) {
            registration.unregister();
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(StudipUserProviderFactory.getObjectName(pid));
            }
            catch (Exception e) {
                logger.warn("Unable to unregister mbean for pid='{}': {}", (Object)pid, (Object)e.getMessage());
            }
        }
    }

    public static final ObjectName getObjectName(String pid) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(pid + ":type=StudipRequests");
    }
}

