/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.StringJoiner;
import org.opencastproject.userdirectory.ldap.OpencastUserDetails;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.ldap.userdetails.UserDetailsContextMapper;

public class OpencastUserDetailsContextMapper
implements UserDetailsContextMapper {
    private final String[] name;
    private final String mail;

    public OpencastUserDetailsContextMapper(String[] name, String mail) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(mail);
        this.name = name;
        this.mail = mail;
    }

    public UserDetails mapUserFromContext(DirContextOperations ctx, String username, Collection<? extends GrantedAuthority> authorities) {
        String dn = ctx.getNameInNamespace();
        OpencastUserDetails.Essence essence = new OpencastUserDetails.Essence();
        essence.setDn(dn);
        essence.setUsername(username);
        essence.setName(this.buildName(ctx));
        essence.setMail(ctx.getStringAttribute(this.mail));
        for (GrantedAuthority grantedAuthority : authorities) {
            essence.addAuthority(grantedAuthority);
        }
        return essence.createUserDetails();
    }

    private String buildName(DirContextOperations ctx) {
        StringJoiner joiner = new StringJoiner(" ");
        for (String attribute : this.name) {
            joiner.add(ctx.getStringAttribute(attribute));
        }
        return joiner.toString();
    }

    public void mapUserToContext(UserDetails user, DirContextAdapter ctx) {
        throw new UnsupportedOperationException("OpencastUserContextMapper only supports reading from a context. Pleaseuse a subclass if mapUserToContext() is required.");
    }

    public String[] getAttributes() {
        ArrayList<String> attributes = new ArrayList<String>(Arrays.asList(this.name));
        attributes.add(this.mail);
        return attributes.toArray(new String[0]);
    }
}

