/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.brightspace.client;

import be.ugent.brightspace.idkeyauth.AuthenticationSecurityFactory;
import be.ugent.brightspace.idkeyauth.ID2LAppContext;
import be.ugent.brightspace.idkeyauth.ID2LUserContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import org.opencastproject.userdirectory.brightspace.client.BrightspaceClient;
import org.opencastproject.userdirectory.brightspace.client.BrightspaceClientException;
import org.opencastproject.userdirectory.brightspace.client.BrightspaceNotFoundException;
import org.opencastproject.userdirectory.brightspace.client.api.BrightspaceUser;
import org.opencastproject.userdirectory.brightspace.client.api.OrgUnitItem;
import org.opencastproject.userdirectory.brightspace.client.api.OrgUnitResponse;
import org.opencastproject.userdirectory.brightspace.client.api.PagingInfo;
import org.opencastproject.userdirectory.brightspace.client.api.UsersResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrightspaceClientImpl
implements BrightspaceClient {
    private static final Logger logger = LoggerFactory.getLogger(BrightspaceClientImpl.class);
    private static final String GET_USER_BY_USERNAME = "/d2l/api/lp/1.31/users/?UserName=";
    private static final String GET_ALL_USERS = "/d2l/api/lp/1.31/users/";
    private static final String GET_COURSES_BY_BRIGHTSPACE_USER_ID = "/d2l/api/lp/1.31/enrollments/users/{brightspace-userid}/orgUnits/?orgUnitTypeId=3";
    private static final String UNEXPECTED_JSON_RESPONSE = "The brightspace API returned a unexpected json response";
    private static final String SUPER_ADMIN = "Super Administrator";
    private static final String LTI_LEARNER_ROLE = "Learner";
    private static final String LTI_INSTRUCTOR_ROLE = "Instructor";
    private final String url;
    private final String applicationId;
    private final String applicationKey;
    private final String systemUserId;
    private final String systemUserKey;
    private final ID2LUserContext userContext;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public BrightspaceClientImpl(String url, String applicationId, String applicationKey, String systemUserId, String systemUserKey) {
        this.url = url;
        this.applicationId = applicationId;
        this.applicationKey = applicationKey;
        this.systemUserId = systemUserId;
        this.systemUserKey = systemUserKey;
        this.userContext = this.createUserContext();
    }

    @Override
    public BrightspaceUser findUser(String userName) throws BrightspaceClientException {
        String request = GET_USER_BY_USERNAME + userName;
        try {
            String response = this.httpGetRequest(request);
            logger.debug(response);
            BrightspaceUser brightspaceUser = (BrightspaceUser)this.objectMapper.readerFor(BrightspaceUser.class).readValue(response);
            return brightspaceUser;
        }
        catch (BrightspaceNotFoundException nfe) {
            return null;
        }
        catch (IOException e) {
            logger.debug(e.toString());
            throw new BrightspaceClientException(UNEXPECTED_JSON_RESPONSE, e);
        }
    }

    @Override
    public List<String> getRolesFromBrightspace(String userid, Set<String> instructorRoles) throws BrightspaceClientException {
        logger.debug("Retrieving subscribed courses for user: {}", (Object)userid);
        String bookmark = null;
        ArrayList<String> roleList = new ArrayList<String>();
        try {
            boolean hasMoreItems;
            do {
                String request;
                OrgUnitResponse orgUnitPage;
                if (SUPER_ADMIN.equals((orgUnitPage = this.findOrgUnitPage(request = this.composePagedUrl(bookmark, userid))).getItems().get(0).getRole().getName())) {
                    roleList.add("BRIGHTSPACE_ADMIN");
                    return roleList;
                }
                for (OrgUnitItem course : orgUnitPage.getItems()) {
                    String brightspaceRole = course.getRole().getName();
                    String ltiRole = instructorRoles.contains(brightspaceRole) ? LTI_INSTRUCTOR_ROLE : LTI_LEARNER_ROLE;
                    String opencastRole = String.format("%s_%s", course.getOrgUnit().getId(), ltiRole);
                    roleList.add(opencastRole);
                }
                PagingInfo pagingInfo = orgUnitPage.getPagingInfo();
                hasMoreItems = pagingInfo.hasMoreItems();
                bookmark = pagingInfo.getBookmark();
            } while (hasMoreItems);
            return roleList;
        }
        catch (BrightspaceClientException e) {
            logger.warn("Exception getting site/role membership for brightspace user {}", (Object)userid, (Object)e);
            throw new BrightspaceClientException(UNEXPECTED_JSON_RESPONSE, e);
        }
    }

    @Override
    public List<BrightspaceUser> findAllUsers() throws BrightspaceClientException {
        try {
            String response = this.httpGetRequest(GET_ALL_USERS);
            UsersResponse usersResponse = (UsersResponse)this.objectMapper.readValue(response, UsersResponse.class);
            return usersResponse.getItems();
        }
        catch (IOException e) {
            throw new BrightspaceClientException(UNEXPECTED_JSON_RESPONSE, e);
        }
        catch (BrightspaceNotFoundException nfe) {
            throw new BrightspaceClientException(UNEXPECTED_JSON_RESPONSE, nfe);
        }
    }

    @Override
    public String getURL() {
        return this.url;
    }

    private String httpGetRequest(String request) throws BrightspaceClientException, BrightspaceNotFoundException {
        URL url = this.createUrl(request);
        try {
            HttpsURLConnection urlConnection = (HttpsURLConnection)this.getURLConnection(url);
            if (urlConnection.getResponseCode() == 404) {
                logger.debug("Not found, 404 response");
                throw new BrightspaceNotFoundException("not found");
            }
            InputStream inputStream = urlConnection.getInputStream();
            return this.readInputStream(inputStream);
        }
        catch (IOException io) {
            logger.warn("error in brightspace data fetching", (Throwable)io);
            throw new BrightspaceClientException("could not read response");
        }
    }

    private URL createUrl(String request) throws BrightspaceClientException {
        URL url;
        URI uri = this.userContext.createAuthenticatedUri(request, "GET");
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException mue) {
            throw new BrightspaceClientException("url was malformed", mue);
        }
        logger.debug("about to make GET request to : {}", (Object)uri);
        return url;
    }

    private ID2LUserContext createUserContext() {
        ID2LAppContext securityContext = AuthenticationSecurityFactory.createSecurityContext((String)this.applicationId, (String)this.applicationKey, (String)this.url);
        return securityContext.createUserContext(this.systemUserId, this.systemUserKey);
    }

    private URLConnection getURLConnection(URL url) throws BrightspaceClientException {
        try {
            HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept-Charset", "utf-8");
            urlConnection.setDoInput(true);
            urlConnection.setDoOutput(true);
            return urlConnection;
        }
        catch (IOException ioe) {
            throw new BrightspaceClientException("Brightspace api unreachable", ioe);
        }
    }

    private String readInputStream(InputStream inputStream) throws BrightspaceClientException {
        String string;
        StringBuilder content = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String inputline;
            while ((inputline = bufferedReader.readLine()) != null) {
                content.append(inputline);
            }
            logger.debug("call to brightspace api: {}", (Object)content);
            string = content.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException io) {
                throw new BrightspaceClientException("Could not read response", io);
            }
        }
        bufferedReader.close();
        return string;
    }

    private OrgUnitResponse findOrgUnitPage(String request) throws BrightspaceClientException {
        try {
            String response = this.httpGetRequest(request);
            return (OrgUnitResponse)this.objectMapper.readValue(response, OrgUnitResponse.class);
        }
        catch (IOException e) {
            logger.error(UNEXPECTED_JSON_RESPONSE);
            throw new BrightspaceClientException(UNEXPECTED_JSON_RESPONSE, e);
        }
        catch (BrightspaceNotFoundException nfe) {
            logger.error(UNEXPECTED_JSON_RESPONSE);
            throw new BrightspaceClientException(UNEXPECTED_JSON_RESPONSE, nfe);
        }
    }

    private String composePagedUrl(String bookmark, String brightspaceUserId) {
        Object request = GET_COURSES_BY_BRIGHTSPACE_USER_ID.replaceAll("\\{\\S+}", brightspaceUserId);
        if (bookmark != null) {
            request = (String)request + "&bookmark=" + bookmark;
        }
        return request;
    }
}

