/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.brightspace;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.opencastproject.security.api.CachingUserProviderMXBean;
import org.opencastproject.security.api.JaxbOrganization;
import org.opencastproject.security.api.JaxbRole;
import org.opencastproject.security.api.JaxbUser;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.brightspace.BrightspaceUserProviderFactory;
import org.opencastproject.userdirectory.brightspace.client.BrightspaceClient;
import org.opencastproject.userdirectory.brightspace.client.BrightspaceClientException;
import org.opencastproject.userdirectory.brightspace.client.api.BrightspaceUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrightspaceUserProviderInstance
implements UserProvider,
RoleProvider,
CachingUserProviderMXBean {
    private static final Logger logger = LoggerFactory.getLogger(BrightspaceUserProviderInstance.class);
    private static final String LTI_LEARNER_ROLE = "Learner";
    private static final String LTI_INSTRUCTOR_ROLE = "Instructor";
    private String pid;
    private BrightspaceClient client;
    private Organization organization;
    private LoadingCache<String, Object> cache;
    private Object nullToken = new Object();
    private AtomicLong loadUserRequests;
    private AtomicLong brightspaceWebServiceRequests;
    private final Set<String> instructorRoles;
    private final Set<String> ignoredUsernames;

    public BrightspaceUserProviderInstance(String pid, BrightspaceClient client, Organization organization, int cacheSize, int cacheExpiration, Set instructorRoles, Set ignoredUsernames) {
        this.pid = pid;
        this.client = client;
        this.organization = organization;
        this.instructorRoles = instructorRoles;
        this.ignoredUsernames = ignoredUsernames;
        logger.info("Creating new BrightspaceUserProviderInstance(pid={}, url={}, cacheSize={}, cacheExpiration={}, InstructorRoles={}, ignoredUserNames={})", new Object[]{pid, client.getURL(), cacheSize, cacheExpiration, instructorRoles, ignoredUsernames});
        this.cache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).expireAfterWrite((long)cacheExpiration, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Object>(){

            public Object load(String username) {
                User user = BrightspaceUserProviderInstance.this.loadUserFromBrightspace(username);
                return user == null ? BrightspaceUserProviderInstance.this.nullToken : user;
            }
        });
        this.registerMBean(pid);
    }

    public float getCacheHitRatio() {
        if (this.loadUserRequests.get() == 0L) {
            return 0.0f;
        }
        return (float)(this.loadUserRequests.get() - this.brightspaceWebServiceRequests.get()) / (float)this.loadUserRequests.get();
    }

    private void registerMBean(String pid) {
        this.loadUserRequests = new AtomicLong();
        this.brightspaceWebServiceRequests = new AtomicLong();
        try {
            ObjectName name = BrightspaceUserProviderFactory.getObjectName(pid);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(name);
            }
            catch (InstanceNotFoundException ife) {
                logger.debug("{} was not registered", (Object)name);
            }
            mbs.registerMBean(this, name);
        }
        catch (Exception e) {
            logger.error("Unable to register {} as an mbean", (Object)this, (Object)e);
        }
    }

    public String getName() {
        return this.pid;
    }

    public Iterator<User> getUsers() {
        return Collections.emptyIterator();
    }

    public User loadUser(String userName) {
        this.loadUserRequests.incrementAndGet();
        logger.debug("getting user from cache");
        try {
            Object user = this.cache.getUnchecked((Object)userName);
            if (user != this.nullToken) {
                logger.debug("Returning user {} from cache", (Object)userName);
                return (User)user;
            }
            logger.debug("Returning null user from cache");
            return null;
        }
        catch (ExecutionError | UncheckedExecutionException ee) {
            logger.warn("Exception while loading user {}", (Object)userName, (Object)ee);
            return null;
        }
    }

    public long countUsers() {
        return 0L;
    }

    public String getOrganization() {
        return this.organization.getId();
    }

    public Iterator<User> findUsers(String query, int offset, int limit) {
        return Collections.emptyIterator();
    }

    public void invalidate(String userName) {
        this.cache.invalidate((Object)userName);
    }

    public List<Role> getRolesForUser(String username) {
        User user = this.loadUser(username);
        if (user != null) {
            logger.debug("Returning cached role set for {}", (Object)username);
            return new ArrayList<Role>(user.getRoles());
        }
        logger.debug("Return empty role set for {} - not found in Brightspace", (Object)username);
        return Collections.emptyList();
    }

    public Iterator<Role> findRoles(String query, Role.Target target, int offset, int limit) {
        return Collections.emptyIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User loadUserFromBrightspace(String username) {
        if (this.cache == null) {
            throw new IllegalStateException("The Brightspace user detail service has not yet been configured");
        }
        if (this.ignoredUsernames.stream().anyMatch(u -> u.equals(username))) {
            logger.debug("We don't answer for: " + username);
            return null;
        }
        logger.debug("In loadUserFromBrightspace, currently processing user: {}", (Object)username);
        JaxbOrganization jaxbOrganization = JaxbOrganization.fromOrganization((Organization)this.organization);
        this.brightspaceWebServiceRequests.incrementAndGet();
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassloader = currentThread.getContextClassLoader();
        try {
            BrightspaceUser brightspaceUser = this.client.findUser(username);
            if (brightspaceUser != null) {
                logger.info("Retrieved user {}", (Object)brightspaceUser.getUserId());
                String brightspaceUserId = brightspaceUser.getUserId();
                List<String> roleList = this.client.getRolesFromBrightspace(brightspaceUserId, this.instructorRoles);
                logger.debug("Brightspace user {} with id {} with roles: {}", new Object[]{username, brightspaceUserId, roleList});
                HashSet<JaxbRole> roles = new HashSet<JaxbRole>();
                boolean isInstructor = false;
                for (String roleStr : roleList) {
                    roles.add(new JaxbRole(roleStr, jaxbOrganization, "Brightspace external role", Role.Type.EXTERNAL));
                    if (!roleStr.endsWith(LTI_INSTRUCTOR_ROLE)) continue;
                    isInstructor = true;
                }
                roles.add(new JaxbRole("ROLE_GROUP_BRIGHTSPACE", jaxbOrganization, "Brightspace User", Role.Type.EXTERNAL_GROUP));
                if (isInstructor) {
                    roles.add(new JaxbRole("ROLE_GROUP_BRIGHTSPACE_INSTRUCTOR", jaxbOrganization, "Brightspace Instructor", Role.Type.EXTERNAL_GROUP));
                }
                logger.debug("Returning JaxbRoles: {}", roles);
                JaxbUser user = new JaxbUser(username, null, brightspaceUser.getDisplayName(), brightspaceUser.getExternalEmail(), this.getName(), jaxbOrganization, roles);
                this.cache.put((Object)username, (Object)user);
                logger.debug("Returning user {}", (Object)user);
                JaxbUser jaxbUser = user;
                return jaxbUser;
            }
            this.cache.put((Object)username, this.nullToken);
            logger.debug("User {} not found in Brightspace system", (Object)username);
            User brightspaceUserId = null;
            return brightspaceUserId;
        }
        catch (BrightspaceClientException e) {
            logger.error("A Brightspace API error ( {} ) occurred, user {} could not be retrieved", (Object)e, (Object)username);
            User user = null;
            return user;
        }
        finally {
            currentThread.setContextClassLoader(originalClassloader);
        }
    }
}

