/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.userdirectory.brightspace;

import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.RoleProvider;
import org.opencastproject.security.api.UserProvider;
import org.opencastproject.userdirectory.brightspace.BrightspaceUserProviderInstance;
import org.opencastproject.userdirectory.brightspace.client.BrightspaceClientImpl;
import org.opencastproject.util.NotFoundException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedServiceFactory.class}, property={"service.pid=org.opencastproject.userdirectory.brightspace", "service.description=Provides Brightspace user directory instances"})
public class BrightspaceUserProviderFactory
implements ManagedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(BrightspaceUserProviderFactory.class);
    private static final String LTI_LEARNER_ROLE = "Learner";
    private static final String LTI_INSTRUCTOR_ROLE = "Instructor";
    private static final String ORGANIZATION_KEY = "org.opencastproject.userdirectory.brightspace.org";
    private static final String BRIGHTSPACE_USER_ID = "org.opencastproject.userdirectory.brightspace.systemuser.id";
    private static final String BRIGHTSPACE_USER_KEY = "org.opencastproject.userdirectory.brightspace.systemuser.key";
    private static final String BRIGHTSPACE_URL = "org.opencastproject.userdirectory.brightspace.url";
    private static final String BRIGHTSPACE_APP_ID = "org.opencastproject.userdirectory.brightspace.application.id";
    private static final String BRIGHTSPACE_APP_KEY = "org.opencastproject.userdirectory.brightspace.application.key";
    private static final String CACHE_SIZE_KEY = "org.opencastproject.userdirectory.brightspace.cache.size";
    private static final String CACHE_EXPIRATION_KEY = "org.opencastproject.userdirectory.brightspace.cache.expiration";
    private static final String BRIGHTSPACE_NAME = "org.opencastproject.userdirectory.brightspace";
    private static final int DEFAULT_CACHE_SIZE_VALUE = 1000;
    private static final int DEFAULT_CACHE_EXPIRATION_VALUE = 60;
    private static final String BRIGHTSPACE_INSTRUCTOR_ROLES_KEY = "org.opencastproject.userdirectory.brightspace.instructor.roles";
    private static final String DEFAULT_BRIGHTSPACE_INSTRUCTOR_ROLES = "teacher,ta";
    private static final String IGNORED_USERNAMES_KEY = "org.opencastproject.userdirectory.brightspace.ignored.usernames";
    private static final String DEFAULT_IGNORED_USERNAMES = "admin,anonymous";
    protected BundleContext bundleContext;
    private Map<String, ServiceRegistration> providerRegistrations = new ConcurrentHashMap<String, ServiceRegistration>();
    private OrganizationDirectoryService orgDirectory;
    private int cacheSize;
    private int cacheExpiration;

    public static final ObjectName getObjectName(String pid) throws MalformedObjectNameException, NullPointerException {
        return new ObjectName(pid + ":type=BrightspaceRequests");
    }

    @Reference
    public void setOrgDirectory(OrganizationDirectoryService orgDirectory) {
        this.orgDirectory = orgDirectory;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.debug("Activate BrightspaceUserProviderFactory");
        this.bundleContext = cc.getBundleContext();
    }

    public String getName() {
        return BRIGHTSPACE_NAME;
    }

    public void updated(String pid, Dictionary properties) throws ConfigurationException {
        Organization org;
        logger.debug("updated BrightspaceUserProviderFactory");
        String adminUserName = StringUtils.trimToNull((String)this.bundleContext.getProperty("org.opencastproject.security.admin.user"));
        String organization = (String)properties.get(ORGANIZATION_KEY);
        String urlStr = (String)properties.get(BRIGHTSPACE_URL);
        String systemUserId = (String)properties.get(BRIGHTSPACE_USER_ID);
        String systemUserKey = (String)properties.get(BRIGHTSPACE_USER_KEY);
        String applicationId = (String)properties.get(BRIGHTSPACE_APP_ID);
        String applicationKey = (String)properties.get(BRIGHTSPACE_APP_KEY);
        String cacheSizeStr = (String)properties.get(CACHE_SIZE_KEY);
        this.cacheSize = StringUtils.isBlank((CharSequence)cacheSizeStr) ? 1000 : NumberUtils.toInt((String)cacheSizeStr);
        String cacheExpirationStr = (String)properties.get(CACHE_EXPIRATION_KEY);
        this.cacheExpiration = StringUtils.isBlank((CharSequence)cacheExpirationStr) ? 60 : NumberUtils.toInt((String)cacheExpirationStr);
        String rolesStr = (String)properties.get(BRIGHTSPACE_INSTRUCTOR_ROLES_KEY);
        if (StringUtils.isBlank((CharSequence)rolesStr)) {
            rolesStr = DEFAULT_BRIGHTSPACE_INSTRUCTOR_ROLES;
        }
        Set<String> instructorRoles = this.parsePropertyLineAsSet(rolesStr);
        logger.debug("Brightspace instructor roles: {}", instructorRoles);
        String ignoredUsersStr = (String)properties.get(IGNORED_USERNAMES_KEY);
        if (StringUtils.isBlank((CharSequence)ignoredUsersStr)) {
            ignoredUsersStr = DEFAULT_IGNORED_USERNAMES;
        }
        Set<String> ignoredUsernames = this.parsePropertyLineAsSet(ignoredUsersStr);
        logger.debug("Ignored users: {}", ignoredUsernames);
        this.validateUrl(urlStr);
        this.validateConfigurationKey(ORGANIZATION_KEY, organization);
        this.validateConfigurationKey(BRIGHTSPACE_USER_ID, systemUserId);
        this.validateConfigurationKey(BRIGHTSPACE_USER_KEY, systemUserKey);
        this.validateConfigurationKey(BRIGHTSPACE_APP_ID, applicationId);
        this.validateConfigurationKey(BRIGHTSPACE_APP_KEY, applicationKey);
        ServiceRegistration existingRegistration = this.providerRegistrations.remove(pid);
        if (existingRegistration != null) {
            existingRegistration.unregister();
        }
        try {
            org = this.orgDirectory.getOrganization(organization);
        }
        catch (NotFoundException nfe) {
            logger.warn("Organization {} not found!", (Object)organization);
            throw new ConfigurationException(ORGANIZATION_KEY, "not found");
        }
        logger.debug("creating new brightspace user provider for pid={}", (Object)pid);
        BrightspaceClientImpl clientImpl = new BrightspaceClientImpl(urlStr, applicationId, applicationKey, systemUserId, systemUserKey);
        BrightspaceUserProviderInstance provider = new BrightspaceUserProviderInstance(pid, clientImpl, org, this.cacheSize, this.cacheExpiration, instructorRoles, ignoredUsernames);
        this.providerRegistrations.put(pid, this.bundleContext.registerService(UserProvider.class.getName(), (Object)provider, null));
        this.providerRegistrations.put(pid, this.bundleContext.registerService(RoleProvider.class.getName(), (Object)provider, null));
    }

    public void deleted(String pid) {
        logger.debug("delete BrightspaceUserProviderInstance for pid={}", (Object)pid);
        ServiceRegistration registration = this.providerRegistrations.remove(pid);
        if (registration != null) {
            registration.unregister();
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(BrightspaceUserProviderFactory.getObjectName(pid));
            }
            catch (Exception e) {
                logger.warn("Unable to unregister mbean for pid='{}'", (Object)pid, (Object)e);
            }
        }
    }

    private void validateConfigurationKey(String key, String value) throws ConfigurationException {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new ConfigurationException(key, "is not set");
        }
    }

    private void validateUrl(String urlStr) throws ConfigurationException {
        if (StringUtils.isBlank((CharSequence)urlStr)) {
            throw new ConfigurationException(BRIGHTSPACE_URL, "is not set");
        }
        try {
            new URI(urlStr);
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(BRIGHTSPACE_URL, "not a URL");
        }
    }

    private Set<String> parsePropertyLineAsSet(String configLine) {
        String[] configs;
        HashSet<String> set = new HashSet<String>();
        for (String config : configs = configLine.split(",")) {
            set.add(config.trim());
        }
        return set;
    }
}

