/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.transcription.amberscript;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AmberscriptLangUtil {
    private static final Logger logger = LoggerFactory.getLogger(AmberscriptLangUtil.class);
    private List<String> availableAmberscriptLangs;
    private Map<String, String> langMap;
    private static AmberscriptLangUtil amberscriptLangUtil;

    public static AmberscriptLangUtil getInstance() {
        if (amberscriptLangUtil == null) {
            amberscriptLangUtil = new AmberscriptLangUtil();
        }
        return amberscriptLangUtil;
    }

    private AmberscriptLangUtil() {
        this.populateLangMap();
    }

    private void populateLangMap() {
        this.langMap = new HashMap<String, String>();
        this.availableAmberscriptLangs = new LinkedList<String>();
        this.availableAmberscriptLangs.add("af-za");
        this.availableAmberscriptLangs.add("sq-al");
        this.availableAmberscriptLangs.add("am-et");
        this.availableAmberscriptLangs.add("ar");
        this.availableAmberscriptLangs.add("hy-am");
        this.availableAmberscriptLangs.add("az-az");
        this.availableAmberscriptLangs.add("id-id");
        this.availableAmberscriptLangs.add("eu-es");
        this.availableAmberscriptLangs.add("bn-bd");
        this.availableAmberscriptLangs.add("bn-in");
        this.availableAmberscriptLangs.add("bs-ba");
        this.availableAmberscriptLangs.add("bg");
        this.availableAmberscriptLangs.add("my-mm");
        this.availableAmberscriptLangs.add("ca");
        this.availableAmberscriptLangs.add("cmn");
        this.availableAmberscriptLangs.add("hr");
        this.availableAmberscriptLangs.add("cs");
        this.availableAmberscriptLangs.add("da");
        this.availableAmberscriptLangs.add("nl");
        this.availableAmberscriptLangs.add("en-au");
        this.availableAmberscriptLangs.add("en-uk");
        this.availableAmberscriptLangs.add("en");
        this.availableAmberscriptLangs.add("et-ee");
        this.availableAmberscriptLangs.add("fa-ir");
        this.availableAmberscriptLangs.add("fil-ph");
        this.availableAmberscriptLangs.add("fi");
        this.availableAmberscriptLangs.add("nl-be");
        this.availableAmberscriptLangs.add("fr-ca");
        this.availableAmberscriptLangs.add("fr");
        this.availableAmberscriptLangs.add("gl-es");
        this.availableAmberscriptLangs.add("ka-ge");
        this.availableAmberscriptLangs.add("de-at");
        this.availableAmberscriptLangs.add("de-ch");
        this.availableAmberscriptLangs.add("de");
        this.availableAmberscriptLangs.add("el");
        this.availableAmberscriptLangs.add("gu-in");
        this.availableAmberscriptLangs.add("iw-il");
        this.availableAmberscriptLangs.add("hi");
        this.availableAmberscriptLangs.add("hu");
        this.availableAmberscriptLangs.add("is-is");
        this.availableAmberscriptLangs.add("it");
        this.availableAmberscriptLangs.add("ja");
        this.availableAmberscriptLangs.add("jv-id");
        this.availableAmberscriptLangs.add("kn-in");
        this.availableAmberscriptLangs.add("km-kh");
        this.availableAmberscriptLangs.add("ko");
        this.availableAmberscriptLangs.add("lo-la");
        this.availableAmberscriptLangs.add("lv");
        this.availableAmberscriptLangs.add("lt");
        this.availableAmberscriptLangs.add("mk-mk");
        this.availableAmberscriptLangs.add("ms");
        this.availableAmberscriptLangs.add("ml-in");
        this.availableAmberscriptLangs.add("mr-in");
        this.availableAmberscriptLangs.add("mn-mn");
        this.availableAmberscriptLangs.add("ne-np");
        this.availableAmberscriptLangs.add("no");
        this.availableAmberscriptLangs.add("pl");
        this.availableAmberscriptLangs.add("pt-br");
        this.availableAmberscriptLangs.add("pt");
        this.availableAmberscriptLangs.add("pa-guru-in");
        this.availableAmberscriptLangs.add("ro");
        this.availableAmberscriptLangs.add("ru");
        this.availableAmberscriptLangs.add("sr-rs");
        this.availableAmberscriptLangs.add("si-lk");
        this.availableAmberscriptLangs.add("sk");
        this.availableAmberscriptLangs.add("sl");
        this.availableAmberscriptLangs.add("es");
        this.availableAmberscriptLangs.add("su-id");
        this.availableAmberscriptLangs.add("sw-ke");
        this.availableAmberscriptLangs.add("sw-tz");
        this.availableAmberscriptLangs.add("sv");
        this.availableAmberscriptLangs.add("ta-in");
        this.availableAmberscriptLangs.add("ta-my");
        this.availableAmberscriptLangs.add("ta-sg");
        this.availableAmberscriptLangs.add("ta-lk");
        this.availableAmberscriptLangs.add("te-in");
        this.availableAmberscriptLangs.add("th-th");
        this.availableAmberscriptLangs.add("tr");
        this.availableAmberscriptLangs.add("uk-ua");
        this.availableAmberscriptLangs.add("ur-in");
        this.availableAmberscriptLangs.add("ur-pk");
        this.availableAmberscriptLangs.add("uz-uz");
        this.availableAmberscriptLangs.add("vi-vn");
        this.availableAmberscriptLangs.add("zu-za");
        for (String amberLang : this.availableAmberscriptLangs) {
            if (!amberLang.contains("-")) continue;
            this.addAmberLangToMap(amberLang);
        }
        for (String amberLang : this.availableAmberscriptLangs) {
            if (amberLang.contains("-")) continue;
            this.addAmberLangToMap(amberLang);
        }
    }

    private void addAmberLangToMap(String amberLang) {
        Locale locale = amberLang.contains("-") ? Locale.forLanguageTag(amberLang) : Locale.forLanguageTag(amberLang + "-" + amberLang);
        if (locale.getDisplayCountry().equals("")) {
            logger.warn("Locale not found for code '{}'", (Object)amberLang);
            return;
        }
        this.langMap.put(amberLang, amberLang);
        this.langMap.put(locale.toString().toLowerCase(), amberLang);
        this.langMap.put(locale.getDisplayLanguage().toLowerCase(), amberLang);
        this.langMap.put(locale.getDisplayName().toLowerCase(), amberLang);
        this.langMap.put(locale.getLanguage().toLowerCase(), amberLang);
        this.langMap.put(locale.getISO3Language().toLowerCase(), amberLang);
    }

    public String getLanguageCodeOrNull(String languageWithRandomFormat) {
        return this.langMap.get(languageWithRandomFormat.toLowerCase());
    }

    public void addCustomMapping(String customKey, String amberscriptLangCode) {
        this.langMap.put(customKey, amberscriptLangCode);
    }
}

