/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.transcription.amberscript;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.assetmanager.util.Workflows;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.security.api.DefaultOrganization;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.transcription.amberscript.AmberscriptLangUtil;
import org.opencastproject.transcription.api.TranscriptionService;
import org.opencastproject.transcription.api.TranscriptionServiceException;
import org.opencastproject.transcription.persistence.TranscriptionDatabase;
import org.opencastproject.transcription.persistence.TranscriptionDatabaseException;
import org.opencastproject.transcription.persistence.TranscriptionJobControl;
import org.opencastproject.transcription.persistence.TranscriptionProviderControl;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDefinition;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowService;
import org.opencastproject.workingfilerepository.api.WorkingFileRepository;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TranscriptionService.class, AmberscriptTranscriptionService.class}, property={"service.description=AmberScript Transcription Service", "provider=amberscript"})
public class AmberscriptTranscriptionService
extends AbstractJobProducer
implements TranscriptionService {
    private static final Logger logger = LoggerFactory.getLogger(AmberscriptTranscriptionService.class);
    private static final String JOB_TYPE = "org.opencastproject.transcription.amberscript";
    public static final String SUBMISSION_COLLECTION = "amberscript-submission";
    private static final String TRANSCRIPT_COLLECTION = "amberscript-transcripts";
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 60000;
    private static final String BASE_URL = "https://qs.amberscript.com";
    private static final String STATUS_OPEN = "OPEN";
    private static final String STATUS_DONE = "DONE";
    private static final String STATUS_ERROR = "ERROR";
    private static final String ERROR_NO_SPEECH = "No speech found";
    private static final String PROVIDER = "amberscript";
    private AssetManager assetManager;
    private OrganizationDirectoryService organizationDirectoryService;
    private ScheduledExecutorService scheduledExecutor;
    private SecurityService securityService;
    private ServiceRegistry serviceRegistry;
    private TranscriptionDatabase database;
    private UserDirectoryService userDirectoryService;
    private WorkflowService workflowService;
    private WorkingFileRepository wfr;
    private Workspace workspace;
    private Workflows wfUtil;
    private static final String ENABLED_CONFIG = "enabled";
    private static final String CLIENT_KEY = "client.key";
    private static final String LANGUAGE = "language";
    private static final String LANGUAGE_FROM_DUBLINCORE = "language.from.dublincore";
    private static final String LANGUAGE_CODE_MAP = "language.code.map";
    private static final String AMBERSCRIPTJOBTYPE = "jobtype";
    private static final String WORKFLOW_CONFIG = "workflow";
    private static final String DISPATCH_WORKFLOW_INTERVAL_CONFIG = "workflow.dispatch.interval";
    private static final String MAX_PROCESSING_TIME_CONFIG = "max.overdue.time";
    private static final String CLEANUP_RESULTS_DAYS_CONFIG = "cleanup.results.days";
    private static final String SPEAKER = "speaker";
    private static final String SPEAKER_FROM_DUBLINCORE = "speaker.from.dublincore";
    private static final String SPEAKER_METADATA_FIELD = "speaker.metadata.field";
    private static final String TRANSCRIPTIONTYPE = "transcriptiontype";
    private static final String GLOSSARY = "glossary";
    private static final String TRANSCRIPTIONSTYLE = "cleanread";
    private static final String TARGETLANGUAGE = "targetlanguage";
    private boolean enabled = false;
    private String clientKey;
    private String language = "en";
    private boolean languageFromDublinCore;
    private String amberscriptJobType = "direct";
    private String workflowDefinitionId = "amberscript-attach-transcripts";
    private long workflowDispatchIntervalSeconds = 60L;
    private long maxProcessingSeconds = 691200L;
    private int cleanupResultDays = 7;
    private int numberOfSpeakers = 1;
    private boolean speakerFromDublinCore = true;
    private SpeakerMetadataField speakerMetadataField = SpeakerMetadataField.creator;
    private String transcriptionType = "transcription";
    private String glossary = "";
    private String transcriptionStyle = "cleanread";
    private String targetLanguage = "";
    private AmberscriptLangUtil amberscriptLangUtil;
    private String systemAccount;

    public AmberscriptTranscriptionService() {
        super(JOB_TYPE);
    }

    @Activate
    public void activate(ComponentContext cc) {
        Option enabledOpt = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)ENABLED_CONFIG);
        if (enabledOpt.isSome()) {
            this.enabled = (Boolean)enabledOpt.get();
        }
        if (!this.enabled) {
            logger.info("Amberscript Transcription Service disabled. If you want to enable it, please update the service configuration.");
            return;
        }
        Option clientKeyOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)CLIENT_KEY);
        if (!clientKeyOpt.isSome()) {
            logger.warn("API key was not set.");
            return;
        }
        this.clientKey = (String)clientKeyOpt.get();
        Option languageOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)LANGUAGE);
        if (languageOpt.isSome()) {
            this.language = (String)languageOpt.get();
            logger.info("Default language is set to '{}'.", (Object)this.language);
        } else {
            logger.info("Default language '{}' will be used.", (Object)this.language);
        }
        Option languageFromDublinCoreOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)LANGUAGE_FROM_DUBLINCORE);
        if (languageFromDublinCoreOpt.isSome()) {
            try {
                this.languageFromDublinCore = Boolean.parseBoolean((String)languageFromDublinCoreOpt.get());
            }
            catch (Exception e) {
                logger.warn("Configuration value for '{}' is invalid, defaulting to false.", (Object)LANGUAGE_FROM_DUBLINCORE);
            }
        }
        logger.info("Configuration value for '{}' is set to '{}'.", (Object)LANGUAGE_FROM_DUBLINCORE, (Object)this.languageFromDublinCore);
        this.amberscriptLangUtil = AmberscriptLangUtil.getInstance();
        int customMapEntriesCount = 0;
        Option langCodeMapOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)LANGUAGE_CODE_MAP);
        if (langCodeMapOpt.isSome()) {
            try {
                String langCodeMapStr = (String)langCodeMapOpt.get();
                if (langCodeMapStr != null) {
                    for (String mapping : langCodeMapStr.split(",")) {
                        String[] mapEntries = mapping.split(":");
                        this.amberscriptLangUtil.addCustomMapping(mapEntries[0], mapEntries[1]);
                        ++customMapEntriesCount;
                    }
                }
            }
            catch (Exception e) {
                logger.warn("Configuration '{}' is invalid. Using just default mapping.", (Object)LANGUAGE_CODE_MAP);
            }
        }
        logger.info("Language code map was set. Added '{}' additional entries.", (Object)customMapEntriesCount);
        Option amberscriptJobTypeOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)AMBERSCRIPTJOBTYPE);
        if (amberscriptJobTypeOpt.isSome()) {
            this.amberscriptJobType = (String)amberscriptJobTypeOpt.get();
            logger.info("Default Amberscript job type is set to '{}'.", (Object)this.amberscriptJobType);
        } else {
            logger.info("Default Amberscript job type '{}' will be used.", (Object)this.amberscriptJobType);
        }
        Option wfOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WORKFLOW_CONFIG);
        if (wfOpt.isSome()) {
            this.workflowDefinitionId = (String)wfOpt.get();
            logger.info("Workflow is set to '{}'.", (Object)this.workflowDefinitionId);
        } else {
            logger.info("Default workflow '{}' will be used.", (Object)this.workflowDefinitionId);
        }
        Option intervalOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)DISPATCH_WORKFLOW_INTERVAL_CONFIG);
        if (intervalOpt.isSome()) {
            try {
                this.workflowDispatchIntervalSeconds = Long.parseLong((String)intervalOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Configured '{}' is invalid. Using default.", (Object)DISPATCH_WORKFLOW_INTERVAL_CONFIG);
            }
        }
        logger.info("Workflow dispatch interval is {} seconds.", (Object)this.workflowDispatchIntervalSeconds);
        Option maxProcessingOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)MAX_PROCESSING_TIME_CONFIG);
        if (maxProcessingOpt.isSome()) {
            try {
                this.maxProcessingSeconds = Long.parseLong((String)maxProcessingOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Configured '{}' is invalid. Using default.", (Object)MAX_PROCESSING_TIME_CONFIG);
            }
        }
        logger.info("Maximum processing time for transcription job is {} seconds.", (Object)this.maxProcessingSeconds);
        Option cleanupOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)CLEANUP_RESULTS_DAYS_CONFIG);
        if (cleanupOpt.isSome()) {
            try {
                this.cleanupResultDays = Integer.parseInt((String)cleanupOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Configured '{}' is invalid. Using default.", (Object)CLEANUP_RESULTS_DAYS_CONFIG);
            }
        }
        logger.info("Cleanup result files after {} days.", (Object)this.cleanupResultDays);
        Option speakerOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)SPEAKER);
        if (speakerOpt.isSome()) {
            try {
                this.numberOfSpeakers = Integer.parseInt((String)speakerOpt.get());
            }
            catch (NumberFormatException e) {
                logger.warn("Configured '{}' is invalid. Using default.", (Object)SPEAKER);
            }
        }
        logger.info("Default number of speakers is set to '{}'.", (Object)this.numberOfSpeakers);
        Option speakerFromDublinCoreOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)SPEAKER_FROM_DUBLINCORE);
        if (speakerFromDublinCoreOpt.isSome()) {
            try {
                this.speakerFromDublinCore = Boolean.parseBoolean((String)speakerFromDublinCoreOpt.get());
            }
            catch (Exception e) {
                logger.warn("Configuration value for '{}' is invalid, defaulting to true.", (Object)SPEAKER_FROM_DUBLINCORE);
            }
        }
        logger.info("Configuration value for '{}' is set to '{}'.", (Object)SPEAKER_FROM_DUBLINCORE, (Object)this.speakerFromDublinCore);
        Option speakerMetadataFieldOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)SPEAKER_METADATA_FIELD);
        if (speakerMetadataFieldOpt.isSome()) {
            try {
                this.speakerMetadataField = SpeakerMetadataField.valueOf((String)speakerMetadataFieldOpt.get());
            }
            catch (IllegalArgumentException e) {
                logger.warn("Value '{}' is invalid for configuration '{}'. Using default: '{}'.", new Object[]{speakerMetadataFieldOpt.get(), SPEAKER_METADATA_FIELD, this.speakerMetadataField});
            }
        }
        logger.info("Default metadata field for calculating the amount of speakers is set to '{}'.", (Object)this.speakerMetadataField);
        Option transcriptionTypeOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)TRANSCRIPTIONTYPE);
        if (transcriptionTypeOpt.isSome()) {
            if (List.of("transcription", "captions", "translatedSubtitles").contains(this.transcriptionType)) {
                this.transcriptionType = (String)transcriptionTypeOpt.get();
                logger.info("Default transcription type is set to '{}'.", (Object)this.transcriptionType);
            } else {
                logger.warn("Value '{}' is invalid for configuration '{}'. Using default: '{}'.", new Object[]{transcriptionTypeOpt.get(), TRANSCRIPTIONTYPE, this.transcriptionType});
            }
        } else {
            logger.info("Default transcription type '{}' will be used.", (Object)this.transcriptionType);
        }
        Option glossaryOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)GLOSSARY);
        if (glossaryOpt.isSome()) {
            this.glossary = (String)glossaryOpt.get();
            logger.info("Default glossary is set to '{}'.", (Object)this.glossary);
        } else {
            logger.info("No glossary will be used by default");
        }
        Option transcriptionStyleOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)TRANSCRIPTIONSTYLE);
        if (transcriptionStyleOpt.isSome()) {
            if (List.of(TRANSCRIPTIONSTYLE, "verbatim").contains(this.transcriptionStyle)) {
                this.transcriptionStyle = (String)transcriptionStyleOpt.get();
                logger.info("Default transcription style is set to '{}'.", (Object)this.transcriptionStyle);
            } else {
                logger.warn("Value '{}' is invalid for configuration '{}'. Using default: '{}'.", new Object[]{transcriptionStyleOpt.get(), TRANSCRIPTIONSTYLE, this.transcriptionStyle});
            }
        } else {
            logger.info("Default transcription style '{}' will be used.", (Object)this.transcriptionStyle);
        }
        Option targetLanguageOpt = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)TARGETLANGUAGE);
        if (targetLanguageOpt.isSome()) {
            this.targetLanguage = (String)targetLanguageOpt.get();
            logger.info("Default target language is set to '{}'.", (Object)this.targetLanguage);
        } else {
            logger.info("Transcriptions won't be translated");
        }
        this.systemAccount = OsgiUtil.getContextProperty((ComponentContext)cc, (String)"org.opencastproject.security.digest.user");
        this.scheduledExecutor = Executors.newScheduledThreadPool(2);
        this.scheduledExecutor.scheduleWithFixedDelay(new WorkflowDispatcher(), 120L, this.workflowDispatchIntervalSeconds, TimeUnit.SECONDS);
        this.scheduledExecutor.scheduleWithFixedDelay(new ResultsFileCleanup(), 1L, 1L, TimeUnit.DAYS);
        logger.info("Activated.");
    }

    @Deactivate
    public void deactivate() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    public Job startTranscription(String mpId, Track track) throws TranscriptionServiceException {
        throw new UnsupportedOperationException("Not supported.");
    }

    /*
     * WARNING - void declaration
     */
    public Job startTranscription(String mpId, Track track, String ... args) throws TranscriptionServiceException {
        void var8_15;
        int numberOfSpeakers;
        String jobType;
        String language;
        block34: {
            if (!this.enabled) {
                throw new TranscriptionServiceException("AmberScript Transcription Service disabled. If you want to enable it, please update the service configuration.");
            }
            language = null;
            if (this.languageFromDublinCore) {
                for (Catalog catalog : track.getMediaPackage().getCatalogs(MediaPackageElements.EPISODE)) {
                    try (InputStream in = this.workspace.read(catalog.getURI());){
                        DublinCoreCatalog dublinCatalog = DublinCores.read((InputStream)in);
                        String dublinCoreLang = dublinCatalog.getFirst(DublinCore.PROPERTY_LANGUAGE);
                        if (dublinCoreLang != null) {
                            language = this.amberscriptLangUtil.getLanguageCodeOrNull(dublinCoreLang);
                        }
                        if (language == null) continue;
                        break;
                    }
                    catch (IOException | NotFoundException e) {
                        logger.error(String.format("Unable to load dublin core catalog for event '%s'", track.getMediaPackage().getIdentifier()), e);
                    }
                }
            }
            if (language == null) {
                language = args.length > 0 && StringUtils.isNotBlank((CharSequence)args[0]) ? args[0] : this.getLanguage();
            }
            jobType = args.length > 1 && StringUtils.isNotBlank((CharSequence)args[1]) ? args[1] : this.getAmberscriptJobType();
            numberOfSpeakers = 0;
            if (!this.speakerFromDublinCore) break block34;
            HashSet speakers = new HashSet();
            for (Catalog catalog : track.getMediaPackage().getCatalogs(MediaPackageElements.EPISODE)) {
                try (InputStream in = this.workspace.read(catalog.getURI());){
                    DublinCoreCatalog dublinCatalog;
                    block36: {
                        block35: {
                            dublinCatalog = DublinCores.read((InputStream)in);
                            if (this.speakerMetadataField.equals((Object)SpeakerMetadataField.creator)) break block35;
                            if (!this.speakerMetadataField.equals((Object)SpeakerMetadataField.both)) break block36;
                        }
                        dublinCatalog.get(DublinCore.PROPERTY_CREATOR).stream().map(DublinCoreValue::getValue).forEach(speakers::add);
                    }
                    if (!this.speakerMetadataField.equals((Object)SpeakerMetadataField.contributor)) {
                        if (!this.speakerMetadataField.equals((Object)SpeakerMetadataField.both)) continue;
                    }
                    dublinCatalog.get(DublinCore.PROPERTY_CONTRIBUTOR).stream().map(DublinCoreValue::getValue).forEach(speakers::add);
                }
                catch (IOException | NotFoundException e) {
                    logger.error("Unable to load dublin core catalog for event '{}'", (Object)track.getMediaPackage().getIdentifier(), (Object)e);
                }
            }
            if (speakers.size() >= 1) {
                numberOfSpeakers = speakers.size();
            }
        }
        if (numberOfSpeakers == 0) {
            numberOfSpeakers = args.length > 2 && StringUtils.isNotBlank((CharSequence)args[2]) ? Integer.parseInt(args[2]) : this.getNumberOfSpeakers();
        }
        String transcriptionType = args.length > 3 && StringUtils.isNotBlank((CharSequence)args[3]) ? args[3] : this.getTranscriptionType();
        if (args.length > 4 && args[4] != null) {
            String string = args[4];
        } else {
            String string = this.getGlossary();
        }
        String transcriptionStyle = args.length > 5 && StringUtils.isNotBlank((CharSequence)args[5]) ? args[5] : this.getTranscriptionStyle();
        String targetLanguage = args.length > 6 && args[6] != null ? args[6] : this.getTargetLanguage();
        logger.info("New transcription job for mpId '{}' language '{}' job type '{}' speakers '{}' transcription type '{}'glossary '{}'.", new Object[]{mpId, language, jobType, numberOfSpeakers, transcriptionType, var8_15});
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.StartTranscription.name(), Arrays.asList(mpId, MediaPackageElementParser.getAsXml((MediaPackageElement)track), language, jobType, Integer.toString(numberOfSpeakers), transcriptionType, var8_15, transcriptionStyle, targetLanguage));
        }
        catch (ServiceRegistryException e) {
            throw new TranscriptionServiceException("Unable to create a job", (Throwable)e);
        }
        catch (MediaPackageException e) {
            throw new TranscriptionServiceException("Invalid track '" + track.toString() + "'", (Throwable)e);
        }
    }

    public void transcriptionDone(String mpId, Object results) {
    }

    private void transcriptionDone(String mpId, String jobId) {
        try {
            logger.info("Transcription done for mpId '{}'.", (Object)mpId);
            if (this.getAndSaveJobResult(jobId)) {
                this.database.updateJobControl(jobId, TranscriptionJobControl.Status.TranscriptionComplete.name());
            } else {
                logger.debug("Unable to get and save the transcription result for mpId '{}'.", (Object)mpId);
            }
        }
        catch (IOException | TranscriptionServiceException e) {
            logger.warn("Could not save transcription results file for mpId '{}': {}", (Object)mpId, (Object)e.toString());
        }
        catch (TranscriptionDatabaseException e) {
            logger.warn("Transcription results file were saved but state in db not updated for mpId '{}': ", (Object)mpId, (Object)e);
        }
    }

    public void transcriptionError(String mpId, Object obj) throws TranscriptionServiceException {
        JSONObject jsonObj = null;
        String jobId = null;
        try {
            jsonObj = (JSONObject)obj;
            jobId = (String)jsonObj.get((Object)"name");
            this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Error.name());
            TranscriptionJobControl jobControl = this.database.findByJob(jobId);
            logger.warn(String.format("Error received for media package %s, job id %s", jobControl.getMediaPackageId(), jobId));
        }
        catch (TranscriptionDatabaseException e) {
            logger.warn("Transcription error. State in db could not be updated to error for mpId {}, jobId {}", (Object)mpId, jobId);
            throw new TranscriptionServiceException("Could not update transcription job control db", (Throwable)e);
        }
    }

    public Map<String, Object> getReturnValues(String mpId, String jobId) throws TranscriptionServiceException {
        throw new TranscriptionServiceException("Method not implemented");
    }

    public String getLanguage() {
        return this.language;
    }

    public String getAmberscriptJobType() {
        return this.amberscriptJobType;
    }

    public int getNumberOfSpeakers() {
        return this.numberOfSpeakers;
    }

    public String getTranscriptionType() {
        return this.transcriptionType;
    }

    public String getGlossary() {
        return this.glossary;
    }

    public String getTranscriptionStyle() {
        return this.transcriptionStyle;
    }

    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        String result = "";
        op = Operation.valueOf(operation);
        switch (op) {
            case StartTranscription: {
                String mpId = (String)arguments.get(0);
                Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(1)));
                String languageCode = (String)arguments.get(2);
                String jobType = (String)arguments.get(3);
                String numberOfSpeakers = (String)arguments.get(4);
                String transcriptionType = (String)arguments.get(5);
                String glossary = (String)arguments.get(6);
                String transcriptionStyle = (String)arguments.get(7);
                String targetLanguage = (String)arguments.get(8);
                this.createRecognitionsJob(mpId, track, languageCode, jobType, numberOfSpeakers, transcriptionType, glossary, transcriptionStyle, targetLanguage);
                break;
            }
            default: {
                throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
            }
        }
        return result;
    }

    void createRecognitionsJob(String mpId, Track track, String languageCode, String jobType, String numberOfSpeakers, String transcriptionType, String glossary, String transcriptionStyle, String targetLanguage) throws TranscriptionServiceException {
        CloseableHttpClient httpClient = this.makeHttpClient(10800000);
        CloseableHttpResponse response = null;
        String submitUrl = "https://qs.amberscript.com/jobs/upload-media?apiKey=" + this.clientKey + "&language=" + languageCode + "&jobType=" + jobType + "&numberOfSpeakers=" + numberOfSpeakers + "&transcriptionType=" + transcriptionType + "&transcriptionStyle=" + transcriptionStyle;
        if (StringUtils.isNotBlank((CharSequence)glossary)) {
            submitUrl = submitUrl + "&glossary=" + glossary;
        }
        if (StringUtils.isNotBlank((CharSequence)targetLanguage)) {
            submitUrl = submitUrl + "&targetLanguage=" + targetLanguage;
        }
        try {
            FileBody fileBody = new FileBody(this.workspace.get(track.getURI()), ContentType.DEFAULT_BINARY);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            builder.addPart("file", (ContentBody)fileBody);
            HttpEntity multipartEntity = builder.build();
            HttpPost httpPost = new HttpPost(submitUrl);
            httpPost.setEntity(multipartEntity);
            response = httpClient.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String jsonString = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonString);
            logger.debug("Submitting new transcription job: {}" + System.lineSeparator() + "Response: {}", (Object)this.removePrivateInfo(submitUrl), (Object)jsonString);
            JSONObject result = (JSONObject)jsonObject.get((Object)"jobStatus");
            String jobId = (String)result.get((Object)"jobId");
            switch (code) {
                case 200: {
                    logger.info("mp {} has been submitted to AmberScript service with jobId {}.", (Object)mpId, (Object)jobId);
                    this.database.storeJobControl(mpId, track.getIdentifier(), jobId, TranscriptionJobControl.Status.InProgress.name(), track.getDuration() == null ? 0L : track.getDuration(), new Date(), PROVIDER);
                    EntityUtils.consume((HttpEntity)entity);
                    return;
                }
            }
            try {
                String error = (String)result.get((Object)"error");
                String message = (String)result.get((Object)"message");
                String msg = String.format("Unable to submit job: API returned %s - %s: %s", code, error, message);
                logger.warn(msg);
                throw new TranscriptionServiceException(msg);
            }
            catch (Exception e) {
                logger.warn("Exception when calling the captions endpoint", (Throwable)e);
                throw new TranscriptionServiceException("Exception when calling the captions endpoint", (Throwable)e);
            }
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean checkJobResults(String jobId) throws TranscriptionServiceException {
        String mpId = "unknown";
        CloseableHttpClient httpClient = this.makeHttpClient();
        CloseableHttpResponse response = null;
        String checkUrl = "https://qs.amberscript.com/jobs/status?jobId=" + jobId + "&apiKey=" + this.clientKey;
        try {
            HttpGet httpGet = new HttpGet(checkUrl);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int code = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String jsonString = EntityUtils.toString((HttpEntity)entity);
            EntityUtils.consume((HttpEntity)entity);
            logger.debug("AmberScript API call was '{}'." + System.lineSeparator() + "Response: {}", (Object)this.removePrivateInfo(checkUrl), (Object)jsonString);
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObject = (JSONObject)jsonParser.parse(jsonString);
            switch (code) {
                case 200: {
                    String status;
                    JSONObject result = (JSONObject)jsonObject.get((Object)"jobStatus");
                    switch (status = (String)result.get((Object)"status")) {
                        case "OPEN": {
                            logger.debug("Captions job '{}' has not finished yet.", (Object)jobId);
                            boolean bl = false;
                            return bl;
                        }
                        case "ERROR": {
                            String errorMsg = (String)result.get((Object)"errorMsg");
                            throw new TranscriptionServiceException(String.format("Captions job '%s' failed: %s", jobId, errorMsg), code, ERROR_NO_SPEECH.equals(errorMsg));
                        }
                        case "DONE": {
                            logger.info("Captions job '{}' has finished.", (Object)jobId);
                            TranscriptionJobControl jc = this.database.findByJob(jobId);
                            if (jc != null) {
                                mpId = jc.getMediaPackageId();
                            }
                            this.transcriptionDone(mpId, jobId);
                            boolean bl = true;
                            return bl;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            String error = (String)jsonObject.get((Object)"error");
            String errorMessage = (String)jsonObject.get((Object)"errorMessage");
            logger.warn("Error while checking status: {}." + System.lineSeparator() + "{}: {}", new Object[]{code, error, errorMessage});
            throw new TranscriptionServiceException(String.format("Captions job '%s' failed: Return Code %d", jobId, code), code);
        }
        catch (IOException | ParseException | TranscriptionDatabaseException e) {
            logger.warn("Error while checking status: {}", (Object)e.toString());
            return false;
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getAndSaveJobResult(String jobId) throws TranscriptionServiceException, IOException {
        CloseableHttpClient httpClient = this.makeHttpClient();
        CloseableHttpResponse response = null;
        String transcriptUrl = "https://qs.amberscript.com/jobs/export?format=srt&jobId=" + jobId + "&apiKey=" + this.clientKey;
        boolean done = false;
        try {
            HttpGet httpGet = new HttpGet(transcriptUrl);
            response = httpClient.execute((HttpUriRequest)httpGet);
            int code = response.getStatusLine().getStatusCode();
            logger.debug("AmberScript API {} http response {}", (Object)this.removePrivateInfo(transcriptUrl), (Object)code);
            switch (code) {
                case 200: {
                    HttpEntity entity = response.getEntity();
                    logger.info("Retrieved details for transcription with jobid: '{}'", (Object)jobId);
                    this.workspace.putInCollection(TRANSCRIPT_COLLECTION, jobId + ".srt", entity.getContent());
                    done = true;
                    return done;
                }
                default: {
                    logger.warn("Error retrieving details for transcription with jobid: '{}', return status: {}.", (Object)jobId, (Object)code);
                    return done;
                }
            }
        }
        catch (Exception e) {
            throw new TranscriptionServiceException(String.format("Exception when calling the transcription service for jobid: %s", jobId), (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public MediaPackageElement getGeneratedTranscription(String mpId, String jobId, MediaPackageElement.Type type) throws TranscriptionServiceException {
        try {
            if (jobId == null || "null".equals(jobId)) {
                jobId = null;
                for (TranscriptionJobControl jc : this.database.findByMediaPackage(mpId)) {
                    if (!TranscriptionJobControl.Status.Closed.name().equals(jc.getStatus()) && !TranscriptionJobControl.Status.TranscriptionComplete.name().equals(jc.getStatus())) continue;
                    jobId = jc.getTranscriptionJobId();
                }
            }
            if (jobId == null) {
                throw new TranscriptionServiceException("No completed or closed transcription job found in database for media package " + mpId);
            }
            URI uri = this.workspace.getCollectionURI(TRANSCRIPT_COLLECTION, jobId + ".srt");
            logger.info("Looking for transcript at URI: {}", (Object)uri);
            try {
                this.workspace.get(uri);
                logger.info("Found captions at URI: {}", (Object)uri);
            }
            catch (Exception e) {
                logger.info("Results not saved: getting from service for jobId {}", (Object)jobId);
                this.checkJobResults(jobId);
            }
            MediaPackageElementBuilder builder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            logger.debug("Returning MPE with results file URI: {}", (Object)uri);
            return builder.elementFromURI(uri, type, new MediaPackageElementFlavor("captions", "srt"));
        }
        catch (TranscriptionDatabaseException e) {
            throw new TranscriptionServiceException("Job id not informed and could not find transcription", (Throwable)e);
        }
    }

    public String getTranscriptionStatus(String mpId) throws TranscriptionServiceException {
        try {
            Iterator iterator = this.database.findByMediaPackage(mpId).iterator();
            if (iterator.hasNext()) {
                TranscriptionJobControl jc = (TranscriptionJobControl)iterator.next();
                return jc.getStatus();
            }
        }
        catch (TranscriptionDatabaseException e) {
            throw new TranscriptionServiceException("Mediapackage id transcription status unknown", (Throwable)e);
        }
        return "Unknown";
    }

    protected CloseableHttpClient makeHttpClient() {
        return this.makeHttpClient(60000);
    }

    protected CloseableHttpClient makeHttpClient(int socketTimeout) {
        RequestConfig reqConfig = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(socketTimeout).setConnectionRequestTimeout(60000).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().useSystemProperties().setDefaultRequestConfig(reqConfig).build();
        return httpClient;
    }

    protected void deleteStorageFile(String filename) {
        try {
            logger.debug("Removing {} from collection {}.", (Object)filename, (Object)SUBMISSION_COLLECTION);
            this.wfr.deleteFromCollection(SUBMISSION_COLLECTION, filename, false);
        }
        catch (IOException e) {
            logger.warn("Unable to remove submission file {} from collection {}", (Object)filename, (Object)SUBMISSION_COLLECTION);
        }
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setWorkspace(Workspace ws) {
        this.workspace = ws;
    }

    @Reference
    public void setWorkingFileRepository(WorkingFileRepository wfr) {
        this.wfr = wfr;
    }

    @Reference
    public void setDatabase(TranscriptionDatabase service) {
        this.database = service;
    }

    @Reference
    public void setAssetManager(AssetManager service) {
        this.assetManager = service;
    }

    @Reference
    public void setWorkflowService(WorkflowService service) {
        this.workflowService = service;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    void setWfUtil(Workflows wfUtil) {
        this.wfUtil = wfUtil;
    }

    private String removePrivateInfo(String unsafeString) {
        String safeString = unsafeString.replace(this.clientKey, "__api-key-was-hidden__");
        return safeString;
    }

    class ResultsFileCleanup
    implements Runnable {
        ResultsFileCleanup() {
        }

        @Override
        public void run() {
            logger.info("ResultsFileCleanup waking up...");
            try {
                AmberscriptTranscriptionService.this.wfr.cleanupOldFilesFromCollection(AmberscriptTranscriptionService.TRANSCRIPT_COLLECTION, (long)AmberscriptTranscriptionService.this.cleanupResultDays);
                AmberscriptTranscriptionService.this.wfr.cleanupOldFilesFromCollection(AmberscriptTranscriptionService.SUBMISSION_COLLECTION, (long)AmberscriptTranscriptionService.this.cleanupResultDays);
            }
            catch (IOException e) {
                logger.warn("Could not cleanup old submission and transcript results files", (Throwable)e);
            }
        }
    }

    class WorkflowDispatcher
    implements Runnable {
        WorkflowDispatcher() {
        }

        @Override
        public void run() {
            logger.debug("WorkflowDispatcher waking up...");
            try {
                TranscriptionProviderControl providerInfo = AmberscriptTranscriptionService.this.database.findIdByProvider(AmberscriptTranscriptionService.PROVIDER);
                if (providerInfo == null) {
                    logger.debug("No jobs yet for provider {}.", (Object)AmberscriptTranscriptionService.PROVIDER);
                    return;
                }
                long providerId = providerInfo.getId();
                List jobs = AmberscriptTranscriptionService.this.database.findByStatus(new String[]{TranscriptionJobControl.Status.InProgress.name(), TranscriptionJobControl.Status.TranscriptionComplete.name()});
                for (TranscriptionJobControl j : jobs) {
                    if (j.getProviderId() != providerId) continue;
                    String mpId = j.getMediaPackageId();
                    String jobId = j.getTranscriptionJobId();
                    if (TranscriptionJobControl.Status.InProgress.name().equals(j.getStatus())) {
                        if (j.getDateExpected().getTime() >= System.currentTimeMillis()) continue;
                        try {
                            if (!AmberscriptTranscriptionService.this.checkJobResults(jobId)) {
                                if (j.getDateExpected().getTime() + AmberscriptTranscriptionService.this.maxProcessingSeconds * 1000L >= System.currentTimeMillis()) continue;
                                AmberscriptTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Canceled.name());
                                continue;
                            }
                        }
                        catch (TranscriptionServiceException e) {
                            try {
                                AmberscriptTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Canceled.name());
                                continue;
                            }
                            catch (TranscriptionDatabaseException ex) {
                                logger.warn("Could not cancel job '{}'.", (Object)jobId);
                            }
                        }
                    }
                    try {
                        DefaultOrganization defaultOrg = new DefaultOrganization();
                        AmberscriptTranscriptionService.this.securityService.setOrganization((Organization)defaultOrg);
                        AmberscriptTranscriptionService.this.securityService.setUser(SecurityUtil.createSystemUser((String)AmberscriptTranscriptionService.this.systemAccount, (Organization)defaultOrg));
                        AQueryBuilder q = AmberscriptTranscriptionService.this.assetManager.createQuery();
                        AResult r = q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId).and(q.version().isLatest())).run();
                        if (r.getSize() == 0L) {
                            logger.warn("Media package {} no longer exists in the asset manager. It was likely deleted. Dropping the generated transcription.", (Object)mpId);
                            AmberscriptTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Error.name());
                            continue;
                        }
                        String org = ((Snapshot)Enrichments.enrich((AResult)r).getSnapshots().stream().findFirst().get()).getOrganizationId();
                        Organization organization = AmberscriptTranscriptionService.this.organizationDirectoryService.getOrganization(org);
                        if (organization == null) {
                            logger.warn("Media package {} has an unknown organization {}. Skipped.", (Object)mpId, (Object)org);
                            continue;
                        }
                        AmberscriptTranscriptionService.this.securityService.setOrganization(organization);
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("transcriptionJobId", jobId);
                        WorkflowDefinition wfDef = AmberscriptTranscriptionService.this.workflowService.getWorkflowDefinitionById(AmberscriptTranscriptionService.this.workflowDefinitionId);
                        Workflows workflows = AmberscriptTranscriptionService.this.wfUtil != null ? AmberscriptTranscriptionService.this.wfUtil : new Workflows(AmberscriptTranscriptionService.this.assetManager, AmberscriptTranscriptionService.this.workflowService);
                        HashSet<String> mpIds = new HashSet<String>();
                        mpIds.add(mpId);
                        List wfList = workflows.applyWorkflowToLatestVersion(mpIds, ConfiguredWorkflow.workflow((WorkflowDefinition)wfDef, params)).toList();
                        String wfId = wfList.size() > 0 ? Long.toString(((WorkflowInstance)wfList.get(0)).getId()) : "Unknown";
                        AmberscriptTranscriptionService.this.database.updateJobControl(jobId, TranscriptionJobControl.Status.Closed.name());
                        logger.info("Attach transcription workflow {} scheduled for mp {}, transcription service job {}", new Object[]{wfId, mpId, jobId});
                    }
                    catch (Exception e) {
                        logger.warn("Attach transcription workflow could NOT be scheduled for mp {}, amberscript job {}, {}: {}", new Object[]{mpId, jobId, e.getClass().getName(), e.getMessage()});
                    }
                }
            }
            catch (TranscriptionDatabaseException e) {
                logger.warn("Could not read transcription job control database: {}", (Object)e.getMessage());
            }
        }
    }

    private static enum SpeakerMetadataField {
        creator,
        contributor,
        both;

    }

    private static enum Operation {
        StartTranscription;

    }
}

