/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.timelinepreviews;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsException;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsService;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Timeline Preview Images Workflow Operation Handler", "workflow.operation=timelinepreviews"})
public class TimelinePreviewsWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(TimelinePreviewsWorkflowOperationHandler.class);
    private static final String SOURCE_FLAVOR_PROPERTY = "source-flavor";
    private static final String SOURCE_TAGS_PROPERTY = "source-tags";
    private static final String TARGET_FLAVOR_PROPERTY = "target-flavor";
    private static final String TARGET_TAGS_PROPERTY = "target-tags";
    private static final String PROCCESS_FIRST_MATCH = "process-first-match-only";
    private static final String IMAGE_SIZE_PROPERTY = "image-count";
    private static final int DEFAULT_IMAGE_SIZE = 10;
    private TimelinePreviewsService timelinePreviewsService = null;
    private Workspace workspace = null;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering timeline previews workflow operation handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        int imageSize;
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Start timeline previews workflow operation for mediapackage {}", (Object)mediaPackage.getIdentifier().toString());
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        List sourceFlavorProperty = tagsAndFlavors.getSrcFlavors();
        List sourceTagsProperty = tagsAndFlavors.getSrcTags();
        if (sourceFlavorProperty.isEmpty() && sourceTagsProperty.isEmpty()) {
            throw new WorkflowOperationException(String.format("Required property %s or %s not set", SOURCE_FLAVOR_PROPERTY, SOURCE_TAGS_PROPERTY));
        }
        MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor();
        List targetTagsProperty = tagsAndFlavors.getTargetTags();
        String imageSizeArg = StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(IMAGE_SIZE_PROPERTY));
        if (imageSizeArg != null) {
            try {
                imageSize = Integer.parseInt(imageSizeArg);
            }
            catch (NumberFormatException e) {
                imageSize = 10;
                logger.info("No valid integer given for property {}, using default value: {}", (Object)IMAGE_SIZE_PROPERTY, (Object)10);
            }
        } else {
            imageSize = 10;
            logger.info("Property {} not set, using default value: {}", (Object)IMAGE_SIZE_PROPERTY, (Object)10);
        }
        boolean processOnlyOne = BooleanUtils.toBoolean((String)StringUtils.trimToNull((String)workflowInstance.getCurrentOperation().getConfiguration(PROCCESS_FIRST_MATCH)));
        TrackSelector trackSelector = new TrackSelector();
        for (MediaPackageElementFlavor flavor : sourceFlavorProperty) {
            trackSelector.addFlavor(flavor);
        }
        for (String tag : sourceTagsProperty) {
            trackSelector.addTag(tag);
        }
        Collection sourceTracks = trackSelector.select(mediaPackage, true);
        if (sourceTracks.isEmpty()) {
            logger.info("No tracks found in mediapackage {} with specified {} {}", new Object[]{mediaPackage.getIdentifier().toString(), SOURCE_FLAVOR_PROPERTY, sourceFlavorProperty});
            this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        ArrayList<Job> timelinepreviewsJobs = new ArrayList<Job>(sourceTracks.size());
        for (Track sourceTrack : sourceTracks) {
            try {
                logger.info("Create timeline previews job for track '{}' in mediapackage '{}'", (Object)sourceTrack.getIdentifier(), (Object)mediaPackage.getIdentifier().toString());
                Job timelinepreviewsJob = this.timelinePreviewsService.createTimelinePreviewImages(sourceTrack, imageSize);
                timelinepreviewsJobs.add(timelinepreviewsJob);
                if (!processOnlyOne) continue;
                break;
            }
            catch (MediaPackageException | TimelinePreviewsException ex) {
                logger.error("Creating timeline previews job for track '{}' in media package '{}' failed with error {}", new Object[]{sourceTrack.getIdentifier(), mediaPackage.getIdentifier().toString(), ex.getMessage()});
            }
        }
        logger.info("Wait for timeline previews jobs for media package {}", (Object)mediaPackage.getIdentifier().toString());
        if (!this.waitForStatus(timelinepreviewsJobs.toArray(new Job[timelinepreviewsJobs.size()])).isSuccess()) {
            this.cleanupWorkspace(timelinepreviewsJobs);
            throw new WorkflowOperationException(String.format("Timeline previews jobs for media package '%s' have not completed successfully", mediaPackage.getIdentifier().toString()));
        }
        try {
            for (Job job : timelinepreviewsJobs) {
                String jobPayload = job.getPayload();
                if (!StringUtils.isNotEmpty((CharSequence)jobPayload)) continue;
                MediaPackageElement timelinePreviewsMpe = null;
                File timelinePreviewsFile = null;
                try {
                    timelinePreviewsMpe = MediaPackageElementParser.getFromXml((String)jobPayload);
                    timelinePreviewsFile = this.workspace.get(timelinePreviewsMpe.getURI());
                }
                catch (MediaPackageException ex) {
                    throw new WorkflowOperationException("Can't parse timeline previews attachment from job " + job.getId());
                }
                catch (NotFoundException ex) {
                    throw new WorkflowOperationException("Timeline preview images file '" + timelinePreviewsMpe.getURI() + "' not found", (Throwable)ex);
                }
                catch (IOException ex) {
                    throw new WorkflowOperationException("Can't get workflow image file '" + timelinePreviewsMpe.getURI() + "' from workspace");
                }
                FileInputStream timelinePreviewsInputStream = null;
                logger.info("Put timeline preview images file {} from media package {} to the media package work space", (Object)timelinePreviewsMpe.getURI(), (Object)mediaPackage.getIdentifier().toString());
                try {
                    timelinePreviewsInputStream = new FileInputStream(timelinePreviewsFile);
                    String fileName = FilenameUtils.getName((String)timelinePreviewsMpe.getURI().getPath());
                    URI timelinePreviewsWfrUri = this.workspace.put(mediaPackage.getIdentifier().toString(), timelinePreviewsMpe.getIdentifier(), fileName, (InputStream)timelinePreviewsInputStream);
                    timelinePreviewsMpe.setURI(timelinePreviewsWfrUri);
                }
                catch (FileNotFoundException ex) {
                    try {
                        throw new WorkflowOperationException("Timeline preview images file " + timelinePreviewsFile.getPath() + " not found", (Throwable)ex);
                        catch (IOException ex2) {
                            throw new WorkflowOperationException("Can't read just created timeline preview images file " + timelinePreviewsFile.getPath(), (Throwable)ex2);
                        }
                        catch (IllegalArgumentException ex3) {
                            throw new WorkflowOperationException((Throwable)ex3);
                        }
                    }
                    catch (Throwable throwable) {
                        IoSupport.closeQuietly(timelinePreviewsInputStream);
                        throw throwable;
                    }
                }
                IoSupport.closeQuietly((Closeable)timelinePreviewsInputStream);
                if ("*".equals(targetFlavor.getType())) {
                    targetFlavor = new MediaPackageElementFlavor(timelinePreviewsMpe.getFlavor().getType(), targetFlavor.getSubtype());
                }
                if ("*".equals(targetFlavor.getSubtype())) {
                    targetFlavor = new MediaPackageElementFlavor(targetFlavor.getType(), timelinePreviewsMpe.getFlavor().getSubtype());
                }
                timelinePreviewsMpe.setFlavor(targetFlavor);
                if (!targetTagsProperty.isEmpty()) {
                    for (String tag : targetTagsProperty) {
                        timelinePreviewsMpe.addTag(tag);
                    }
                }
                mediaPackage.add(timelinePreviewsMpe);
            }
        }
        finally {
            this.cleanupWorkspace(timelinepreviewsJobs);
        }
        logger.info("Timeline previews workflow operation for mediapackage {} completed", (Object)mediaPackage.getIdentifier().toString());
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private void cleanupWorkspace(List<Job> jobs) {
        for (Job job : jobs) {
            String jobPayload = job.getPayload();
            if (!StringUtils.isNotEmpty((CharSequence)jobPayload)) continue;
            try {
                MediaPackageElement timelinepreviewsMpe = MediaPackageElementParser.getFromXml((String)jobPayload);
                URI timelinepreviewsUri = timelinepreviewsMpe.getURI();
                this.workspace.delete(timelinepreviewsUri);
            }
            catch (MediaPackageException ex) {
                logger.error("Can't parse timeline previews attachment from job {}", (Object)job.getId());
            }
            catch (NotFoundException ex) {
            }
            catch (IOException ex) {
                logger.warn("Deleting timeline previews image file from workspace failed: {}", (Object)ex.getMessage());
            }
        }
    }

    @Reference
    public void setTimelinePreviewsService(TimelinePreviewsService timelinePreviewsService) {
        this.timelinePreviewsService = timelinePreviewsService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

