/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.timelinepreviews.remote;

import java.io.InputStream;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobParser;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsException;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TimelinePreviewsService.class}, property={"service.description=Timeline Previews Remote Service Proxy"})
public class TimelinePreviewsServiceRemote
extends RemoteBase
implements TimelinePreviewsService {
    private static final Logger logger = LoggerFactory.getLogger(TimelinePreviewsServiceRemote.class);

    public TimelinePreviewsServiceRemote() {
        super("org.opencastproject.timelinepreviews");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job createTimelinePreviewImages(Track sourceTrack, int imageCount) throws MediaPackageException, TimelinePreviewsException {
        HttpPost post = new HttpPost("/create");
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("track", MediaPackageElementParser.getAsXml((MediaPackageElement)sourceTrack)));
            params.add(new BasicNameValuePair("imageCount", Integer.toString(imageCount)));
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (Exception e) {
            throw new TimelinePreviewsException((Throwable)e);
        }
        HttpResponse response = null;
        try {
            response = this.getResponse((HttpRequestBase)post);
            if (response != null) {
                try {
                    Job receipt = JobParser.parseJob((InputStream)response.getEntity().getContent());
                    logger.info("Create timeline preview images from {}", (Object)sourceTrack);
                    Job job = receipt;
                    return job;
                }
                catch (Exception e) {
                    throw new TimelinePreviewsException("Unable to create timeline preview images from " + String.valueOf(sourceTrack) + " using a remote service", (Throwable)e);
                }
            }
        }
        finally {
            this.closeConnection(response);
        }
        throw new TimelinePreviewsException("Unable to create timeline preview images from " + String.valueOf(sourceTrack) + " using a remote service");
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

