/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.timelinepreviews.ffmpeg;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.identifier.IdImpl;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsException;
import org.opencastproject.timelinepreviews.api.TimelinePreviewsService;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TimelinePreviewsService.class, ManagedService.class}, property={"service.description=TimelinePreviews Service"})
public class TimelinePreviewsServiceImpl
extends AbstractJobProducer
implements TimelinePreviewsService,
ManagedService {
    public static final String COLLECTION_ID = "timelinepreviews";
    protected String binary = "ffmpeg";
    public static final String FFMPEG_BINARY_CONFIG = "org.opencastproject.composer.ffmpeg.path";
    public static final String FFMPEG_BINARY_DEFAULT = "ffmpeg";
    public static final String OPT_RESOLUTION_X = "resolutionX";
    public static final int DEFAULT_RESOLUTION_X = 160;
    public static final String OPT_RESOLUTION_Y = "resolutionY";
    public static final int DEFAULT_RESOLUTION_Y = -1;
    public static final String OPT_OUTPUT_FORMAT = "outputFormat";
    public static final String DEFAULT_OUTPUT_FORMAT = ".png";
    public static final String OPT_MIMETYPE = "mimetype";
    public static final String DEFAULT_MIMETYPE = "image/png";
    public static final float DEFAULT_TIMELINEPREVIEWS_JOB_LOAD = 0.1f;
    public static final String TIMELINEPREVIEWS_JOB_LOAD_KEY = "job.load.timelinepreviews";
    private float timelinepreviewsJobLoad = 0.1f;
    protected static final Logger logger = LoggerFactory.getLogger(TimelinePreviewsServiceImpl.class);
    protected int resolutionX = 160;
    protected int resolutionY = -1;
    protected String outputFormat = ".png";
    protected String mimetype = "image/png";
    protected ServiceRegistry serviceRegistry = null;
    protected Workspace workspace = null;
    protected SecurityService securityService = null;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectoryService = null;

    public TimelinePreviewsServiceImpl() {
        super("org.opencastproject.timelinepreviews");
    }

    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Activate ffmpeg timeline previews service");
        String path = cc.getBundleContext().getProperty(FFMPEG_BINARY_CONFIG);
        this.binary = path == null ? FFMPEG_BINARY_DEFAULT : path;
        logger.debug("Configuration {}: {}", (Object)FFMPEG_BINARY_CONFIG, (Object)FFMPEG_BINARY_DEFAULT);
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        String res;
        if (properties == null) {
            return;
        }
        logger.debug("Configuring the timeline previews service");
        if (properties.get(OPT_RESOLUTION_X) != null) {
            res = (String)properties.get(OPT_RESOLUTION_X);
            try {
                this.resolutionX = Integer.parseInt(res);
                logger.info("Horizontal resolution set to {} pixels", (Object)this.resolutionX);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_RESOLUTION_X, "Found illegal value '" + res + "' for timeline previews horizontal resolution");
            }
        }
        if (properties.get(OPT_RESOLUTION_Y) != null) {
            res = (String)properties.get(OPT_RESOLUTION_Y);
            try {
                this.resolutionY = Integer.parseInt(res);
                logger.info("Vertical resolution set to {} pixels", (Object)this.resolutionY);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_RESOLUTION_Y, "Found illegal value '" + res + "' for timeline previews vertical resolution");
            }
        }
        if (properties.get(OPT_OUTPUT_FORMAT) != null) {
            String format = (String)properties.get(OPT_OUTPUT_FORMAT);
            try {
                this.outputFormat = format;
                logger.info("Output file format set to \"{}\"", (Object)this.outputFormat);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_OUTPUT_FORMAT, "Found illegal value '" + format + "' for timeline previews output file format");
            }
        }
        if (properties.get(OPT_MIMETYPE) != null) {
            String type = (String)properties.get(OPT_MIMETYPE);
            try {
                this.mimetype = type;
                logger.info("Mime type set to \"{}\"", (Object)this.mimetype);
            }
            catch (Exception e) {
                throw new ConfigurationException(OPT_MIMETYPE, "Found illegal value '" + type + "' for timeline previews mimetype");
            }
        }
        this.timelinepreviewsJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)TIMELINEPREVIEWS_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
    }

    public Job createTimelinePreviewImages(Track track, int imageCount) throws TimelinePreviewsException, MediaPackageException {
        try {
            List<String> parameters = Arrays.asList(MediaPackageElementParser.getAsXml((MediaPackageElement)track), Integer.toString(imageCount));
            return this.serviceRegistry.createJob("org.opencastproject.timelinepreviews", Operation.TimelinePreview.toString(), parameters, Float.valueOf(this.timelinepreviewsJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new TimelinePreviewsException("Unable to create timelinepreviews job", (Throwable)e);
        }
    }

    protected Attachment generatePreviewImages(Job job, Track track, int imageCount) throws TimelinePreviewsException, MediaPackageException {
        if (!track.hasVideo()) {
            logger.error("Element {} is not a video track", (Object)track.getIdentifier());
            throw new TimelinePreviewsException("Element is not a video track");
        }
        try {
            int imageSize;
            if (track.getDuration() == null) {
                throw new MediaPackageException("Track " + String.valueOf(track) + " does not have a duration");
            }
            double duration = (double)track.getDuration().longValue() / 1000.0;
            double seconds = duration / (double)imageCount;
            seconds = seconds <= 0.0 ? 1.0 : seconds;
            Attachment composedImage = this.createPreviewsFFmpeg(track, seconds, this.resolutionX, this.resolutionY, imageSize = (int)Math.ceil(Math.sqrt(imageCount)), imageSize, duration);
            if (composedImage == null) {
                throw new IllegalStateException("Unable to compose image");
            }
            try {
                composedImage.setMimeType(MimeTypes.parseMimeType((String)this.mimetype));
            }
            catch (IllegalArgumentException e) {
                logger.warn("Invalid mimetype provided for timeline previews image");
                try {
                    composedImage.setMimeType(MimeTypes.fromURI((URI)composedImage.getURI()));
                }
                catch (UnknownFileTypeException ex) {
                    logger.warn("No valid mimetype could be found for timeline previews image");
                }
            }
            composedImage.getProperties().put("imageCount", String.valueOf(imageCount));
            return composedImage;
        }
        catch (Exception e) {
            logger.warn("Error creating timeline preview images for " + String.valueOf(track), (Throwable)e);
            if (e instanceof TimelinePreviewsException) {
                throw (TimelinePreviewsException)((Object)e);
            }
            throw new TimelinePreviewsException((Throwable)e);
        }
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            switch (op.ordinal()) {
                case 0: {
                    Track track = (Track)MediaPackageElementParser.getFromXml((String)((String)arguments.get(0)));
                    int imageCount = Integer.parseInt((String)arguments.get(1));
                    Attachment timelinePreviewsMpe = this.generatePreviewImages(job, track, imageCount);
                    return MediaPackageElementParser.getAsXml((MediaPackageElement)timelinePreviewsMpe);
                }
            }
            throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + String.valueOf((Object)op) + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Attachment createPreviewsFFmpeg(Track track, double seconds, int width, int height, int tileX, int tileY, double duration) throws TimelinePreviewsException {
        File mediaFile;
        try {
            mediaFile = this.workspace.get(track.getURI());
        }
        catch (NotFoundException e) {
            throw new TimelinePreviewsException("Error finding the media file in the workspace", (Throwable)e);
        }
        catch (IOException e) {
            throw new TimelinePreviewsException("Error reading the media file in the workspace", (Throwable)e);
        }
        String imageFilePath = FilenameUtils.removeExtension((String)mediaFile.getAbsolutePath()) + "_" + String.valueOf(UUID.randomUUID()) + "_timelinepreviews" + this.outputFormat;
        int exitCode = 1;
        Object[] command = new String[]{this.binary, "-loglevel", "error", "-t", String.valueOf(duration - seconds / 2.0), "-skip_frame", duration > 900.0 ? "nokey" : "default", "-i", mediaFile.getAbsolutePath(), "-vf", "fps=1/" + seconds + ",scale=" + width + ":" + height + ",tile=" + tileX + "x" + tileY, imageFilePath};
        logger.debug("Start timeline previews ffmpeg process: {}", (Object)StringUtils.join((Object[])command, (String)" "));
        logger.info("Create timeline preview images file for track '{}' at {}", (Object)track.getIdentifier(), (Object)imageFilePath);
        ProcessBuilder pbuilder = new ProcessBuilder((String[])command);
        pbuilder.redirectErrorStream(true);
        Process ffmpegProcess = null;
        exitCode = 1;
        BufferedReader errStream = null;
        try {
            ffmpegProcess = pbuilder.start();
            errStream = new BufferedReader(new InputStreamReader(ffmpegProcess.getInputStream()));
            String line = errStream.readLine();
            while (line != null) {
                logger.error("FFmpeg error: " + line);
                line = errStream.readLine();
            }
            exitCode = ffmpegProcess.waitFor();
        }
        catch (IOException ex) {
            try {
                throw new TimelinePreviewsException("Starting ffmpeg process failed", (Throwable)ex);
                catch (InterruptedException ex2) {
                    throw new TimelinePreviewsException("Timeline preview creation was unexpectedly interrupted", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly((Process)ffmpegProcess);
                IoSupport.closeQuietly(errStream);
                if (exitCode == 0) throw throwable;
                try {
                    FileUtils.forceDelete((File)new File(imageFilePath));
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)ffmpegProcess);
        IoSupport.closeQuietly((Closeable)errStream);
        if (exitCode != 0) {
            try {
                FileUtils.forceDelete((File)new File(imageFilePath));
            }
            catch (IOException line) {}
        }
        if (exitCode != 0) {
            throw new TimelinePreviewsException("Generating timeline preview for track " + track.getIdentifier() + " failed: ffmpeg process exited abnormally with exit code " + exitCode);
        }
        FileInputStream timelinepreviewsFileInputStream = null;
        URI previewsFileUri = null;
        try {
            timelinepreviewsFileInputStream = new FileInputStream(imageFilePath);
            previewsFileUri = this.workspace.putInCollection(COLLECTION_ID, FilenameUtils.getName((String)imageFilePath), (InputStream)timelinepreviewsFileInputStream);
            logger.info("Copied the created timeline preview images file to the workspace {}", (Object)previewsFileUri.toString());
        }
        catch (FileNotFoundException ex) {
            try {
                throw new TimelinePreviewsException(String.format("Timeline previews image file '%s' not found", imageFilePath), (Throwable)ex);
                catch (IOException ex3) {
                    throw new TimelinePreviewsException(String.format("Can't write timeline preview images file '%s' to workspace", imageFilePath), (Throwable)ex3);
                }
                catch (IllegalArgumentException ex4) {
                    throw new TimelinePreviewsException((Throwable)ex4);
                }
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(timelinepreviewsFileInputStream);
                logger.info("Deleted local timeline preview images file at {}", (Object)imageFilePath);
                FileUtils.deleteQuietly((File)new File(imageFilePath));
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Closeable)timelinepreviewsFileInputStream);
        logger.info("Deleted local timeline preview images file at {}", (Object)imageFilePath);
        FileUtils.deleteQuietly((File)new File(imageFilePath));
        MediaPackageElementBuilder mpElementBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
        Attachment timelinepreviewsMpe = (Attachment)mpElementBuilder.elementFromURI(previewsFileUri, MediaPackageElement.Type.Attachment, track.getFlavor());
        timelinepreviewsMpe.referTo((MediaPackageElement)track);
        timelinepreviewsMpe.getProperties().put("imageSizeX", String.valueOf(tileX));
        timelinepreviewsMpe.getProperties().put("imageSizeY", String.valueOf(tileY));
        timelinepreviewsMpe.getProperties().put(OPT_RESOLUTION_X, String.valueOf(this.resolutionX));
        timelinepreviewsMpe.getProperties().put(OPT_RESOLUTION_Y, String.valueOf(this.resolutionY));
        timelinepreviewsMpe.setFlavor(track.getFlavor());
        timelinepreviewsMpe.setIdentifier(IdImpl.fromUUID().toString());
        return timelinepreviewsMpe;
    }

    @Reference
    protected void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectoryService = organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectoryService;
    }

    protected static enum Operation {
        TimelinePreview;

    }
}

