/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.themes.persistence;

import java.util.Date;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.themes.Theme;
import org.opencastproject.util.data.Option;

@Entity(name="Themes")
@Access(value=AccessType.FIELD)
@Table(name="oc_themes")
@NamedQueries(value={@NamedQuery(name="Themes.count", query="SELECT COUNT(t) FROM Themes t WHERE t.organization = :org"), @NamedQuery(name="Themes.findById", query="SELECT t FROM Themes t WHERE t.id = :id AND t.organization = :org"), @NamedQuery(name="Themes.findByOrg", query="SELECT t FROM Themes t WHERE t.organization = :org"), @NamedQuery(name="Themes.findByUserName", query="SELECT t FROM Themes t WHERE t.username = :username AND t.organization = :org"), @NamedQuery(name="Themes.clear", query="DELETE FROM Themes t WHERE t.organization = :org")})
public class ThemeDto {
    @Id
    @GeneratedValue
    @Column(name="id", nullable=false)
    private long id;
    @Column(name="organization", nullable=false, length=128)
    private String organization;
    @Column(name="creation_date", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="isDefault", nullable=false)
    private boolean isDefault = false;
    @Column(name="username", nullable=false, length=128)
    private String username;
    @Column(name="name", nullable=false)
    private String name;
    @Column(name="description")
    private String description;
    @Column(name="bumper_active", nullable=false)
    private boolean bumperActive = false;
    @Column(name="bumper_file", length=128)
    private String bumperFile;
    @Column(name="trailer_active", nullable=false)
    private boolean trailerActive = false;
    @Column(name="trailer_file", length=128)
    private String trailerFile;
    @Column(name="title_slide_active", nullable=false)
    private boolean titleSlideActive = false;
    @Column(name="title_slide_metadata")
    private String titleSlideMetadata;
    @Column(name="title_slide_background", length=128)
    private String titleSlideBackground;
    @Column(name="license_slide_active", nullable=false)
    private boolean licenseSlideActive = false;
    @Column(name="license_slide_background", length=128)
    private String licenseSlideBackground;
    @Column(name="license_slide_description")
    private String licenseSlideDescription;
    @Column(name="watermark_active", nullable=false)
    private boolean watermarkActive = false;
    @Column(name="watermark_file", length=128)
    private String watermarkFile;
    @Column(name="watermark_position")
    private String watermarkPosition;

    public Theme toTheme(UserDirectoryService userDirectoryService) {
        User creator = userDirectoryService.loadUser(this.username);
        return new Theme((Option<Long>)Option.some((Object)this.id), this.creationDate, this.isDefault, creator, this.name, this.description, this.bumperActive, this.bumperFile, this.trailerActive, this.trailerFile, this.titleSlideActive, this.titleSlideMetadata, this.titleSlideBackground, this.licenseSlideActive, this.licenseSlideBackground, this.licenseSlideDescription, this.watermarkActive, this.watermarkFile, this.watermarkPosition);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isBumperActive() {
        return this.bumperActive;
    }

    public void setBumperActive(boolean bumperActive) {
        this.bumperActive = bumperActive;
    }

    public String getBumperFile() {
        return this.bumperFile;
    }

    public void setBumperFile(String bumperFile) {
        this.bumperFile = bumperFile;
    }

    public boolean isTrailerActive() {
        return this.trailerActive;
    }

    public void setTrailerActive(boolean trailerActive) {
        this.trailerActive = trailerActive;
    }

    public String getTrailerFile() {
        return this.trailerFile;
    }

    public void setTrailerFile(String trailerFile) {
        this.trailerFile = trailerFile;
    }

    public boolean isTitleSlideActive() {
        return this.titleSlideActive;
    }

    public void setTitleSlideActive(boolean titleSlideActive) {
        this.titleSlideActive = titleSlideActive;
    }

    public String getTitleSlideBackground() {
        return this.titleSlideBackground;
    }

    public void setTitleSlideBackground(String titleSlideBackground) {
        this.titleSlideBackground = titleSlideBackground;
    }

    public String getTitleSlideMetadata() {
        return this.titleSlideMetadata;
    }

    public void setTitleSlideMetadata(String titleSlideMetadata) {
        this.titleSlideMetadata = titleSlideMetadata;
    }

    public boolean isLicenseSlideActive() {
        return this.licenseSlideActive;
    }

    public void setLicenseSlideActive(boolean licenseSlideActive) {
        this.licenseSlideActive = licenseSlideActive;
    }

    public String getLicenseSlideBackground() {
        return this.licenseSlideBackground;
    }

    public void setLicenseSlideBackground(String licenseSlideBackground) {
        this.licenseSlideBackground = licenseSlideBackground;
    }

    public String getLicenseSlideDescription() {
        return this.licenseSlideDescription;
    }

    public void setLicenseSlideDescription(String licenseSlideDescription) {
        this.licenseSlideDescription = licenseSlideDescription;
    }

    public boolean isWatermarkActive() {
        return this.watermarkActive;
    }

    public void setWatermarkActive(boolean watermarkActive) {
        this.watermarkActive = watermarkActive;
    }

    public String getWatermarkFile() {
        return this.watermarkFile;
    }

    public void setWatermarkFile(String watermarkFile) {
        this.watermarkFile = watermarkFile;
    }

    public String getWatermarkPosition() {
        return this.watermarkPosition;
    }

    public void setWatermarkPosition(String watermarkPosition) {
        this.watermarkPosition = watermarkPosition;
    }
}

