/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.themes.persistence;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.elasticsearch.api.SearchIndexException;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.objects.theme.IndexTheme;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.themes.Theme;
import org.opencastproject.themes.ThemesServiceDatabase;
import org.opencastproject.themes.persistence.ThemeDto;
import org.opencastproject.themes.persistence.ThemesServiceDatabaseException;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ThemesServiceDatabase.class, IndexProducer.class}, property={"service.description=Themes Database Service"})
public class ThemesServiceDatabaseImpl
extends AbstractIndexProducer
implements ThemesServiceDatabase {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.themes";
    private static final Logger logger = LoggerFactory.getLogger(ThemesServiceDatabaseImpl.class);
    protected EntityManagerFactory emf;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected SecurityService securityService;
    protected UserDirectoryService userDirectoryService;
    protected OrganizationDirectoryService organizationDirectoryService;
    protected ElasticsearchIndex index;
    private ComponentContext cc;

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating persistence manager for themes");
        this.cc = cc;
        this.db = this.dbSessionFactory.createSession(this.emf);
    }

    @Reference(target="(osgi.unit.name=org.opencastproject.themes)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        this.organizationDirectoryService = organizationDirectoryService;
    }

    @Reference
    public void setIndex(ElasticsearchIndex index) {
        this.index = index;
    }

    @Override
    public Theme getTheme(long id) throws ThemesServiceDatabaseException, NotFoundException {
        try {
            return ((Optional)this.db.exec(this.getThemeDtoQuery(id))).map(t -> t.toTheme(this.userDirectoryService)).orElseThrow(() -> new NotFoundException("No theme with id=" + id + " exists"));
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not get theme", (Throwable)e);
            throw new ThemesServiceDatabaseException(e);
        }
    }

    private List<Theme> getThemes() throws ThemesServiceDatabaseException {
        try {
            String orgId = this.securityService.getOrganization().getId();
            return ((List)this.db.exec(Queries.namedQuery.findAll("Themes.findByOrg", ThemeDto.class, new Object[]{Pair.of((Object)"org", (Object)orgId)}))).stream().map(t -> t.toTheme(this.userDirectoryService)).collect(Collectors.toList());
        }
        catch (Exception e) {
            logger.error("Could not get themes", (Throwable)e);
            throw new ThemesServiceDatabaseException(e);
        }
    }

    @Override
    public Theme updateTheme(Theme theme) throws ThemesServiceDatabaseException {
        try {
            Theme newTheme = (Theme)this.db.execTxChecked(em -> {
                ThemeDto themeDto = null;
                if (theme.getId().isSome()) {
                    themeDto = this.getThemeDtoQuery((Long)theme.getId().get()).apply((EntityManager)em).orElse(null);
                }
                if (themeDto == null) {
                    themeDto = new ThemeDto();
                    themeDto.setOrganization(this.securityService.getOrganization().getId());
                    this.updateTheme(theme, themeDto);
                    em.persist((Object)themeDto);
                } else {
                    this.updateTheme(theme, themeDto);
                    em.merge((Object)themeDto);
                }
                return themeDto.toTheme(this.userDirectoryService);
            });
            String orgId = this.securityService.getOrganization().getId();
            User user = this.securityService.getUser();
            this.updateThemeInIndex(newTheme, orgId, user);
            return newTheme;
        }
        catch (Exception e) {
            logger.error("Could not update theme {}", (Object)theme, (Object)e);
            throw new ThemesServiceDatabaseException(e);
        }
    }

    private void updateTheme(Theme theme, ThemeDto themeDto) {
        if (theme.getId().isSome()) {
            themeDto.setId((Long)theme.getId().get());
        }
        themeDto.setUsername(theme.getCreator().getUsername());
        themeDto.setCreationDate(theme.getCreationDate());
        themeDto.setDefault(theme.isDefault());
        themeDto.setName(theme.getName());
        themeDto.setDescription(theme.getDescription());
        themeDto.setBumperActive(theme.isBumperActive());
        themeDto.setBumperFile(theme.getBumperFile());
        themeDto.setTrailerActive(theme.isTrailerActive());
        themeDto.setTrailerFile(theme.getTrailerFile());
        themeDto.setTitleSlideActive(theme.isTitleSlideActive());
        themeDto.setTitleSlideBackground(theme.getTitleSlideBackground());
        themeDto.setTitleSlideMetadata(theme.getTitleSlideMetadata());
        themeDto.setLicenseSlideActive(theme.isLicenseSlideActive());
        themeDto.setLicenseSlideBackground(theme.getLicenseSlideBackground());
        themeDto.setLicenseSlideDescription(theme.getLicenseSlideDescription());
        themeDto.setWatermarkActive(theme.isWatermarkActive());
        themeDto.setWatermarkFile(theme.getWatermarkFile());
        themeDto.setWatermarkPosition(theme.getWatermarkPosition());
    }

    @Override
    public void deleteTheme(long id) throws ThemesServiceDatabaseException, NotFoundException {
        try {
            this.db.execTxChecked(em -> {
                ThemeDto themeDto = this.getThemeDtoQuery(id).apply((EntityManager)em).orElseThrow(() -> new NotFoundException("No theme with id=" + id + " exists"));
                Queries.namedQuery.remove((Object)themeDto).accept(em);
            });
            String organization = this.securityService.getOrganization().getId();
            this.removeThemeFromIndex(id, organization);
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not delete theme '{}'", (Object)id, (Object)e);
            throw new ThemesServiceDatabaseException(e);
        }
    }

    @Override
    public int countThemes() throws ThemesServiceDatabaseException {
        try {
            String orgId = this.securityService.getOrganization().getId();
            return ((Number)this.db.exec(Queries.namedQuery.find("Themes.count", Number.class, new Object[]{Pair.of((Object)"org", (Object)orgId)}))).intValue();
        }
        catch (Exception e) {
            logger.error("Could not count themes", (Throwable)e);
            throw new ThemesServiceDatabaseException(e);
        }
    }

    private Function<EntityManager, Optional<ThemeDto>> getThemeDtoQuery(long id) {
        String orgId = this.securityService.getOrganization().getId();
        return Queries.namedQuery.findOpt("Themes.findById", ThemeDto.class, new Object[]{Pair.of((Object)"id", (Object)id), Pair.of((Object)"org", (Object)orgId)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void repopulate() throws IndexRebuildException {
        try {
            for (Organization organization : this.organizationDirectoryService.getOrganizations()) {
                try {
                    List<Theme> themes = this.getThemes();
                    int total = themes.size();
                    this.logIndexRebuildBegin(logger, total, "themes", organization);
                    int current = 0;
                    int n = 20;
                    ArrayList<IndexTheme> updatedThemeRange = new ArrayList<IndexTheme>();
                    for (Theme theme : themes) {
                        Optional<IndexTheme> updatedThemeData = this.index.getTheme(((Long)theme.getId().get()).longValue(), organization.toString(), this.securityService.getUser());
                        updatedThemeData = this.getThemeUpdateFunction(theme, organization.toString()).apply(updatedThemeData);
                        updatedThemeRange.add(updatedThemeData.get());
                        if (updatedThemeRange.size() < n && ++current < themes.size()) continue;
                        this.index.bulkThemeUpdate(updatedThemeRange);
                        this.logIndexRebuildProgress(logger, total, current, n);
                        updatedThemeRange.clear();
                    }
                }
                catch (ThemesServiceDatabaseException e) {
                    logger.error("Unable to get themes from the database", (Throwable)e);
                    throw new IllegalStateException(e);
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logIndexRebuildError(logger, e);
            throw new IndexRebuildException(this.getService(), (Throwable)e);
        }
    }

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.Themes;
    }

    private void removeThemeFromIndex(long themeId, String orgId) {
        logger.debug("Removing theme {} from the {} index.", (Object)themeId, (Object)this.index.getIndexName());
        try {
            this.index.deleteTheme(Long.toString(themeId), orgId);
            logger.debug("Theme {} removed from the {} index", (Object)themeId, (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Error deleting the theme {} from the {} index", new Object[]{themeId, this.index.getIndexName(), e});
        }
    }

    private void updateThemeInIndex(Theme theme, String orgId, User user) {
        logger.debug("Updating the theme with id '{}', name '{}', description '{}', organization '{}' in the {} index.", new Object[]{theme.getId(), theme.getName(), theme.getDescription(), orgId, this.index.getIndexName()});
        try {
            if (theme.getId().isNone()) {
                throw new IllegalArgumentException("Can't put theme in index without valid id!");
            }
            Long id = (Long)theme.getId().get();
            Function<Optional, Optional> updateFunction = indexThemeOpt -> {
                IndexTheme indexTheme = indexThemeOpt.orElseGet(() -> new IndexTheme(id.longValue(), orgId));
                String creator = StringUtils.isNotBlank((CharSequence)theme.getCreator().getName()) ? theme.getCreator().getName() : theme.getCreator().getUsername();
                indexTheme.setCreationDate(theme.getCreationDate());
                indexTheme.setDefault(theme.isDefault());
                indexTheme.setName(theme.getName());
                indexTheme.setDescription(theme.getDescription());
                indexTheme.setCreator(creator);
                indexTheme.setBumperActive(theme.isBumperActive());
                indexTheme.setBumperFile(theme.getBumperFile());
                indexTheme.setTrailerActive(theme.isTrailerActive());
                indexTheme.setTrailerFile(theme.getTrailerFile());
                indexTheme.setTitleSlideActive(theme.isTitleSlideActive());
                indexTheme.setTitleSlideBackground(theme.getTitleSlideBackground());
                indexTheme.setTitleSlideMetadata(theme.getTitleSlideMetadata());
                indexTheme.setLicenseSlideActive(theme.isLicenseSlideActive());
                indexTheme.setLicenseSlideBackground(theme.getLicenseSlideBackground());
                indexTheme.setLicenseSlideDescription(theme.getLicenseSlideDescription());
                indexTheme.setWatermarkActive(theme.isWatermarkActive());
                indexTheme.setWatermarkFile(theme.getWatermarkFile());
                indexTheme.setWatermarkPosition(theme.getWatermarkPosition());
                return Optional.of(indexTheme);
            };
            this.index.addOrUpdateTheme(id.longValue(), updateFunction, orgId, user);
            logger.debug("Updated the theme {} in the {} index", theme.getId(), (Object)this.index.getIndexName());
        }
        catch (SearchIndexException e) {
            logger.error("Error updating the theme {} in the {} index", new Object[]{theme.getId(), this.index.getIndexName(), e});
        }
    }

    private Function<Optional<IndexTheme>, Optional<IndexTheme>> getThemeUpdateFunction(Theme theme, String orgId) {
        return indexThemeOpt -> {
            IndexTheme indexTheme = indexThemeOpt.orElseGet(() -> new IndexTheme(((Long)theme.getId().get()).longValue(), orgId));
            String creator = StringUtils.isNotBlank((CharSequence)theme.getCreator().getName()) ? theme.getCreator().getName() : theme.getCreator().getUsername();
            indexTheme.setCreationDate(theme.getCreationDate());
            indexTheme.setDefault(theme.isDefault());
            indexTheme.setName(theme.getName());
            indexTheme.setDescription(theme.getDescription());
            indexTheme.setCreator(creator);
            indexTheme.setBumperActive(theme.isBumperActive());
            indexTheme.setBumperFile(theme.getBumperFile());
            indexTheme.setTrailerActive(theme.isTrailerActive());
            indexTheme.setTrailerFile(theme.getTrailerFile());
            indexTheme.setTitleSlideActive(theme.isTitleSlideActive());
            indexTheme.setTitleSlideBackground(theme.getTitleSlideBackground());
            indexTheme.setTitleSlideMetadata(theme.getTitleSlideMetadata());
            indexTheme.setLicenseSlideActive(theme.isLicenseSlideActive());
            indexTheme.setLicenseSlideBackground(theme.getLicenseSlideBackground());
            indexTheme.setLicenseSlideDescription(theme.getLicenseSlideDescription());
            indexTheme.setWatermarkActive(theme.isWatermarkActive());
            indexTheme.setWatermarkFile(theme.getWatermarkFile());
            indexTheme.setWatermarkPosition(theme.getWatermarkPosition());
            return Optional.of(indexTheme);
        };
    }
}

