/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.themes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.composer.layout.AbsolutePositionLayoutSpec;
import org.opencastproject.composer.layout.AnchorOffset;
import org.opencastproject.composer.layout.Anchors;
import org.opencastproject.composer.layout.Offset;
import org.opencastproject.composer.layout.Serializer;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.staticfiles.api.StaticFileService;
import org.opencastproject.themes.Theme;
import org.opencastproject.themes.ThemesServiceDatabase;
import org.opencastproject.themes.persistence.ThemesServiceDatabaseException;
import org.opencastproject.util.MimeType;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UnknownFileTypeException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Theme Workflow Operation Handler", "workflow.operation=theme"})
public class ThemeWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String BUMPER_FLAVOR = "bumper-flavor";
    private static final String BUMPER_TAGS = "bumper-tags";
    private static final String TRAILER_FLAVOR = "trailer-flavor";
    private static final String TRAILER_TAGS = "trailer-tags";
    private static final String TITLE_SLIDE_FLAVOR = "title-slide-flavor";
    private static final String TITLE_SLIDE_TAGS = "title-slide-tags";
    private static final String LICENSE_SLIDE_FLAVOR = "license-slide-flavor";
    private static final String LICENSE_SLIDE_TAGS = "license-slide-tags";
    private static final String WATERMARK_FLAVOR = "watermark-flavor";
    private static final String WATERMARK_TAGS = "watermark-tags";
    private static final String WATERMARK_LAYOUT = "watermark-layout";
    private static final String WATERMARK_LAYOUT_VARIABLE = "watermark-layout-variable";
    private static final String THEME_ACTIVE = "theme_active";
    private static final String THEME_BUMPER_ACTIVE = "theme_bumper_active";
    private static final String THEME_TRAILER_ACTIVE = "theme_trailer_active";
    private static final String THEME_TITLE_SLIDE_ACTIVE = "theme_title_slide_active";
    private static final String THEME_TITLE_SLIDE_UPLOADED = "theme_title_slide_uploaded";
    private static final String THEME_WATERMARK_ACTIVE = "theme_watermark_active";
    private static final String THEME_PROPERTY_NAME = "theme";
    private static final Logger logger = LoggerFactory.getLogger(ThemeWorkflowOperationHandler.class);
    private static final MediaPackageElementBuilderFactory elementBuilderFactory = MediaPackageElementBuilderFactory.newInstance();
    private SeriesService seriesService;
    private ThemesServiceDatabase themesServiceDatabase;
    private StaticFileService staticFileService;
    private Workspace workspace;

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setThemesServiceDatabase(ThemesServiceDatabase themesServiceDatabase) {
        this.themesServiceDatabase = themesServiceDatabase;
    }

    @Reference
    public void setStaticFileService(StaticFileService staticFileService) {
        this.staticFileService = staticFileService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running theme workflow operation on workflow {}", (Object)workflowInstance.getId());
        MediaPackageElementFlavor bumperFlavor = Optional.ofNullable((String)this.getOptConfig(workflowInstance, BUMPER_FLAVOR).orNull()).map(MediaPackageElementFlavor::parseFlavor).orElse(new MediaPackageElementFlavor("branding", "bumper"));
        MediaPackageElementFlavor trailerFlavor = Optional.ofNullable((String)this.getOptConfig(workflowInstance, TRAILER_FLAVOR).orNull()).map(MediaPackageElementFlavor::parseFlavor).orElse(new MediaPackageElementFlavor("branding", "trailer"));
        MediaPackageElementFlavor titleSlideFlavor = Optional.ofNullable((String)this.getOptConfig(workflowInstance, TITLE_SLIDE_FLAVOR).orNull()).map(MediaPackageElementFlavor::parseFlavor).orElse(new MediaPackageElementFlavor("branding", "title-slide"));
        MediaPackageElementFlavor licenseSlideFlavor = Optional.ofNullable((String)this.getOptConfig(workflowInstance, LICENSE_SLIDE_FLAVOR).orNull()).map(MediaPackageElementFlavor::parseFlavor).orElse(new MediaPackageElementFlavor("branding", "license-slide"));
        MediaPackageElementFlavor watermarkFlavor = Optional.ofNullable((String)this.getOptConfig(workflowInstance, WATERMARK_FLAVOR).orNull()).map(MediaPackageElementFlavor::parseFlavor).orElse(new MediaPackageElementFlavor("branding", "watermark"));
        List bumperTags = this.asList(workflowInstance.getConfiguration(BUMPER_TAGS));
        List trailerTags = this.asList(workflowInstance.getConfiguration(TRAILER_TAGS));
        List titleSlideTags = this.asList(workflowInstance.getConfiguration(TITLE_SLIDE_TAGS));
        List licenseSlideTags = this.asList(workflowInstance.getConfiguration(LICENSE_SLIDE_TAGS));
        List watermarkTags = this.asList(workflowInstance.getConfiguration(WATERMARK_TAGS));
        Optional<String> layoutStringOpt = Optional.ofNullable((String)this.getOptConfig(workflowInstance, WATERMARK_LAYOUT).orNull());
        Optional<String> watermarkLayoutVariable = Optional.ofNullable((String)this.getOptConfig(workflowInstance, WATERMARK_LAYOUT_VARIABLE).orNull());
        List layoutList = layoutStringOpt.map(s -> Arrays.asList(s.split(";"))).orElse(Collections.emptyList());
        try {
            Theme theme;
            Long themeId;
            MediaPackage mediaPackage = workflowInstance.getMediaPackage();
            String series = mediaPackage.getSeries();
            if (series == null) {
                logger.info("Skipping theme workflow operation, no series assigned to mediapackage {}", (Object)mediaPackage.getIdentifier());
                return this.createResult(WorkflowOperationResult.Action.SKIP);
            }
            try {
                themeId = Long.parseLong(this.seriesService.getSeriesProperty(series, THEME_PROPERTY_NAME));
            }
            catch (NotFoundException e) {
                logger.info("Skipping theme workflow operation, no theme assigned to series {} on mediapackage {}.", (Object)series, (Object)mediaPackage.getIdentifier());
                return this.createResult(WorkflowOperationResult.Action.SKIP);
            }
            catch (UnauthorizedException e) {
                logger.warn("Skipping theme workflow operation, user not authorized to perform operation:", (Throwable)e);
                return this.createResult(WorkflowOperationResult.Action.SKIP);
            }
            try {
                theme = this.themesServiceDatabase.getTheme(themeId.longValue());
            }
            catch (NotFoundException e) {
                logger.warn("Skipping theme workflow operation, no theme with id {} found.", (Object)themeId);
                return this.createResult(WorkflowOperationResult.Action.SKIP);
            }
            logger.info("Applying theme {} to mediapackage {}", (Object)themeId, (Object)mediaPackage.getIdentifier());
            workflowInstance.setConfiguration(THEME_ACTIVE, Boolean.toString(theme.isBumperActive() || theme.isTrailerActive() || theme.isTitleSlideActive() || theme.isWatermarkActive()));
            workflowInstance.setConfiguration(THEME_BUMPER_ACTIVE, Boolean.toString(theme.isBumperActive()));
            workflowInstance.setConfiguration(THEME_TRAILER_ACTIVE, Boolean.toString(theme.isTrailerActive()));
            workflowInstance.setConfiguration(THEME_TITLE_SLIDE_ACTIVE, Boolean.toString(theme.isTitleSlideActive()));
            workflowInstance.setConfiguration(THEME_TITLE_SLIDE_UPLOADED, Boolean.toString(StringUtils.isNotBlank((CharSequence)theme.getTitleSlideBackground())));
            workflowInstance.setConfiguration(THEME_WATERMARK_ACTIVE, Boolean.toString(theme.isWatermarkActive()));
            if (theme.isBumperActive() && StringUtils.isNotBlank((CharSequence)theme.getBumperFile())) {
                try (InputStream bumper = this.staticFileService.getFile(theme.getBumperFile());){
                    this.addElement(mediaPackage, bumperFlavor, bumperTags, bumper, this.staticFileService.getFileName(theme.getBumperFile()), MediaPackageElement.Type.Track);
                }
                catch (NotFoundException e) {
                    logger.warn("Bumper file {} not found in static file service, skip applying it", (Object)theme.getBumperFile());
                }
            }
            if (theme.isTrailerActive() && StringUtils.isNotBlank((CharSequence)theme.getTrailerFile())) {
                try (InputStream trailer = this.staticFileService.getFile(theme.getTrailerFile());){
                    this.addElement(mediaPackage, trailerFlavor, trailerTags, trailer, this.staticFileService.getFileName(theme.getTrailerFile()), MediaPackageElement.Type.Track);
                }
                catch (NotFoundException e) {
                    logger.warn("Trailer file {} not found in static file service, skip applying it", (Object)theme.getTrailerFile());
                }
            }
            if (theme.isTitleSlideActive() && StringUtils.isNotBlank((CharSequence)theme.getTitleSlideBackground())) {
                try (InputStream titleSlideBackground = this.staticFileService.getFile(theme.getTitleSlideBackground());){
                    this.addElement(mediaPackage, titleSlideFlavor, titleSlideTags, titleSlideBackground, this.staticFileService.getFileName(theme.getTitleSlideBackground()), MediaPackageElement.Type.Attachment);
                }
                catch (NotFoundException e) {
                    logger.warn("Title slide file {} not found in static file service, skip applying it", (Object)theme.getTitleSlideBackground());
                }
            }
            if (theme.isLicenseSlideActive() && StringUtils.isNotBlank((CharSequence)theme.getLicenseSlideBackground())) {
                try (InputStream licenseSlideBackground = this.staticFileService.getFile(theme.getLicenseSlideBackground());){
                    this.addElement(mediaPackage, licenseSlideFlavor, licenseSlideTags, licenseSlideBackground, this.staticFileService.getFileName(theme.getLicenseSlideBackground()), MediaPackageElement.Type.Attachment);
                }
                catch (NotFoundException e) {
                    logger.warn("License slide file {} not found in static file service, skip applying it", (Object)theme.getLicenseSlideBackground());
                }
            }
            if (theme.isWatermarkActive() && StringUtils.isNotBlank((CharSequence)theme.getWatermarkFile())) {
                try (InputStream watermark = this.staticFileService.getFile(theme.getWatermarkFile());){
                    this.addElement(mediaPackage, watermarkFlavor, watermarkTags, watermark, this.staticFileService.getFileName(theme.getWatermarkFile()), MediaPackageElement.Type.Attachment);
                }
                catch (NotFoundException e) {
                    logger.warn("Watermark file {} not found in static file service, skip applying it", (Object)theme.getWatermarkFile());
                }
                if (layoutStringOpt.isEmpty() || watermarkLayoutVariable.isEmpty()) {
                    throw new WorkflowOperationException(String.format("Configuration key '%s' or '%s' is either missing or empty", WATERMARK_LAYOUT, WATERMARK_LAYOUT_VARIABLE));
                }
                AbsolutePositionLayoutSpec watermarkLayout = this.parseLayout(theme.getWatermarkPosition());
                layoutList.set(layoutList.size() - 1, Serializer.json((AbsolutePositionLayoutSpec)watermarkLayout).toJson());
                layoutStringOpt = Optional.of(String.join((CharSequence)";", layoutList));
            }
            if (watermarkLayoutVariable.isPresent() && layoutStringOpt.isPresent()) {
                workflowInstance.setConfiguration(watermarkLayoutVariable.get(), layoutStringOpt.get());
            }
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | SeriesException | ThemesServiceDatabaseException e) {
            throw new WorkflowOperationException(e);
        }
    }

    private AbsolutePositionLayoutSpec parseLayout(String watermarkPosition) {
        switch (watermarkPosition) {
            case "topLeft": {
                return new AbsolutePositionLayoutSpec(new AnchorOffset(Anchors.TOP_LEFT, Anchors.TOP_LEFT, Offset.offset((int)20, (int)20)));
            }
            case "topRight": {
                return new AbsolutePositionLayoutSpec(new AnchorOffset(Anchors.TOP_RIGHT, Anchors.TOP_RIGHT, Offset.offset((int)-20, (int)20)));
            }
            case "bottomLeft": {
                return new AbsolutePositionLayoutSpec(new AnchorOffset(Anchors.BOTTOM_LEFT, Anchors.BOTTOM_LEFT, Offset.offset((int)20, (int)-20)));
            }
            case "bottomRight": {
                return new AbsolutePositionLayoutSpec(new AnchorOffset(Anchors.BOTTOM_RIGHT, Anchors.BOTTOM_RIGHT, Offset.offset((int)-20, (int)-20)));
            }
        }
        throw new IllegalStateException("Unknown watermark position: " + watermarkPosition);
    }

    private void addElement(MediaPackage mediaPackage, MediaPackageElementFlavor flavor, List<String> tags, InputStream file, String filename, MediaPackageElement.Type type) throws IOException {
        MediaPackageElement element = elementBuilderFactory.newElementBuilder().newElement(type, flavor);
        element.setIdentifier(UUID.randomUUID().toString());
        for (String tag : tags) {
            element.addTag(tag);
        }
        URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), element.getIdentifier(), filename, file);
        element.setURI(uri);
        try {
            MimeType mimeType = MimeTypes.fromString((String)filename);
            element.setMimeType(mimeType);
        }
        catch (UnknownFileTypeException e) {
            logger.warn("Unable to detect the mime type of file {}", (Object)filename);
        }
        mediaPackage.add(element);
    }
}

