/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.textanalyzer.impl.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.textanalyzer.api.TextAnalyzerService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@RestService(name="textanalysis", title="Text Analysis Service", abstractText="This service enables conversion from one caption format to another.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=false, service={TextAnalysisRestEndpoint.class}, property={"service.description=Text Analysis REST Endpoint", "opencast.service.type=org.opencastproject.textanalyzer", "opencast.service.path=/analysis/text", "opencast.service.jobproducer=true"})
public class TextAnalysisRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(TextAnalysisRestEndpoint.class);
    protected TextAnalyzerService service;
    protected ServiceRegistry serviceRegistry = null;

    @Activate
    public void activate(ComponentContext cc) {
    }

    @POST
    @Produces(value={"text/xml"})
    @Path(value="")
    @RestQuery(name="analyze", description="Submit a track for analysis.", restParameters={@RestParameter(description="The image to analyze for text.", isRequired=true, name="image", type=RestParameter.Type.FILE)}, responses={@RestResponse(description="OK, The receipt to use when polling for the resulting mpeg7 catalog.", responseCode=200), @RestResponse(description="The argument cannot be parsed into a media package element.", responseCode=400), @RestResponse(description="The service is unavailable at the moment.", responseCode=503)}, returnDescription="The receipt to use when polling for the resulting mpeg7 catalog.")
    public Response analyze(@FormParam(value="image") String image) {
        if (this.service == null) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        try {
            MediaPackageElement element = MediaPackageElementParser.getFromXml((String)image);
            if (!(element instanceof Attachment)) {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
            Job job = this.service.extract((Attachment)element);
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    protected void setTextAnalyzer(TextAnalyzerService textAnalyzer) {
        this.service = textAnalyzer;
    }

    public JobProducer getService() {
        if (this.service instanceof JobProducer) {
            return (JobProducer)this.service;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

