/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.terminationstate.endpoint.aws;

import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.simple.JSONObject;
import org.opencastproject.terminationstate.api.TerminationStateService;
import org.opencastproject.terminationstate.endpoint.api.TerminationStateRestService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/termination/aws/autoscaling")
@RestService(name="terminationstateservice", title="Termination State Service: AWS Auto Scaling", abstractText="This service responds to notifications from an AWS AutoScaling Group that the underlying EC2 instance is terminating. When put into a termination 'wait' state, it stops the node accepting further jobs, and will inform AWS AutoScaling, once any running jobs complete, that the instance can be terminated. NOTE: The service does not actually shut down the node or instance.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/termination/aws/autoscaling)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={AutoScalingTerminationStateRestService.class}, property={"service.description=Termination State Rest Service: AWS Auto Scaling", "opencast.service.type=org.opencastproject.terminationstate.aws.autoscaling", "opencast.service.path=/termination/aws/autoscaling"})
@JaxrsResource
public class AutoScalingTerminationStateRestService
implements TerminationStateRestService {
    private static final Logger logger = LoggerFactory.getLogger(AutoScalingTerminationStateRestService.class);
    private TerminationStateService service;

    @GET
    @Path(value="/state")
    @Produces(value={"application/json"})
    @RestQuery(name="stateasjson", description="Returns the Termination State as JSON. Possible termination states are none, wait and ready.", returnDescription="A JSON representation of the termination state.", responses={@RestResponse(responseCode=200, description="A JSON representation of the termination state."), @RestResponse(responseCode=503, description="The AWS Autoscaling Termination State Service is disabled or unavailable")})
    public Response getState() {
        if (this.service != null) {
            JSONObject json = new JSONObject();
            String state = this.service.getState().toString();
            json.put((Object)"state", (Object)state);
            return Response.ok((Object)json.toJSONString()).build();
        }
        logger.error("TerminationStateService is not available");
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    @PUT
    @Path(value="/state")
    @RestQuery(name="setstate", description="Set the termination state. The only permissable value to write to the state is 'wait'", returnDescription="Whether the termination state was set successfully", restParameters={@RestParameter(name="state", type=RestParameter.Type.STRING, defaultValue="wait", description="The termination state, the only valid value is 'wait'", isRequired=false)}, responses={@RestResponse(responseCode=204, description="The node is preparing to terminate"), @RestResponse(responseCode=400, description="The state was not 'wait'"), @RestResponse(responseCode=503, description="The AWS Autoscaling Termination State Service is disabled or unavailable")})
    public Response setState(@FormParam(value="state") String state) {
        if (this.service != null) {
            if (TerminationStateService.TerminationState.WAIT.toString().equalsIgnoreCase(state)) {
                this.service.setState(TerminationStateService.TerminationState.WAIT);
                if (this.service.getState() != TerminationStateService.TerminationState.NONE) {
                    return Response.noContent().build();
                }
            } else {
                logger.error("state must be 'wait'");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        logger.error("AWS Autoscaling Termination State Serice is not available");
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }

    @Reference(target="(&(vendor.name=aws)(vendor.service=autoscaling))")
    public void setService(TerminationStateService service) {
        this.service = service;
    }
}

