/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.terminationstate.aws;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.autoscaling.AmazonAutoScaling;
import com.amazonaws.services.autoscaling.AmazonAutoScalingClientBuilder;
import com.amazonaws.services.autoscaling.model.AutoScalingGroup;
import com.amazonaws.services.autoscaling.model.AutoScalingInstanceDetails;
import com.amazonaws.services.autoscaling.model.CompleteLifecycleActionRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingGroupsResult;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import com.amazonaws.services.autoscaling.model.DescribeAutoScalingInstancesResult;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksRequest;
import com.amazonaws.services.autoscaling.model.DescribeLifecycleHooksResult;
import com.amazonaws.services.autoscaling.model.LifecycleHook;
import com.amazonaws.services.autoscaling.model.LifecycleState;
import com.amazonaws.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;
import com.amazonaws.util.EC2MetadataUtils;
import java.util.Dictionary;
import java.util.List;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.terminationstate.api.AbstractJobTerminationStateService;
import org.opencastproject.terminationstate.api.TerminationStateService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TerminationStateService.class}, property={"service.description=Termination State Service: AWS Auto Scaling", "service.pid=org.opencastproject.terminationstate.aws.AutoScalingTerminationStateService", "vendor.name=aws", "vendor.service=autoscaling"})
public final class AutoScalingTerminationStateService
extends AbstractJobTerminationStateService {
    private static final Logger logger = LoggerFactory.getLogger(AutoScalingTerminationStateService.class);
    private static final String AUTOSCALING_INSTANCE_TERMINATING = "autoscaling:EC2_INSTANCE_TERMINATING";
    public static final String CONFIG_ENABLE = "enable";
    public static final String CONFIG_LIFECYCLE_POLLING_ENABLE = "lifecycle.polling.enable";
    public static final String CONFIG_LIFECYCLE_POLLING_PERIOD = "lifecycle.polling.period";
    public static final String CONFIG_LIFECYCLE_HEARTBEAT_PERIOD = "lifecycle.heartbeat.period";
    public static final String CONFIG_AWS_ACCESS_KEY_ID = "access.id";
    public static final String CONFIG_AWS_SECRET_ACCESS_KEY = "access.secret";
    private static final boolean DEFAULT_ENABLE = false;
    private static final boolean DEFAULT_LIFECYCLE_POLLING_ENABLE = true;
    private static final int DEFAULT_LIFECYCLE_POLLING_PERIOD = 300;
    private static final int DEFAULT_LIFECYCLE_HEARTBEAT_PERIOD = 300;
    protected static final String SCHEDULE_GROUP = AbstractJobTerminationStateService.class.getSimpleName();
    protected static final String SCHEDULE_LIFECYCLE_POLLING_JOB = "PollLifeCycle";
    protected static final String SCHEDULE_LIFECYCLE_HEARTBEAT_JOB = "PollTerminationState";
    protected static final String SCHEDULE_LIFECYCLE_POLLING_TRIGGER = "TriggerPollLifeCycle";
    protected static final String SCHEDULE_LIFECYCLE_HEARTBEAT_TRIGGER = "TriggerHeartbeat";
    protected static final String SCHEDULE_JOB_PARAM_PARENT = "parent";
    private String instanceId;
    private AWSCredentialsProvider credentials;
    private AmazonAutoScaling autoScaling;
    private AutoScalingGroup autoScalingGroup;
    private LifecycleHook lifeCycleHook;
    private Scheduler scheduler;
    private boolean enabled = false;
    private boolean lifecyclePolling = true;
    private int lifecyclePollingPeriod = 300;
    private int lifecycleHeartbeatPeriod = 300;
    private Option<String> accessKeyIdOpt = Option.none();
    private Option<String> accessKeySecretOpt = Option.none();

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            this.configure(componentContext.getProperties());
        }
        catch (ConfigurationException e) {
            logger.error("Unable to read configuration, using defaults", (Throwable)e);
        }
        if (!this.enabled) {
            logger.info("Service is disabled by configuration");
            return;
        }
        try {
            String host = this.getServiceRegistry().getRegistryHostname();
            this.getServiceRegistry().setMaintenanceStatus(host, false);
        }
        catch (ServiceRegistryException | NotFoundException e) {
            logger.error("Cannot take this host out of maintenance", e);
        }
        this.credentials = this.accessKeyIdOpt.isNone() && this.accessKeySecretOpt.isNone() ? new DefaultAWSCredentialsProviderChain() : new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials((String)this.accessKeyIdOpt.get(), (String)this.accessKeySecretOpt.get()));
        this.instanceId = EC2MetadataUtils.getInstanceId();
        logger.debug("Instance Id is {}", (Object)this.instanceId);
        if (this.instanceId == null) {
            logger.error("Unable to contact AWS metadata endpoint, Is this node running in AWS EC2?");
            return;
        }
        try {
            this.autoScaling = (AmazonAutoScaling)((AmazonAutoScalingClientBuilder)((AmazonAutoScalingClientBuilder)AmazonAutoScalingClientBuilder.standard().withRegion(EC2MetadataUtils.getEC2InstanceRegion())).withCredentials(this.credentials)).build();
            logger.debug("Created AutoScalingClient {}", (Object)this.autoScaling.toString());
            String autoScalingGroupName = this.getAutoScalingGroupName();
            logger.debug("Auto scaling group name : {}", (Object)autoScalingGroupName);
            if (autoScalingGroupName == null) {
                logger.error("AWS Instance {} is not part of an auto scaling group. Polling will be disabled", (Object)this.instanceId);
                this.stop();
                return;
            }
            this.autoScalingGroup = this.getAutoScalingGroup(autoScalingGroupName);
            if (this.autoScalingGroup == null) {
                logger.error("Unable to get Auto Scaling Group {}. Polling will be disabled", (Object)autoScalingGroupName);
                this.stop();
                return;
            }
            this.lifeCycleHook = this.getLifecycleHook(autoScalingGroupName);
            if (this.lifeCycleHook == null) {
                logger.error("Auto scaling group {} does not have a termination stage hook. Polling will be disabled", (Object)autoScalingGroupName);
                this.stop();
                return;
            }
            if (this.lifecycleHeartbeatPeriod > this.lifeCycleHook.getHeartbeatTimeout()) {
                logger.warn("Lifecycle Heartbeat Period {} is greater than LifecycleHook's HeartbeatTimeout {}, see https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html", (Object)this.lifecycleHeartbeatPeriod, (Object)this.lifeCycleHook.getHeartbeatTimeout());
            }
        }
        catch (AmazonServiceException e) {
            logger.error("EC2 Autoscaling returned an error", (Throwable)e);
            this.stop();
            return;
        }
        catch (AmazonClientException e) {
            logger.error("AWS client can't communicate with EC2 Autoscaling", (Throwable)e);
            this.stop();
            return;
        }
        try {
            this.scheduler = new StdSchedulerFactory().getScheduler();
        }
        catch (SchedulerException e) {
            logger.error("Cannot create quartz scheduler", (Throwable)e);
        }
        if (this.lifecyclePolling && this.lifecyclePollingPeriod > 0) {
            this.startPollingLifeCycleHook();
        }
    }

    private String getAutoScalingGroupName() {
        DescribeAutoScalingInstancesRequest request = new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{this.instanceId});
        DescribeAutoScalingInstancesResult result = this.autoScaling.describeAutoScalingInstances(request);
        List instances = result.getAutoScalingInstances();
        logger.debug("Found {} autoscaling instances", (Object)instances.size());
        if (!instances.isEmpty()) {
            AutoScalingInstanceDetails autoScalingInstance = (AutoScalingInstanceDetails)instances.get(0);
            return autoScalingInstance.getAutoScalingGroupName();
        }
        return null;
    }

    private AutoScalingGroup getAutoScalingGroup(String autoScalingGroupName) {
        DescribeAutoScalingGroupsRequest request = new DescribeAutoScalingGroupsRequest().withAutoScalingGroupNames(new String[]{autoScalingGroupName});
        DescribeAutoScalingGroupsResult result = this.autoScaling.describeAutoScalingGroups(request);
        List groups = result.getAutoScalingGroups();
        if (!groups.isEmpty()) {
            AutoScalingGroup group = (AutoScalingGroup)groups.get(0);
            return group;
        }
        return null;
    }

    private LifecycleHook getLifecycleHook(String autoScalingGroupName) {
        DescribeLifecycleHooksRequest request = new DescribeLifecycleHooksRequest().withAutoScalingGroupName(autoScalingGroupName);
        DescribeLifecycleHooksResult result = this.autoScaling.describeLifecycleHooks(request);
        for (LifecycleHook hook : result.getLifecycleHooks()) {
            if (!AUTOSCALING_INSTANCE_TERMINATING.equalsIgnoreCase(hook.getLifecycleTransition())) continue;
            return hook;
        }
        return null;
    }

    protected void configure(Dictionary config) throws ConfigurationException {
        this.enabled = (Boolean)OsgiUtil.getOptCfgAsBoolean((Dictionary)config, (String)CONFIG_ENABLE).getOrElse((Object)false);
        this.lifecyclePolling = (Boolean)OsgiUtil.getOptCfgAsBoolean((Dictionary)config, (String)CONFIG_LIFECYCLE_POLLING_ENABLE).getOrElse((Object)true);
        this.lifecyclePollingPeriod = (Integer)OsgiUtil.getOptCfgAsInt((Dictionary)config, (String)CONFIG_LIFECYCLE_POLLING_PERIOD).getOrElse((Object)300);
        this.lifecycleHeartbeatPeriod = (Integer)OsgiUtil.getOptCfgAsInt((Dictionary)config, (String)CONFIG_LIFECYCLE_HEARTBEAT_PERIOD).getOrElse((Object)300);
        this.accessKeyIdOpt = OsgiUtil.getOptCfg((Dictionary)config, (String)CONFIG_AWS_ACCESS_KEY_ID);
        this.accessKeySecretOpt = OsgiUtil.getOptCfg((Dictionary)config, (String)CONFIG_AWS_SECRET_ACCESS_KEY);
    }

    public void setState(TerminationStateService.TerminationState state) {
        if (this.enabled && this.autoScaling != null) {
            super.setState(state);
            if (this.getState() != TerminationStateService.TerminationState.NONE) {
                if (this.lifecyclePolling) {
                    this.stopPollingLifeCycleHook();
                }
                try {
                    String host = this.getServiceRegistry().getRegistryHostname();
                    this.getServiceRegistry().setMaintenanceStatus(host, true);
                }
                catch (ServiceRegistryException | NotFoundException e) {
                    logger.error("Cannot put this host into maintenance", e);
                }
                this.startPollingTerminationState();
            }
        }
    }

    protected void startPollingLifeCycleHook() {
        try {
            JobDetail job = new JobDetail(SCHEDULE_GROUP, SCHEDULE_LIFECYCLE_POLLING_JOB, CheckLifeCycleState.class);
            job.getJobDataMap().put((Object)SCHEDULE_JOB_PARAM_PARENT, (Object)this);
            Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)this.lifecyclePollingPeriod);
            trigger.setGroup(SCHEDULE_GROUP);
            trigger.setName(SCHEDULE_LIFECYCLE_POLLING_TRIGGER);
            this.scheduler.scheduleJob(job, trigger);
            this.scheduler.start();
            logger.info("Started polling for Lifecycle state change");
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void stopPollingLifeCycleHook() {
        try {
            this.scheduler.deleteJob(SCHEDULE_GROUP, SCHEDULE_LIFECYCLE_POLLING_JOB);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    protected void startPollingTerminationState() {
        try {
            JobDetail job = new JobDetail(SCHEDULE_GROUP, SCHEDULE_LIFECYCLE_HEARTBEAT_JOB, CheckTerminationState.class);
            job.getJobDataMap().put((Object)SCHEDULE_JOB_PARAM_PARENT, (Object)this);
            Trigger trigger = TriggerUtils.makeSecondlyTrigger((int)this.lifecycleHeartbeatPeriod);
            trigger.setGroup(SCHEDULE_GROUP);
            trigger.setName(SCHEDULE_LIFECYCLE_HEARTBEAT_TRIGGER);
            this.scheduler.scheduleJob(job, trigger);
            this.scheduler.start();
            logger.info("Started emitting heartbeat until jobs are complete");
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void stopPollingTerminationState() {
        try {
            this.scheduler.deleteJob(SCHEDULE_GROUP, SCHEDULE_LIFECYCLE_HEARTBEAT_JOB);
        }
        catch (SchedulerException schedulerException) {
            // empty catch block
        }
    }

    private void stop() {
        this.lifecyclePolling = false;
        if (this.autoScaling != null) {
            this.autoScaling.shutdown();
            this.autoScaling = null;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (SchedulerException e) {
            logger.error("Failed to stop scheduler", (Throwable)e);
        }
    }

    @Deactivate
    public void deactivate() {
        this.stop();
    }

    protected void setAutoScaling(AmazonAutoScaling autoScaling) {
        this.autoScaling = autoScaling;
    }

    protected void setAutoScalingGroup(AutoScalingGroup autoScalingGroup) {
        this.autoScalingGroup = autoScalingGroup;
    }

    protected void setLifecycleHook(LifecycleHook lifecycleHook) {
        this.lifeCycleHook = lifecycleHook;
    }

    protected void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public static class CheckLifeCycleState
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            DescribeAutoScalingInstancesRequest request;
            DescribeAutoScalingInstancesResult result;
            List instances;
            AutoScalingTerminationStateService parent = (AutoScalingTerminationStateService)((Object)context.getJobDetail().getJobDataMap().get((Object)AutoScalingTerminationStateService.SCHEDULE_JOB_PARAM_PARENT));
            if (parent.autoScaling != null && !(instances = (result = parent.autoScaling.describeAutoScalingInstances(request = new DescribeAutoScalingInstancesRequest().withInstanceIds(new String[]{parent.instanceId}))).getAutoScalingInstances()).isEmpty()) {
                AutoScalingInstanceDetails autoScalingInstance = (AutoScalingInstanceDetails)instances.get(0);
                if (LifecycleState.TerminatingWait.toString().equalsIgnoreCase(autoScalingInstance.getLifecycleState())) {
                    logger.info("Lifecycle state changed to Terminating:Wait");
                    parent.stopPollingLifeCycleHook();
                    parent.setState(TerminationStateService.TerminationState.WAIT);
                } else {
                    logger.debug("Lifecycle state is {}", (Object)autoScalingInstance.getLifecycleState());
                }
            }
        }
    }

    public static class CheckTerminationState
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            AutoScalingTerminationStateService parent = (AutoScalingTerminationStateService)((Object)context.getJobDetail().getJobDataMap().get((Object)AutoScalingTerminationStateService.SCHEDULE_JOB_PARAM_PARENT));
            if (parent.readyToTerminate()) {
                logger.debug("No jobs running, trying to complete Lifecycle action");
                if (parent.autoScaling != null) {
                    CompleteLifecycleActionRequest request = new CompleteLifecycleActionRequest().withLifecycleActionResult("CONTINUE").withAutoScalingGroupName(parent.autoScalingGroup.getAutoScalingGroupName()).withLifecycleHookName(parent.lifeCycleHook.getLifecycleHookName()).withInstanceId(parent.instanceId);
                    parent.autoScaling.completeLifecycleAction(request);
                    logger.info("No jobs running, sent complete Lifecycle action");
                }
                parent.stopPollingTerminationState();
            } else if (parent.getState() == TerminationStateService.TerminationState.WAIT) {
                logger.debug("Jobs still running, trying to send Lifecycle heartbeat");
                if (parent.autoScaling != null) {
                    RecordLifecycleActionHeartbeatRequest request = new RecordLifecycleActionHeartbeatRequest().withAutoScalingGroupName(parent.autoScalingGroup.getAutoScalingGroupName()).withLifecycleHookName(parent.lifeCycleHook.getLifecycleHookName()).withInstanceId(parent.instanceId);
                    parent.autoScaling.recordLifecycleActionHeartbeat(request);
                    logger.info("Jobs still running, sent Lifecycle heartbeat");
                }
            }
        }
    }
}

