/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.subtitletimeshift;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.subtitleparser.webvttparser.WebVTTParser;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitle;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleCue;
import org.opencastproject.subtitleparser.webvttparser.WebVTTWriter;
import org.opencastproject.util.Checksum;
import org.opencastproject.util.ChecksumType;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=subtitle-timeshift Workflow Operation Handler", "workflow.operation=subtitle-timeshift"}, immediate=true, service={WorkflowOperationHandler.class})
public class SubtitleTimeshiftWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String SUBTITLE_SOURCE_FLAVOR_CFG_KEY = "subtitle-source-flavor";
    private static final String VIDEO_SOURCE_FLAVOR_CFG_KEY = "video-source-flavor";
    private static final String TARGET_FLAVOR_CFG_KEY = "target-flavor";
    private static final String COLLECTION = "subtitles";
    private static final Logger logger = LoggerFactory.getLogger(SubtitleTimeshiftWorkflowOperationHandler.class);
    private Workspace workspace = null;

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Track videoTrack;
        Track[] originalSubtitleTracks;
        MediaPackageElementFlavor configuredTargetFlavor;
        MediaPackageElementFlavor configuredVideoFlavor;
        MediaPackageElementFlavor configuredSubtitleFlavor;
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Starting subtitle timeshift workflow for mediapackage: {}", (Object)mediaPackage.getIdentifier().toString());
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        try {
            configuredSubtitleFlavor = MediaPackageElementFlavor.parseFlavor((String)Objects.toString(operation.getConfiguration(SUBTITLE_SOURCE_FLAVOR_CFG_KEY)));
            configuredVideoFlavor = MediaPackageElementFlavor.parseFlavor((String)operation.getConfiguration(VIDEO_SOURCE_FLAVOR_CFG_KEY));
            configuredTargetFlavor = MediaPackageElementFlavor.parseFlavor((String)operation.getConfiguration(TARGET_FLAVOR_CFG_KEY));
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Couldn't parse subtitle-timeshift workflow configurations.", (Throwable)e);
        }
        try {
            Track[] subtitleTracks = mediaPackage.getTracks(configuredSubtitleFlavor);
            Track[] videoTracks = mediaPackage.getTracks(configuredVideoFlavor);
            if (subtitleTracks.length == 0) {
                logger.info("No subtitle track found with flavor {}. Skipping subtitle-timeshift workflow operation for mediapackage {}", (Object)configuredSubtitleFlavor, (Object)mediaPackage.getIdentifier());
                return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
            }
            if (videoTracks.length != 1) {
                throw new IllegalStateException(String.format("Found %d video tracks with flavor %s in mediapackage %s for subtitle-timeshift operation. Expected exactly 1 video track. Please check you workflow configuration.", videoTracks.length, configuredVideoFlavor, mediaPackage.getIdentifier()));
            }
            originalSubtitleTracks = subtitleTracks;
            videoTrack = videoTracks[0];
            logger.info("Valid tracks found. Start shifting subtitle tracks by duration from video '{}'", (Object)videoTrack);
        }
        catch (Exception e) {
            logger.error("Error in subtitle-timeshift workflow while getting tracks for mediapackage {}", (Object)mediaPackage.getIdentifier(), (Object)e);
            throw new WorkflowOperationException((Throwable)e);
        }
        try {
            for (Track originalSubtitleTrack : originalSubtitleTracks) {
                WebVTTSubtitle newSubtitleFile = this.loadAndParseSubtitleFile(originalSubtitleTrack);
                this.shiftTime(newSubtitleFile, videoTrack.getDuration());
                String originalFileName = FilenameUtils.getBaseName((String)originalSubtitleTrack.getLogicalName());
                String newFileName = "timeshifted-" + originalFileName + ".vtt";
                URI newSubtitleFileUri = this.saveSubtitleFileToWorkspace(newSubtitleFile, newFileName);
                Track newSubtitleTrack = this.createNewTrackFromSubtitleUri(newSubtitleFileUri, configuredTargetFlavor, originalSubtitleTrack);
                mediaPackage.add(newSubtitleTrack);
                logger.info("Added subtitle track with URI {} to mediapackage {}", (Object)newSubtitleFileUri, (Object)mediaPackage.getIdentifier());
            }
        }
        catch (Exception e) {
            logger.error("Error while shifting time of subtitle tracks for mediapackage {}", (Object)mediaPackage.getIdentifier(), (Object)e);
            throw new WorkflowOperationException((Throwable)e);
        }
        logger.info("Subtitle-Timeshift workflow operation for media package {} completed", (Object)mediaPackage);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private Track createNewTrackFromSubtitleUri(URI subtitleFile, MediaPackageElementFlavor targetFlavor, Track originalSubtitleTrack) throws IOException, NotFoundException {
        String id = UUID.randomUUID().toString();
        Track newSubtitleTrack = (Track)originalSubtitleTrack.clone();
        newSubtitleTrack.setIdentifier(id);
        newSubtitleTrack.setFlavor(targetFlavor);
        newSubtitleTrack.setURI(subtitleFile);
        newSubtitleTrack.setChecksum(Checksum.create((ChecksumType)ChecksumType.DEFAULT_TYPE, (File)this.workspace.get(subtitleFile, true)));
        return newSubtitleTrack;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private URI saveSubtitleFileToWorkspace(WebVTTSubtitle webVTTSubtitle, String fileName) throws WorkflowOperationException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            URI uRI;
            WebVTTWriter writer = new WebVTTWriter();
            writer.write(webVTTSubtitle, (OutputStream)outputStream);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());){
                uRI = this.workspace.putInCollection(COLLECTION, fileName, (InputStream)inputStream);
            }
            return uRI;
        }
        catch (IOException e) {
            logger.error("An exception occurred while parsing and saving a subtitle file to the workspace", (Throwable)e);
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private WebVTTSubtitle loadAndParseSubtitleFile(Track subtitleTrack) throws WorkflowOperationException {
        WebVTTSubtitle subtitle;
        File subtitleFile;
        try {
            subtitleFile = this.workspace.get(subtitleTrack.getURI());
        }
        catch (IOException ex) {
            throw new WorkflowOperationException("Can't read " + String.valueOf(subtitleTrack.getURI()));
        }
        catch (NotFoundException ex) {
            throw new WorkflowOperationException("Workspace does not contain a track " + String.valueOf(subtitleTrack.getURI()));
        }
        try (FileInputStream fin = new FileInputStream(subtitleFile);){
            subtitle = new WebVTTParser().parse((InputStream)fin);
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Couldn't parse subtitle file " + String.valueOf(subtitleTrack.getURI()), (Throwable)e);
        }
        return subtitle;
    }

    public void shiftTime(WebVTTSubtitle subtitleFile, long time) {
        for (WebVTTSubtitleCue cue : subtitleFile.getCues()) {
            long start = cue.getStartTime();
            long end = cue.getEndTime();
            cue.setStartTime(start + time);
            cue.setEndTime(end + time);
        }
    }
}

